/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.entity.EntityUtils;
import de.maxhenkel.car.corelib.net.NetUtils;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityBase
extends BlockEntity
implements Nameable {
    private Component name;
    private CompoundTag compoundLast;

    public TileEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void synchronize() {
        if (!this.f_58857_.f_46443_ && this.f_58857_ instanceof ServerLevel) {
            CompoundTag last = this.m_6945_(new CompoundTag());
            if (this.compoundLast == null || !this.compoundLast.equals((Object)last)) {
                ServerLevel serverWorld = (ServerLevel)this.f_58857_;
                MessageSyncTileEntity msg = new MessageSyncTileEntity(this.f_58858_, last);
                EntityUtils.forEachPlayerAround(serverWorld, this.f_58858_, 128.0, playerEntity -> NetUtils.sendTo(Main.SIMPLE_CHANNEL, playerEntity, msg));
                this.compoundLast = last;
            }
        }
    }

    public void synchronize(int ticks) {
        if (this.f_58857_.m_46467_() % (long)ticks == 0L) {
            this.synchronize();
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public abstract Component getTranslatedName();

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getTranslatedName();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public abstract ContainerData getFields();

    public CompoundTag m_6945_(CompoundTag compound) {
        if (this.name != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("CustomName")) {
            this.name = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        super.m_142466_(compound);
    }
}

