/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import de.maxhenkel.tools.BlockPosList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCable
extends TileEntityBase
implements ITickableBlockEntity,
IEnergyStorage {
    private final int transferRate;

    public TileEntityCable(int transferRate, BlockPos pos, BlockState state) {
        super(Main.CABLE_TILE_ENTITY_TYPE, pos, state);
        this.transferRate = transferRate;
    }

    public TileEntityCable(BlockPos pos, BlockState state) {
        this((Integer)Main.SERVER_CONFIG.cableTransferRate.get(), pos, state);
    }

    @Override
    public void tick() {
        int energy = 0;
        ArrayList<IEnergyStorage> providers = new ArrayList<IEnergyStorage>();
        for (Direction facing : Direction.values()) {
            IEnergyStorage provider = EnergyUtils.getEnergyStorageOffset((LevelAccessor)this.f_58857_, this.f_58858_, facing);
            if (provider == null || provider instanceof TileEntityCable) continue;
            int cex = Math.max(0, this.transferRate - energy);
            if (cex <= 0) break;
            int extract = provider.extractEnergy(cex, true);
            if (extract <= 0) continue;
            energy += extract;
            providers.add(provider);
        }
        if (energy <= 0) {
            return;
        }
        ArrayList<IEnergyStorage> receivers = new ArrayList<IEnergyStorage>();
        this.getConnectedReceivers(providers, receivers, new BlockPosList(), this.f_58858_);
        if (receivers.size() <= 0) {
            return;
        }
        int split = energy / receivers.size();
        if (split <= 0) {
            return;
        }
        int received = 0;
        for (IEnergyStorage entry : receivers) {
            received += entry.receiveEnergy(split, false);
        }
        for (IEnergyStorage entry : providers) {
            if (received <= 0) break;
            received -= entry.extractEnergy(received, false);
        }
    }

    public void getConnectedReceivers(List<IEnergyStorage> sources, List<IEnergyStorage> receivers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.m_142300_(side);
            if (positions.contains(p)) continue;
            BlockState state = this.f_58857_.m_8055_(p);
            if (state.m_60734_().equals(ModBlocks.CABLE)) {
                positions.add(p);
                this.getConnectedReceivers(sources, receivers, positions, p);
                continue;
            }
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset((LevelAccessor)this.f_58857_, pos, side);
            if (storage == null || storage.equals(this) || sources.contains(storage) || receivers.contains(storage)) continue;
            receivers.add(storage);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public Component getTranslatedName() {
        return new TranslatableComponent("block.car.cable");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

