/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockCarWorkshopOutter;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartRegistry;
import de.maxhenkel.car.items.ICarPart;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class TileEntityCarWorkshop
extends TileEntityBase
implements Container {
    private SimpleContainer craftingMatrix = new SimpleContainer(15);
    private SimpleContainer repairInventory = new SimpleContainer(3);
    private EntityGenericCar currentCraftingCar;
    private List<Component> messages = new ArrayList<Component>();

    public TileEntityCarWorkshop(BlockPos pos, BlockState state) {
        super(Main.CAR_WORKSHOP_TILE_ENTITY_TYPE, pos, state);
    }

    public SimpleContainer getRepairInventory() {
        return this.repairInventory;
    }

    public EntityCarBase getCarOnTop() {
        BlockState ownState = this.f_58857_.m_8055_(this.f_58858_);
        if (!ownState.m_60734_().equals(ModBlocks.CAR_WORKSHOP)) {
            return null;
        }
        BlockPos start = this.f_58858_.m_142300_(Direction.UP);
        AABB aabb = new AABB((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_(), (double)(start.m_123341_() + 1), (double)(start.m_123342_() + 1), (double)(start.m_123343_() + 1));
        List cars = this.f_58857_.m_45976_(EntityCarBase.class, aabb);
        if (cars.isEmpty()) {
            return null;
        }
        return (EntityCarBase)((Object)cars.get(0));
    }

    public void spawnCar(Player player) {
        if (!this.areBlocksAround()) {
            player.m_6352_((Component)new TranslatableComponent("message.incomplete_structure"), Util.f_137441_);
            return;
        }
        if (!this.isTopFree()) {
            player.m_6352_((Component)new TranslatableComponent("message.blocks_on_top"), Util.f_137441_);
            return;
        }
        this.updateRecipe();
        EntityGenericCar car = this.currentCraftingCar;
        if (car == null || !this.isCurrentCraftingCarValid()) {
            player.m_6352_((Component)new TranslatableComponent("message.no_reciepe"), Util.f_137441_);
            return;
        }
        BlockPos spawnPos = this.f_58858_.m_7494_();
        car.m_6034_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
        this.removeCraftItems();
        car.setFuelAmount(100);
        this.f_58857_.m_7967_((Entity)car);
        car.setIsSpawned(true);
        car.initTemperature();
    }

    public void checkValidity() {
        if (this.areBlocksAround()) {
            this.placeStructure();
        }
    }

    private void placeStructure() {
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(0, 0, -1), this.getState(1));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(1, 0, -1), this.getState(2));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(1, 0, 0), this.getState(3));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(1, 0, 1), this.getState(4));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(0, 0, 1), this.getState(5));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(-1, 0, 1), this.getState(6));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(-1, 0, 0), this.getState(7));
        this.f_58857_.m_46597_(this.f_58858_.m_142082_(-1, 0, -1), this.getState(8));
        this.setOwnBlockValid(true);
    }

    private void setOwnBlockValid(boolean valid) {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (!state.m_60734_().equals(ModBlocks.CAR_WORKSHOP)) {
            return;
        }
        ModBlocks.CAR_WORKSHOP.setValid(this.f_58857_, this.f_58858_, state, valid);
    }

    private BlockState getState(int meta) {
        return (BlockState)ModBlocks.CAR_WORKSHOP_OUTTER.m_49966_().m_61124_((Property)BlockCarWorkshopOutter.POSITION, (Comparable)Integer.valueOf(meta));
    }

    public boolean areBlocksAround() {
        if (!this.checkSideBlock(this.f_58858_.m_142082_(0, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(1, 0, 1))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(0, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(-1, 0, 0))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(-1, 0, -1))) {
            return false;
        }
        if (!this.checkSideBlock(this.f_58858_.m_142082_(-1, 0, 1))) {
            return false;
        }
        return this.checkSideBlock(this.f_58858_.m_142082_(1, 0, -1));
    }

    public boolean isTopFree() {
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (this.checkBlockAir(this.f_58858_.m_142082_(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkBlockAir(BlockPos p) {
        return this.f_58857_.m_46859_(p);
    }

    private boolean checkSideBlock(BlockPos p) {
        return this.f_58857_.m_8055_(p).m_60734_().equals(ModBlocks.CAR_WORKSHOP_OUTTER);
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        ItemUtils.saveInventory(compound, "crafting", (Container)this.craftingMatrix);
        ItemUtils.saveInventory(compound, "repair", (Container)this.repairInventory);
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ItemUtils.readInventory(compound, "crafting", (Container)this.craftingMatrix);
        ItemUtils.readInventory(compound, "repair", (Container)this.repairInventory);
        super.m_142466_(compound);
    }

    public void updateRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.craftingMatrix.m_6643_(); ++i) {
            ItemStack stack = this.craftingMatrix.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICarPart) {
                if (((ICarPart)stack.m_41720_()).getPart(stack) == null) continue;
                items.add(stack);
                continue;
            }
            this.currentCraftingCar = null;
            this.messages = Arrays.asList(new TranslatableComponent("message.parts.no_car_part", new Object[]{stack.m_41786_()}));
            return;
        }
        ArrayList<Component> messages = new ArrayList<Component>();
        this.currentCraftingCar = TileEntityCarWorkshop.createCar(this.f_58857_, items, messages);
        this.messages = messages;
    }

    public static EntityGenericCar createCar(Level world, List<ItemStack> partStacks, List<Component> messages) {
        EntityGenericCar car = new EntityGenericCar(world);
        car.m_6836_(0, ItemKey.getKeyForCar(car.m_142081_()));
        car.m_6836_(1, ItemKey.getKeyForCar(car.m_142081_()));
        car.setIsSpawned(false);
        for (int i = 0; i < partStacks.size(); ++i) {
            car.getPartInventory().m_6836_(i, partStacks.get(i).m_41777_().m_41620_(1));
        }
        car.initParts();
        boolean showable = PartRegistry.isValid(car, messages);
        if (!showable) {
            return null;
        }
        car.tryInitPartsAndModel();
        car.setPartSerializer();
        return car;
    }

    public static EntityGenericCar createCar(Level world, List<ItemStack> partStacks) {
        return TileEntityCarWorkshop.createCar(world, partStacks, new ArrayList<Component>());
    }

    public void removeCraftItems() {
        for (int i = 0; i < this.craftingMatrix.m_6643_(); ++i) {
            ItemStack stack = this.craftingMatrix.m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.m_41774_(1);
        }
    }

    public int m_6643_() {
        return this.craftingMatrix.m_6643_();
    }

    public ItemStack m_8020_(int index) {
        return this.craftingMatrix.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.craftingMatrix.m_7407_(index, count);
        this.updateRecipe();
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.craftingMatrix.m_8016_(index);
        this.updateRecipe();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.craftingMatrix.m_6836_(index, stack);
        this.updateRecipe();
    }

    public int m_6893_() {
        return this.craftingMatrix.m_6893_();
    }

    public boolean m_6542_(Player player) {
        return this.craftingMatrix.m_6542_(player);
    }

    public boolean m_7983_() {
        return this.craftingMatrix.m_7983_();
    }

    public void m_5856_(Player player) {
        this.craftingMatrix.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.craftingMatrix.m_5856_(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.craftingMatrix.m_7013_(index, stack);
    }

    public void m_6211_() {
        this.craftingMatrix.m_6211_();
        this.updateRecipe();
    }

    public EntityGenericCar getCurrentCraftingCar() {
        return this.currentCraftingCar;
    }

    public boolean isCurrentCraftingCarValid() {
        return this.messages.size() <= 0;
    }

    public List<Component> getMessages() {
        return this.messages;
    }

    public void repairCar(Player player) {
        if (!this.areBlocksAround()) {
            player.m_6352_((Component)new TranslatableComponent("message.incomplete_structure"), Util.f_137441_);
            return;
        }
        if (!this.areRepairItemsInside()) {
            player.m_6352_((Component)new TranslatableComponent("message.no_repair_items"), Util.f_137441_);
            return;
        }
        EntityCarBase carBase = this.getCarOnTop();
        if (!(carBase instanceof EntityCarDamageBase)) {
            player.m_6352_((Component)new TranslatableComponent("message.no_car"), Util.f_137441_);
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carBase;
        if (car.getDamage() <= 0.0f) {
            return;
        }
        this.damageRepairItemsInside(player);
        car.setDamage(car.getDamage() - 10.0f);
        ModSounds.playSound(ModSounds.RATCHET, this.f_58857_, this.f_58858_, null, SoundSource.BLOCKS);
    }

    public boolean areRepairItemsInside() {
        for (int i = 0; i < this.repairInventory.m_6643_(); ++i) {
            if (!this.repairInventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void damageRepairItemsInside(Player player) {
        for (int i = 0; i < this.repairInventory.m_6643_(); ++i) {
            ItemStack stack = this.repairInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.m_41622_(10, (LivingEntity)player, playerEntity -> {});
        }
    }

    @Override
    public Component getTranslatedName() {
        return new TranslatableComponent(ModBlocks.CAR_WORKSHOP.m_7705_());
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

