/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.fluids.ModFluids;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntitySplitTank
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
Container {
    private int currentMix = 0;
    public int maxMix;
    public int mixUsage;
    private int currentBioDiesel;
    public int maxBioDiesel;
    public int bioDieselGeneration;
    private int currentGlycerin;
    public int maxGlycerin;
    public int glycerinGeneration;
    public int generatingTime;
    private int timeToGenerate;
    protected SimpleContainer inventory;
    public final ContainerData FIELDS = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return TileEntitySplitTank.this.currentMix;
                }
                case 1: {
                    return TileEntitySplitTank.this.currentBioDiesel;
                }
                case 2: {
                    return TileEntitySplitTank.this.currentGlycerin;
                }
                case 3: {
                    return TileEntitySplitTank.this.timeToGenerate;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntitySplitTank.this.currentMix = value;
                    break;
                }
                case 1: {
                    TileEntitySplitTank.this.currentBioDiesel = value;
                    break;
                }
                case 2: {
                    TileEntitySplitTank.this.currentGlycerin = value;
                    break;
                }
                case 3: {
                    TileEntitySplitTank.this.timeToGenerate = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public TileEntitySplitTank(BlockPos pos, BlockState state) {
        super(Main.SPLIT_TANK_TILE_ENTITY_TYPE, pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxMix = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentBioDiesel = 0;
        this.maxBioDiesel = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.currentGlycerin = 0;
        this.maxGlycerin = (Integer)Main.SERVER_CONFIG.splitTankFluidStorage.get();
        this.generatingTime = (Integer)Main.SERVER_CONFIG.splitTankGeneratingTime.get();
        this.timeToGenerate = 0;
        this.mixUsage = (Integer)Main.SERVER_CONFIG.splitTankMixUsage.get();
        this.glycerinGeneration = (Integer)Main.SERVER_CONFIG.splitTankGlycerinGeneration.get();
        this.bioDieselGeneration = (Integer)Main.SERVER_CONFIG.splitTankBioDieselGeneration.get();
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.timeToGenerate > 0) {
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix - this.mixUsage >= 0) {
                this.currentMix -= this.mixUsage;
                if (this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel) {
                    this.currentBioDiesel += this.bioDieselGeneration;
                }
                if (this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
                    this.currentGlycerin += this.glycerinGeneration;
                }
            }
        } else if (this.currentMix >= this.mixUsage && this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel && this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
            this.timeToGenerate = this.generatingTime;
        }
        if (this.f_58857_.m_46467_() % 200L == 0L) {
            this.synchronize();
        }
        this.m_6596_();
    }

    public float getBioDieselPerc() {
        return (float)this.currentBioDiesel / (float)this.maxBioDiesel;
    }

    public float getGlycerinPerc() {
        return (float)this.currentGlycerin / (float)this.maxGlycerin;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128405_("mix", this.currentMix);
        compound.m_128405_("bio_diesel", this.currentBioDiesel);
        compound.m_128405_("glycerin", this.currentGlycerin);
        compound.m_128405_("time", this.timeToGenerate);
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.currentMix = compound.m_128451_("mix");
        this.currentBioDiesel = compound.m_128451_("bio_diesel");
        this.currentGlycerin = compound.m_128451_("glycerin");
        this.timeToGenerate = compound.m_128451_("timeToGenerate");
        super.m_142466_(compound);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int index) {
        return this.inventory.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.inventory.m_7407_(index, count);
    }

    public ItemStack m_8016_(int index) {
        return this.inventory.m_8016_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventory.m_6836_(index, stack);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public void m_5856_(Player player) {
        this.inventory.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.inventory.m_5785_(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.inventory.m_7013_(index, stack);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }

    public int getCurrentMix() {
        return this.currentMix;
    }

    public int getCurrentBioDiesel() {
        return this.currentBioDiesel;
    }

    public int getCurrentGlycerin() {
        return this.currentGlycerin;
    }

    public int getTimeToGenerate() {
        return this.timeToGenerate;
    }

    @Override
    public Component getTranslatedName() {
        return new TranslatableComponent("block.car.split_tank");
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 3;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank == 0) {
            return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, this.currentMix);
        }
        if (tank == 1) {
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, this.currentBioDiesel);
        }
        return new FluidStack((Fluid)ModFluids.GLYCERIN, this.currentGlycerin);
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.maxMix;
        }
        if (tank == 1) {
            return this.maxBioDiesel;
        }
        return this.maxGlycerin;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank == 0) {
            return stack.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX);
        }
        if (tank == 1) {
            return stack.getFluid().equals(ModFluids.BIO_DIESEL);
        }
        return stack.getFluid().equals(ModFluids.GLYCERIN);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.CANOLA_METHANOL_MIX)) {
            int amount = Math.min(this.maxMix - this.currentMix, resource.getAmount());
            if (action.execute()) {
                this.currentMix += amount;
                this.m_6596_();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getFluid().equals(ModFluids.GLYCERIN)) {
            int amount = Math.min(resource.getAmount(), this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.m_6596_();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        if (resource.getFluid().equals(ModFluids.BIO_DIESEL)) {
            int amount = Math.min(resource.getAmount(), this.currentBioDiesel);
            if (action.execute()) {
                this.currentBioDiesel -= amount;
                this.m_6596_();
            }
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.currentGlycerin > this.currentBioDiesel) {
            int amount = Math.min(maxDrain, this.currentGlycerin);
            if (action.execute()) {
                this.currentGlycerin -= amount;
                this.m_6596_();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        int amount = Math.min(maxDrain, this.currentBioDiesel);
        if (action.execute()) {
            this.currentBioDiesel -= amount;
            this.m_6596_();
        }
        return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
    }
}

