/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTank
extends TileEntityBase
implements IFluidHandler,
ITickableBlockEntity {
    private FluidStack fluid;
    public static final int CAPACITY = 16000;
    private boolean[] sides = new boolean[Direction.values().length];
    private boolean[] sidesFluid = new boolean[Direction.values().length];

    public TileEntityTank(BlockPos pos, BlockState state) {
        super(Main.TANK_TILE_ENTITY_TYPE, pos, state);
        this.fluid = FluidStack.EMPTY;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 20L == 0L) {
                this.synchronize();
            }
        } else {
            this.updateClientSide();
        }
        if (this.fluid.isEmpty()) {
            return;
        }
        this.checkDown();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (this.fluid.isEmpty()) {
                return;
            }
            this.checkSide(facing);
        }
    }

    public void checkSide(Direction side) {
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack other = otherTank.getFluid();
        if (!other.getFluid().equals(this.fluid.getFluid()) && !other.isEmpty()) {
            return;
        }
        int dif = other.getAmount() - this.fluid.getAmount();
        if (dif >= -2) {
            return;
        }
        FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)(-dif / 2), (boolean)true);
    }

    public void checkDown() {
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank otherTank = (TileEntityTank)te;
        FluidStack stack = FluidUtil.tryFluidTransfer((IFluidHandler)otherTank, (IFluidHandler)this, (int)Integer.MAX_VALUE, (boolean)true);
        if (stack.isEmpty()) {
            return;
        }
        if (!this.fluid.isEmpty() && this.fluid.getAmount() <= 0) {
            this.fluid = FluidStack.EMPTY;
        }
    }

    public float getFillPercent() {
        if (this.fluid.isEmpty()) {
            return 0.0f;
        }
        return (float)this.fluid.getAmount() / 16000.0f;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        if (!this.fluid.isEmpty() && this.fluid.getAmount() > 0) {
            CompoundTag comp = new CompoundTag();
            this.fluid.writeToNBT(comp);
            compound.m_128365_("fluid", (Tag)comp);
        }
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("fluid")) {
            CompoundTag comp = compound.m_128469_("fluid");
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)comp);
        } else {
            this.fluid = FluidStack.EMPTY;
        }
        super.m_142466_(compound);
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public Component getTranslatedName() {
        return new TranslatableComponent("block.car.tank");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void recalculateSides() {
        for (Direction facing : Direction.values()) {
            this.sides[facing.m_122411_()] = this.isTankConnectedCalc(facing);
            this.sidesFluid[facing.m_122411_()] = this.isFluidConnectedCalc(facing);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isFluidConnectedCalc(Direction facing) {
        BlockState s;
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return false;
            }
            if (tank.fluid.getFluid().equals(this.fluid.getFluid())) {
                if (facing.equals((Object)Direction.UP)) {
                    return this.fluid.getAmount() >= 16000;
                }
                return true;
            }
        }
        if ((s = this.f_58857_.m_8055_(this.f_58858_.m_142300_(facing))).m_60796_((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(facing))) {
            if (facing.equals((Object)Direction.UP)) {
                return this.fluid.getAmount() >= 16000;
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isTankConnectedCalc(Direction facing) {
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.fluid.isEmpty() && this.fluid.isEmpty()) {
                return true;
            }
            if (tank.fluid.isEmpty() || this.fluid.isEmpty()) {
                return true;
            }
            return tank.fluid.getFluid().equals(this.fluid.getFluid());
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateClientSide() {
        this.recalculateSides();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTankConnectedTo(Direction facing) {
        return this.sides[facing.m_122411_()];
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFluidConnected(Direction facing) {
        return this.sidesFluid[facing.m_122411_()];
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return 16000;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            int amount = Math.min(resource.getAmount(), 16000);
            if (action.execute()) {
                this.fluid = new FluidStack(resource.getFluid(), amount);
                this.m_6596_();
            }
            return amount;
        }
        if (resource.getFluid().equals(this.fluid.getFluid())) {
            int amount = Math.min(resource.getAmount(), 16000 - this.fluid.getAmount());
            if (action.execute()) {
                this.fluid.setAmount(this.fluid.getAmount() + amount);
                this.m_6596_();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (this.fluid.getFluid().equals(resource.getFluid())) {
            int amount = Math.min(resource.getAmount(), this.fluid.getAmount());
            Fluid f = this.fluid.getFluid();
            if (action.execute()) {
                this.fluid.setAmount(this.fluid.getAmount() - amount);
                if (this.fluid.getAmount() <= 0) {
                    this.fluid = FluidStack.EMPTY;
                }
                this.m_6596_();
            }
            return new FluidStack(f, amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.fluid.getAmount());
        Fluid f = this.fluid.getFluid();
        if (action.execute()) {
            this.fluid.setAmount(this.fluid.getAmount() - amount);
            if (this.fluid.getAmount() <= 0) {
                this.fluid = FluidStack.EMPTY;
            }
            this.m_6596_();
        }
        return new FluidStack(f, amount);
    }
}

