/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.config;

import de.maxhenkel.car.corelib.config.ConfigBase;
import de.maxhenkel.car.corelib.tag.TagUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ServerConfig
extends ConfigBase {
    public final ForgeConfigSpec.IntValue backmixReactorEnergyStorage;
    public final ForgeConfigSpec.IntValue backmixReactorEnergyUsage;
    public final ForgeConfigSpec.IntValue backmixReactorFluidStorage;
    public final ForgeConfigSpec.IntValue backmixReactorGeneratingTime;
    public final ForgeConfigSpec.IntValue backmixReactorMixGeneration;
    public final ForgeConfigSpec.IntValue backmixReactorMethanolUsage;
    public final ForgeConfigSpec.IntValue backmixReactorCanolaUsage;
    public final ForgeConfigSpec.IntValue blastFurnaceEnergyStorage;
    public final ForgeConfigSpec.IntValue blastFurnaceFluidStorage;
    public final ForgeConfigSpec.IntValue oilMillEnergyStorage;
    public final ForgeConfigSpec.IntValue oilMillFluidStorage;
    public final ForgeConfigSpec.IntValue cableTransferRate;
    public final ForgeConfigSpec.IntValue dynamoEnergyStorage;
    public final ForgeConfigSpec.IntValue dynamoEnergyGeneration;
    public final ForgeConfigSpec.IntValue fluidExtractorDrainSpeed;
    public final ForgeConfigSpec.IntValue gasStationTransferRate;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> gasStationValidFuels;
    public final ForgeConfigSpec.IntValue generatorEnergyStorage;
    public final ForgeConfigSpec.IntValue generatorFluidStorage;
    public final ForgeConfigSpec.IntValue generatorEnergyGeneration;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> generatorValidFuels;
    public final ForgeConfigSpec.IntValue splitTankFluidStorage;
    public final ForgeConfigSpec.IntValue splitTankGeneratingTime;
    public final ForgeConfigSpec.IntValue splitTankMixUsage;
    public final ForgeConfigSpec.IntValue splitTankGlycerinGeneration;
    public final ForgeConfigSpec.IntValue splitTankBioDieselGeneration;
    public final ForgeConfigSpec.DoubleValue repairKitRepairAmount;
    public final ForgeConfigSpec.IntValue canisterMaxFuel;
    public final ForgeConfigSpec.DoubleValue carOffroadSpeed;
    public final ForgeConfigSpec.DoubleValue carOnroadSpeed;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> carDriveBlocks;
    public final ForgeConfigSpec.BooleanValue collideWithEntities;
    public final ForgeConfigSpec.BooleanValue damageEntities;
    public final ForgeConfigSpec.BooleanValue hornFlee;
    public final ForgeConfigSpec.BooleanValue useBattery;
    public final ForgeConfigSpec.IntValue tankSmallMaxFuel;
    public final ForgeConfigSpec.IntValue tankMediumMaxFuel;
    public final ForgeConfigSpec.IntValue tankLargeMaxFuel;
    public final ForgeConfigSpec.DoubleValue engine6CylinderFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue engine3CylinderFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue engineTruckFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue engine6CylinderAcceleration;
    public final ForgeConfigSpec.DoubleValue engine3CylinderAcceleration;
    public final ForgeConfigSpec.DoubleValue engineTruckAcceleration;
    public final ForgeConfigSpec.DoubleValue engine6CylinderMaxSpeed;
    public final ForgeConfigSpec.DoubleValue engine3CylinderMaxSpeed;
    public final ForgeConfigSpec.DoubleValue engineTruckMaxSpeed;
    public final ForgeConfigSpec.DoubleValue engine6CylinderMaxReverseSpeed;
    public final ForgeConfigSpec.DoubleValue engine3CylinderMaxReverseSpeed;
    public final ForgeConfigSpec.DoubleValue engineTruckMaxReverseSpeed;
    public final ForgeConfigSpec.DoubleValue bodyBigWoodFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue bodyBigWoodAcceleration;
    public final ForgeConfigSpec.DoubleValue bodyBigWoodMaxSpeed;
    public final ForgeConfigSpec.DoubleValue bodyWoodFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue bodyWoodAcceleration;
    public final ForgeConfigSpec.DoubleValue bodyWoodMaxSpeed;
    public final ForgeConfigSpec.DoubleValue bodySportFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue bodySportAcceleration;
    public final ForgeConfigSpec.DoubleValue bodySportMaxSpeed;
    public final ForgeConfigSpec.DoubleValue bodySUVFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue bodySUVAcceleration;
    public final ForgeConfigSpec.DoubleValue bodySUVMaxSpeed;
    public final ForgeConfigSpec.DoubleValue bodyTransporterFuelEfficiency;
    public final ForgeConfigSpec.DoubleValue bodyTransporterAcceleration;
    public final ForgeConfigSpec.DoubleValue bodyTransporterMaxSpeed;
    public List<Tag<Fluid>> gasStationValidFuelList = new ArrayList<Tag<Fluid>>();
    public List<Tag<Fluid>> generatorValidFuelList = new ArrayList<Tag<Fluid>>();
    public List<Tag<Block>> carDriveBlockList = new ArrayList<Tag<Block>>();

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.backmixReactorEnergyStorage = builder.defineInRange("machines.backmix_reactor.energy_storage", 10000, 100, Short.MAX_VALUE);
        this.backmixReactorEnergyUsage = builder.defineInRange("machines.backmix_reactor.energy_usage", 10, 1, Short.MAX_VALUE);
        this.backmixReactorFluidStorage = builder.defineInRange("machines.backmix_reactor.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.backmixReactorGeneratingTime = builder.defineInRange("machines.backmix_reactor.generating_time", 200, 10, Short.MAX_VALUE);
        this.backmixReactorMixGeneration = builder.defineInRange("machines.backmix_reactor.mix_generation", 100, 1, Short.MAX_VALUE);
        this.backmixReactorMethanolUsage = builder.defineInRange("machines.backmix_reactor.methanol_usage", 50, 1, Short.MAX_VALUE);
        this.backmixReactorCanolaUsage = builder.defineInRange("machines.backmix_reactor.canola_usage", 50, 1, Short.MAX_VALUE);
        this.blastFurnaceEnergyStorage = builder.defineInRange("machines.blast_furnace.energy_storage", 10000, 1000, Short.MAX_VALUE);
        this.blastFurnaceFluidStorage = builder.defineInRange("machines.blast_furnace.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.oilMillEnergyStorage = builder.defineInRange("machines.oil_mill.energy_storage", 10000, 1000, Short.MAX_VALUE);
        this.oilMillFluidStorage = builder.defineInRange("machines.oil_mill.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.cableTransferRate = builder.defineInRange("machines.cable.transfer_rate", 256, 64, Short.MAX_VALUE);
        this.dynamoEnergyStorage = builder.defineInRange("machines.dynamo.energy_storage", 1000, 100, Short.MAX_VALUE);
        this.dynamoEnergyGeneration = builder.defineInRange("machines.dynamo.energy_generation", 25, 1, Short.MAX_VALUE);
        this.fluidExtractorDrainSpeed = builder.defineInRange("machines.fluid_extractor.drain_speed", 25, 5, Short.MAX_VALUE);
        this.gasStationTransferRate = builder.defineInRange("machines.gas_station.transfer_rate", 5, 1, Short.MAX_VALUE);
        this.gasStationValidFuels = builder.comment("If it starts with '#' it is a tag").defineList("machines.gas_station.valid_fuels", Collections.singletonList("#car:gas_station"), Objects::nonNull);
        this.generatorEnergyStorage = builder.defineInRange("machines.generator.energy_storage", 30000, 1000, Short.MAX_VALUE);
        this.generatorFluidStorage = builder.defineInRange("machines.generator.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.generatorEnergyGeneration = builder.defineInRange("machines.generator.energy_generation", 500, 1, Short.MAX_VALUE);
        this.generatorValidFuels = builder.comment("If it starts with '#' it is a tag").defineList("machines.generator.valid_fuels", Collections.singletonList("#car:generator"), Objects::nonNull);
        this.splitTankFluidStorage = builder.defineInRange("machines.split_tank.fluid_storage", 3000, 1000, Short.MAX_VALUE);
        this.splitTankGeneratingTime = builder.defineInRange("machines.split_tank.generating_time", 800, 10, Short.MAX_VALUE);
        this.splitTankMixUsage = builder.defineInRange("machines.split_tank.mix_usage", 100, 1, Short.MAX_VALUE);
        this.splitTankGlycerinGeneration = builder.defineInRange("machines.split_tank.glycerin_generation", 10, 1, Short.MAX_VALUE);
        this.splitTankBioDieselGeneration = builder.defineInRange("machines.split_tank.bio_diesel_generation", 100, 1, Short.MAX_VALUE);
        this.repairKitRepairAmount = builder.defineInRange("items.repair_kit.repair_amount", 5.0, (double)0.1f, 100.0);
        this.canisterMaxFuel = builder.defineInRange("items.canister.max_fuel", 100, 1, 1000);
        this.collideWithEntities = builder.comment("Whether the cars should collide with other entities (except cars)").define("car.collide_with_entities", false);
        this.damageEntities = builder.comment("Whether the cars should damage other entities on collision").define("car.damage_entities", true);
        this.hornFlee = builder.comment("Whether animals flee from the car when the horn is activted").define("car.horn_flee", true);
        this.useBattery = builder.comment("True if starting the car should use battery").define("car.use_battery", true);
        this.carOffroadSpeed = builder.comment("The speed modifier for cars on non road blocks").defineInRange("car.offroad_speed_modifier", 1.0, 0.001, 10.0);
        this.carOnroadSpeed = builder.comment(new String[]{"The speed modifier for cars on road blocks", "On road blocks are defined in the config section 'road_blocks'"}).defineInRange("car.onroad_speed_modifier", 1.0, 0.001, 10.0);
        this.carDriveBlocks = builder.comment("If it starts with '#' it is a tag").defineList("car.road_blocks.blocks", Collections.singletonList("#car:drivable_blocks"), Objects::nonNull);
        this.tankSmallMaxFuel = builder.defineInRange("car.parts.small_tank.max_fuel", 500, 100, 100000);
        this.tankMediumMaxFuel = builder.defineInRange("car.parts.medium_tank.max_fuel", 1000, 100, 100000);
        this.tankLargeMaxFuel = builder.defineInRange("car.parts.large_tank.max_fuel", 1500, 100, 100000);
        this.engine6CylinderFuelEfficiency = builder.defineInRange("car.parts.engine_6_cylinder.fuel_efficiency", 0.25, 0.001, 10.0);
        this.engine3CylinderFuelEfficiency = builder.defineInRange("car.parts.engine_3_cylinder.fuel_efficiency", 0.5, 0.001, 10.0);
        this.engineTruckFuelEfficiency = builder.defineInRange("car.parts.engine_truck.fuel_efficiency", 0.7, 0.001, 10.0);
        this.engine6CylinderAcceleration = builder.defineInRange("car.parts.engine_6_cylinder.acceleration", 0.04, 0.001, 10.0);
        this.engine3CylinderAcceleration = builder.defineInRange("car.parts.engine_3_cylinder.acceleration", 0.035, 0.001, 10.0);
        this.engineTruckAcceleration = builder.defineInRange("car.parts.engine_truck.acceleration", 0.032, 0.001, 10.0);
        this.engine6CylinderMaxSpeed = builder.defineInRange("car.parts.engine_6_cylinder.max_speed", 0.75, 0.001, 10.0);
        this.engine3CylinderMaxSpeed = builder.defineInRange("car.parts.engine_3_cylinder.max_speed", 0.65, 0.001, 10.0);
        this.engineTruckMaxSpeed = builder.defineInRange("car.parts.engine_truck.max_speed", 0.6, 0.001, 10.0);
        this.engine6CylinderMaxReverseSpeed = builder.defineInRange("car.parts.engine_6_cylinder.max_reverse_speed", 0.2, 0.001, 10.0);
        this.engine3CylinderMaxReverseSpeed = builder.defineInRange("car.parts.engine_3_cylinder.max_reverse_speed", 0.2, 0.001, 10.0);
        this.engineTruckMaxReverseSpeed = builder.defineInRange("car.parts.engine_truck.max_reverse_speed", 0.15, 0.001, 10.0);
        this.bodyBigWoodFuelEfficiency = builder.defineInRange("car.parts.body_big_wood.fuel_efficiency", 0.7, 0.001, 10.0);
        this.bodyBigWoodAcceleration = builder.defineInRange("car.parts.body_big_wood.acceleration", 0.95, 0.001, 10.0);
        this.bodyBigWoodMaxSpeed = builder.defineInRange("car.parts.body_big_wood.max_speed", 0.85, 0.001, 10.0);
        this.bodyWoodFuelEfficiency = builder.defineInRange("car.parts.body_wood.fuel_efficiency", 0.8, 0.001, 10.0);
        this.bodyWoodAcceleration = builder.defineInRange("car.parts.body_wood.acceleration", 1.0, 0.001, 10.0);
        this.bodyWoodMaxSpeed = builder.defineInRange("car.parts.body_wood.max_speed", 0.9, 0.001, 10.0);
        this.bodySportFuelEfficiency = builder.defineInRange("car.parts.body_sport.fuel_efficiency", 0.9, 0.001, 10.0);
        this.bodySportAcceleration = builder.defineInRange("car.parts.body_sport.acceleration", 1.0, 0.001, 10.0);
        this.bodySportMaxSpeed = builder.defineInRange("car.parts.body_sport.max_speed", 1.0, 0.001, 10.0);
        this.bodySUVFuelEfficiency = builder.defineInRange("car.parts.body_suv.fuel_efficiency", 0.6, 0.001, 10.0);
        this.bodySUVAcceleration = builder.defineInRange("car.parts.body_suv.acceleration", 0.8, 0.001, 10.0);
        this.bodySUVMaxSpeed = builder.defineInRange("car.parts.body_suv.max_speed", 0.7, 0.001, 10.0);
        this.bodyTransporterFuelEfficiency = builder.defineInRange("car.parts.body_transporter.fuel_efficiency", 0.6, 0.001, 10.0);
        this.bodyTransporterAcceleration = builder.defineInRange("car.parts.body_transporter.acceleration", 0.8, 0.001, 10.0);
        this.bodyTransporterMaxSpeed = builder.defineInRange("car.parts.body_transporter.max_speed", 0.765, 0.001, 10.0);
    }

    @Override
    public void onReload(ModConfigEvent event) {
        super.onReload(event);
        this.gasStationValidFuelList = ((List)this.gasStationValidFuels.get()).stream().map(TagUtils::getFluid).filter(Objects::nonNull).collect(Collectors.toList());
        this.generatorValidFuelList = ((List)this.generatorValidFuels.get()).stream().map(TagUtils::getFluid).filter(Objects::nonNull).collect(Collectors.toList());
        this.carDriveBlockList = ((List)this.carDriveBlocks.get()).stream().map(TagUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

