/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.DamageSourceCar;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntityCarBase
extends EntityVehicleBase {
    private float wheelRotation;
    @OnlyIn(value=Dist.CLIENT)
    private boolean collidedLastTick;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStart startLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopIdle idleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopHigh highLoop;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STARTED = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @OnlyIn(value=Dist.CLIENT)
    private boolean startedLast;

    public EntityCarBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 0.5f;
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getMinRotationSpeed();

    public abstract float getRollResistance();

    public abstract float getRotationModifier();

    public abstract float getPitch();

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isStarted() && !this.canEngineStayOn()) {
            this.setStarted(false);
        }
        this.updateGravity();
        this.controlCar();
        this.checkPush();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.f_19853_.f_46443_) {
            this.updateSounds();
        }
        this.updateWheelRotation();
    }

    public void centerCar() {
        Direction facing = this.m_6350_();
        switch (facing) {
            case SOUTH: {
                this.m_146922_(0.0f);
                break;
            }
            case NORTH: {
                this.m_146922_(180.0f);
                break;
            }
            case EAST: {
                this.m_146922_(-90.0f);
                break;
            }
            case WEST: {
                this.m_146922_(90.0f);
            }
        }
    }

    @Override
    public boolean m_7337_(Entity entityIn) {
        float speed;
        if (((Boolean)Main.SERVER_CONFIG.damageEntities.get()).booleanValue() && entityIn instanceof LivingEntity && !this.m_20197_().contains(entityIn) && entityIn.m_142469_().m_82381_(this.m_142469_()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            entityIn.m_6469_((DamageSource)DamageSourceCar.DAMAGE_CAR, damage);
        }
        return super.m_7337_(entityIn);
    }

    public void checkPush() {
        List list = this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82363_(0.2, 0.0, 0.2).m_82363_(-0.2, 0.0, -0.2));
        for (Player player : list) {
            if (player.m_20363_((Entity)this) || !player.m_6144_()) continue;
            double motX = EntityCarBase.calculateMotionX(0.05f, player.m_146908_());
            double motZ = EntityCarBase.calculateMotionZ(0.05f, player.m_146908_());
            this.m_6478_(MoverType.PLAYER, new Vec3(motX, 0.0, motZ));
            return;
        }
    }

    public boolean canEngineStayOn() {
        return !this.m_20069_() && !this.m_20077_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSounds() {
        if (this.getSpeed() == 0.0f && this.isStarted()) {
            if (!this.startedLast) {
                this.checkStartLoop();
            } else if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
                if (this.startLoop != null) {
                    this.startLoop.setDonePlaying();
                    this.startLoop = null;
                }
                this.checkIdleLoop();
            }
        }
        if (this.getSpeed() != 0.0f && this.isStarted()) {
            this.checkHighLoop();
        }
        this.startedLast = this.isStarted();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.m_91087_().m_91106_().m_120403_(sound);
    }

    public void destroyCar(Player player, boolean dropParts) {
        this.m_6074_();
    }

    private void controlCar() {
        if (!this.m_20160_()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = this.getModifier();
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = Mth.m_14154_((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.m_14036_((float)rotationSpeed, (float)this.getMinRotationSpeed(), (float)this.getMaxRotationSpeed());
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.m_146922_(this.m_146908_() + this.deltaRotation);
        float delta = Math.abs(this.m_146908_() - this.f_19859_);
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        if (this.f_19862_) {
            if (this.f_19853_.f_46443_ && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.m_20334_(EntityCarBase.calculateMotionX(this.getSpeed(), this.m_146908_()), this.m_20184_().f_82480_, EntityCarBase.calculateMotionZ(this.getSpeed(), this.m_146908_()));
            if (this.f_19853_.f_46443_) {
                this.collidedLastTick = false;
            }
        }
    }

    public float getModifier() {
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_() - 0.1, this.m_20189_());
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_60795_() || Main.SERVER_CONFIG.carDriveBlockList.stream().anyMatch(tag -> tag.m_8110_((Object)state.m_60734_()))) {
            return ((Double)Main.SERVER_CONFIG.carOnroadSpeed.get()).floatValue();
        }
        return ((Double)Main.SERVER_CONFIG.carOffroadSpeed.get()).floatValue();
    }

    public void onCollision(float speed) {
        if (this.f_19853_.f_46443_) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCrash(speed, this));
        }
        this.setSpeed(0.01f);
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
    }

    public boolean canPlayerDriveCar(Player player) {
        if (player.equals((Object)this.getDriver()) && this.isStarted()) {
            return true;
        }
        if (this.m_20069_() || this.m_20077_()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.m_20068_()) {
            this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
            return;
        }
        this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_ - 0.2, this.m_20184_().f_82481_);
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.f_19853_.f_46443_ && needsUpdate) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageControlCar(forward, backward, left, right, player));
        }
    }

    public void startCarEngine() {
        Player player = this.getDriver();
        if (player != null && this.canStartCarEngine(player)) {
            this.setStarted(true);
        }
    }

    public boolean canStartCarEngine(Player player) {
        return !this.m_20069_() && !this.m_20077_();
    }

    public abstract double getPlayerYOffset();

    public boolean canPlayerEnterCar(Player player) {
        return true;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.canPlayerEnterCar(player)) {
            return InteractionResult.FAIL;
        }
        return super.m_6096_(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public void openCarGUI(Player player) {
        if (this.f_19853_.f_46443_) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCarGui(player));
        }
    }

    public boolean isAccelerating() {
        boolean b = (this.isForward() || this.isBackward()) && !this.f_19862_;
        return b && this.isStarted();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STARTED, (Object)false);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORWARD, (Object)false);
        this.f_19804_.m_135372_(BACKWARD, (Object)false);
        this.f_19804_.m_135372_(LEFT, (Object)false);
        this.f_19804_.m_135372_(RIGHT, (Object)false);
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public void setStarted(boolean started) {
        this.setStarted(started, true, false);
    }

    public void setStarted(boolean started, boolean playStopSound, boolean playFailSound) {
        if (!started && playStopSound) {
            this.playStopSound();
        } else if (!started && playFailSound) {
            this.playFailSound();
        }
        if (started) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        this.f_19804_.m_135381_(STARTED, (Object)started);
    }

    public boolean isStarted() {
        return (Boolean)this.f_19804_.m_135370_(STARTED);
    }

    public void setForward(boolean forward) {
        this.f_19804_.m_135381_(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.f_19804_.m_135381_(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.f_19804_.m_135370_(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.f_19804_.m_135381_(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.f_19804_.m_135370_(LEFT);
    }

    public void setRight(boolean right) {
        this.f_19804_.m_135381_(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public void m_7378_(CompoundTag compound) {
        this.setStarted(compound.m_128471_("started"), false, false);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("started", this.isStarted());
    }

    public void playStopSound() {
        ModSounds.playSound(this.getStopSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public void playCrashSound() {
        ModSounds.playSound(this.getCrashSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public void playHornSound() {
        ModSounds.playSound(this.getHornSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    @OnlyIn(value=Dist.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this, this.getIdleSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.idleLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this, this.getHighSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.highLoop, this.f_19853_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this, this.getStartSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.startLoop, this.f_19853_);
        }
    }

    public void onHornPressed(Player player) {
        if (this.f_19853_.f_46443_) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageCarHorn(true, player));
        } else {
            if (this instanceof EntityCarBatteryBase) {
                EntityCarBatteryBase car = (EntityCarBatteryBase)this;
                if (car.getBatteryLevel() < 10) {
                    return;
                }
                if (((Boolean)Main.SERVER_CONFIG.useBattery.get()).booleanValue()) {
                    car.setBatteryLevel(car.getBatteryLevel() - 10);
                }
            }
            this.playHornSound();
            if (((Boolean)Main.SERVER_CONFIG.hornFlee.get()).booleanValue()) {
                double radius = 15.0;
                List list = this.f_19853_.m_45976_(Monster.class, new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius));
                for (Monster ent : list) {
                    this.fleeEntity(ent);
                }
            }
        }
    }

    public void fleeEntity(Monster entity) {
        double fleeDistance = 10.0;
        Vec3 vecCar = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vec3 vecEntity = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 fleeDir = vecEntity.m_82546_(vecCar);
        fleeDir = fleeDir.m_82541_();
        entity.m_21573_().m_26519_(vecEntity.f_82479_ + fleeDir.f_82479_ * fleeDistance, vecEntity.f_82480_ + fleeDir.f_82480_ * fleeDistance, vecEntity.f_82481_ + fleeDir.f_82481_ * fleeDistance, 2.5);
    }
}

