/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarFuelBase;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.items.ItemCanister;
import de.maxhenkel.car.sounds.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class EntityCarInventoryBase
extends EntityCarFuelBase
implements Container {
    protected Container internalInventory;
    protected Container externalInventory;
    protected Container partInventory;
    protected FluidStack fluidInventory;
    private IFluidHandler inventoryFluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return EntityCarInventoryBase.this.fluidInventory;
        }

        public int getTankCapacity(int tank) {
            return EntityCarInventoryBase.this.getFluidInventorySize();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory = new FluidStack(resource.getFluid(), amount);
                }
                return amount;
            }
            if (resource.getFluid().equals(EntityCarInventoryBase.this.fluidInventory.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.getFluidInventorySize() - EntityCarInventoryBase.this.fluidInventory.getAmount());
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() + amount);
                }
                return amount;
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (EntityCarInventoryBase.this.fluidInventory.getFluid().equals(resource.getFluid())) {
                int amount = Math.min(resource.getAmount(), EntityCarInventoryBase.this.fluidInventory.getAmount());
                Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
                if (action.execute()) {
                    EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                    if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                        EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                    }
                }
                return new FluidStack(f, amount);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (EntityCarInventoryBase.this.fluidInventory.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(maxDrain, EntityCarInventoryBase.this.fluidInventory.getAmount());
            Fluid f = EntityCarInventoryBase.this.fluidInventory.getFluid();
            if (action.execute()) {
                EntityCarInventoryBase.this.fluidInventory.setAmount(EntityCarInventoryBase.this.fluidInventory.getAmount() - amount);
                if (EntityCarInventoryBase.this.fluidInventory.getAmount() <= 0) {
                    EntityCarInventoryBase.this.fluidInventory = FluidStack.EMPTY;
                }
            }
            return new FluidStack(f, amount);
        }
    };

    public EntityCarInventoryBase(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.internalInventory = new SimpleContainer(27);
        this.externalInventory = new SimpleContainer(0);
        this.partInventory = new SimpleContainer(15);
        this.fluidInventory = FluidStack.EMPTY;
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.canPlayerAccessInventoryExternal(player) && player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_()) {
                IFluidHandler handler;
                if (stack.m_41720_() instanceof ItemCanister) {
                    boolean success = ItemCanister.fillCanister(stack, this);
                    if (success) {
                        ModSounds.playSound(SoundEvents.f_11772_, this.f_19853_, this.m_142538_(), null, SoundSource.BLOCKS);
                    }
                    return InteractionResult.CONSUME;
                }
                if (this.getFluidInventorySize() > 0 && (handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null)) != null) {
                    FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
                    if (!fluidStack.isEmpty() && EntityCarInventoryBase.handleEmpty(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return InteractionResult.CONSUME;
                    }
                    if (EntityCarInventoryBase.handleFill(stack, this.getInventoryFluidHandler(), player, hand)) {
                        return InteractionResult.CONSUME;
                    }
                }
            }
            if (!this.f_19853_.f_46443_) {
                if (this.externalInventory.m_6643_() <= 0) {
                    this.openCarGUI(player);
                } else {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                        public Component m_5446_() {
                            return EntityCarInventoryBase.this.m_5446_();
                        }

                        @Nullable
                        public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                            return new ContainerCarInventory(i, EntityCarInventoryBase.this, playerInventory);
                        }
                    }, packetBuffer -> packetBuffer.m_130077_(this.m_142081_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public static boolean handleEmpty(ItemStack stack, IFluidHandler handler, Player playerIn, InteractionHand hand) {
        InvWrapper inv = new InvWrapper((Container)playerIn.m_150109_());
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.m_21008_(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, IFluidHandler handler, Player playerIn, InteractionHand hand) {
        InvWrapper inv = new InvWrapper((Container)playerIn.m_150109_());
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.m_21008_(hand, result.result);
            return true;
        }
        return false;
    }

    public abstract int getFluidInventorySize();

    public boolean canPlayerAccessInventoryExternal(Player player) {
        return true;
    }

    public Container getPartInventory() {
        return this.partInventory;
    }

    @Override
    public void destroyCar(Player player, boolean dropParts) {
        super.destroyCar(player, dropParts);
        Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this.externalInventory);
        if (dropParts) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this.partInventory);
        }
    }

    @Override
    public void openCarGUI(Player player) {
        super.openCarGUI(player);
        if (!this.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return EntityCarInventoryBase.this.m_5446_();
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerCar(i, EntityCarInventoryBase.this, playerInventory);
                }
            }, packetBuffer -> packetBuffer.m_130077_(this.m_142081_()));
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ItemUtils.readInventory(compound, "int_inventory", this.internalInventory);
        this.externalInventory = new SimpleContainer(compound.m_128451_("external_inventory_size"));
        ItemUtils.readInventory(compound, "external_inventory", this.externalInventory);
        ItemUtils.readInventory(compound, "parts", this.partInventory);
        if (compound.m_128441_("fluid_inventory")) {
            this.fluidInventory = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluid_inventory"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemUtils.saveInventory(compound, "int_inventory", this.internalInventory);
        compound.m_128405_("external_inventory_size", this.externalInventory.m_6643_());
        ItemUtils.saveInventory(compound, "external_inventory", this.externalInventory);
        ItemUtils.saveInventory(compound, "parts", this.partInventory);
        if (!this.fluidInventory.isEmpty()) {
            compound.m_128365_("fluid_inventory", (Tag)this.fluidInventory.writeToNBT(new CompoundTag()));
        }
    }

    public IFluidHandler getInventoryFluidHandler() {
        return this.inventoryFluidHandler;
    }

    public int m_6643_() {
        return this.internalInventory.m_6643_();
    }

    public ItemStack m_8020_(int index) {
        return this.internalInventory.m_8020_(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.internalInventory.m_7407_(index, count);
    }

    public ItemStack m_8016_(int index) {
        return this.internalInventory.m_8016_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.internalInventory.m_6836_(index, stack);
    }

    public int m_6893_() {
        return this.internalInventory.m_6893_();
    }

    public void m_6596_() {
        this.internalInventory.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.internalInventory.m_6542_(player);
    }

    public boolean m_7983_() {
        return this.internalInventory.m_7983_();
    }

    public void m_5856_(Player player) {
        this.internalInventory.m_5856_(player);
    }

    public void m_5785_(Player player) {
        this.internalInventory.m_5785_(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.internalInventory.m_7013_(index, stack);
    }

    public void m_6211_() {
        this.internalInventory.m_6211_();
    }

    public Container getExternalInventory() {
        return this.externalInventory;
    }
}

