/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;

public class GuiBackmixReactor
extends ScreenBase<ContainerBackmixReactor> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_backmix_reactor.png");
    private Container playerInv;
    private TileEntityBackmixReactor tile;

    public GuiBackmixReactor(ContainerBackmixReactor container, Inventory playerInv, Component name) {
        super(GUI_TEXTURE, container, playerInv, name);
        this.playerInv = playerInv;
        this.tile = container.getBackmixReactor();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.f_169604_.m_7532_(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        if (mouseX >= this.f_97735_ + 11 && mouseX <= this.f_97735_ + 16 + 11 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(new TranslatableComponent("tooltip.energy", new Object[]{this.tile.getStoredEnergy()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 33 && mouseX <= this.f_97735_ + 16 + 33 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslatableComponent("tooltip.oil", new Object[]{this.tile.getCurrentCanola()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 55 && mouseX <= this.f_97735_ + 16 + 55 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslatableComponent("tooltip.methanol", new Object[]{this.tile.getCurrentMethanol()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 122 && mouseX <= this.f_97735_ + 16 + 122 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(new TranslatableComponent("tooltip.mix", new Object[]{this.tile.getCurrentMix()}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 79 && mouseX <= this.f_97735_ + 24 + 79 && mouseY >= this.f_97736_ + 34 && mouseY <= this.f_97736_ + 17 + 34) {
            list = new ArrayList();
            list.add(new TranslatableComponent("tooltip.progress", new Object[]{(int)(this.getProgress() * 100.0f)}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawProgress(matrixStack);
        this.drawEnergy(matrixStack);
        this.drawCanola(matrixStack);
        this.drawMethanol(matrixStack);
        this.drawMix(matrixStack);
    }

    public void drawEnergy(PoseStack matrixStack) {
        float perc = this.getEnergy();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 11;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawCanola(PoseStack matrixStack) {
        float perc = this.getCanola();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 33;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMethanol(PoseStack matrixStack) {
        float perc = this.getMethanol();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 55;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix(PoseStack matrixStack) {
        float perc = this.getMix();
        int texX = 224;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 122;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(PoseStack matrixStack) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getEnergy() {
        return (float)this.tile.getStoredEnergy() / (float)this.tile.maxStorage;
    }

    public float getCanola() {
        return (float)this.tile.getCurrentCanola() / (float)this.tile.maxCanola;
    }

    public float getMethanol() {
        return (float)this.tile.getCurrentMethanol() / (float)this.tile.maxMethanol;
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

