/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityTools {
    @Nullable
    public static EntityGenericCar getCarByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.f_19853_.m_6443_(EntityGenericCar.class, new AABB(player.m_20185_() - distance, player.m_20186_() - distance, player.m_20189_() - distance, player.m_20185_() + distance, player.m_20186_() + distance, player.m_20189_() + distance), entity -> entity.m_142081_().equals(uuid)).stream().findAny().orElse(null);
    }

    public static void drawCarOnScreen(PoseStack matrixStack, EntityCarBase car, int posX, int posY, float scale, float rotation) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)posX, (double)posY, 100.0);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(135.0f + rotation));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        entityrenderermanager.m_114384_((Entity)car, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        entityrenderermanager.m_114468_(true);
        matrixStack.m_85849_();
    }

    public static interface Renderer {
        public void render(float var1);

        public void tick();
    }

    public static class SimulatedTicker {
        private static final long ONE_TICK = 50000000L;
        private long lastTick;

        public void render(Renderer renderer) {
            long currentNanos = System.nanoTime();
            if (currentNanos - this.lastTick >= 50000000L) {
                renderer.tick();
                this.lastTick = currentNanos;
            }
            renderer.render((float)(currentNanos - this.lastTick) / 5.0E7f);
        }
    }

    public static class SimulatedCarRenderer {
        private float rotation;
        private float rotationPerTick;
        private SimulatedTicker ticker;

        public SimulatedCarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.ticker = new SimulatedTicker();
        }

        public SimulatedCarRenderer() {
            this(3.6f);
        }

        public void render(final PoseStack matrixStack, final EntityCarBase car, final int posX, final int posY, final int scale) {
            this.ticker.render(new Renderer(){

                @Override
                public void render(float partialTicks) {
                    EntityTools.drawCarOnScreen(matrixStack, car, posX, posY, scale, rotation + rotationPerTick * partialTicks);
                }

                @Override
                public void tick() {
                    rotation += rotationPerTick;
                    if (rotation >= 360.0f) {
                        rotation = 0.0f;
                    }
                }
            });
        }
    }

    public static class CarRenderer {
        private float rotation;
        private float rotationPerTick;
        private Minecraft minecraft;

        public CarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.minecraft = Minecraft.m_91087_();
        }

        public CarRenderer() {
            this(3.6f);
        }

        public void tick() {
            this.rotation += this.rotationPerTick;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }

        public void render(PoseStack matrixStack, EntityCarBase car, int posX, int posY, int scale) {
            EntityTools.drawCarOnScreen(matrixStack, car, posX, posY, scale, this.rotation + this.rotationPerTick * this.minecraft.m_91296_());
        }
    }
}

