/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.data.BurrowSettings;
import com.personthecat.cavegenerator.data.CavernSettings;
import com.personthecat.cavegenerator.data.ClusterSettings;
import com.personthecat.cavegenerator.data.LayerSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.data.PillarSettings;
import com.personthecat.cavegenerator.data.RavineSettings;
import com.personthecat.cavegenerator.data.StalactiteSettings;
import com.personthecat.cavegenerator.data.StructureSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import org.hjson.JsonObject;

public class CavePreset {
    public final boolean enabled;
    public final OverrideSettings overrides;
    public final List<TunnelSettings> tunnels;
    public final List<RavineSettings> ravines;
    public final List<CavernSettings> caverns;
    public final List<BurrowSettings> burrows;
    public final List<LayerSettings> layers;
    public final List<ClusterSettings> clusters;
    public final List<StalactiteSettings> stalactites;
    public final List<PillarSettings> pillars;
    public final List<StructureSettings> structures;
    public final JsonObject raw;

    public static CavePreset from(JsonObject json) {
        OverrideSettings overrides = OverrideSettings.from(json);
        CavePresetBuilder builder = CavePreset.builder().overrides(overrides).raw(json);
        return new HjsonMapper(json).mapBool("enabled", builder::enabled).mapArray("tunnels", o -> TunnelSettings.from(o, overrides), builder::tunnels).mapArray("ravines", o -> RavineSettings.from(o, overrides), builder::ravines).mapArray("caverns", o -> CavernSettings.from(o, overrides), builder::caverns).mapArray("burrows", o -> BurrowSettings.from(o, overrides), builder::burrows).mapArray("layers", o -> LayerSettings.from(o, overrides), builder::layers).mapArray("clusters", o -> ClusterSettings.from(o, overrides), builder::clusters).mapArray("stalactites", o -> StalactiteSettings.from(o, overrides), builder::stalactites).mapArray("pillars", o -> PillarSettings.from(o, overrides), builder::pillars).mapArray("structures", o -> StructureSettings.from(o, overrides), builder::structures).release(builder::build);
    }

    private static boolean $default$enabled() {
        return true;
    }

    private static OverrideSettings $default$overrides() {
        return OverrideSettings.builder().build();
    }

    private static List<TunnelSettings> $default$tunnels() {
        return Collections.emptyList();
    }

    private static List<RavineSettings> $default$ravines() {
        return Collections.emptyList();
    }

    private static List<CavernSettings> $default$caverns() {
        return Collections.emptyList();
    }

    private static List<BurrowSettings> $default$burrows() {
        return Collections.emptyList();
    }

    private static List<LayerSettings> $default$layers() {
        return Collections.emptyList();
    }

    private static List<ClusterSettings> $default$clusters() {
        return Collections.emptyList();
    }

    private static List<StalactiteSettings> $default$stalactites() {
        return Collections.emptyList();
    }

    private static List<PillarSettings> $default$pillars() {
        return Collections.emptyList();
    }

    private static List<StructureSettings> $default$structures() {
        return Collections.emptyList();
    }

    CavePreset(boolean enabled, OverrideSettings overrides, List<TunnelSettings> tunnels, List<RavineSettings> ravines, List<CavernSettings> caverns, List<BurrowSettings> burrows, List<LayerSettings> layers, List<ClusterSettings> clusters, List<StalactiteSettings> stalactites, List<PillarSettings> pillars, List<StructureSettings> structures, JsonObject raw) {
        this.enabled = enabled;
        this.overrides = overrides;
        this.tunnels = tunnels;
        this.ravines = ravines;
        this.caverns = caverns;
        this.burrows = burrows;
        this.layers = layers;
        this.clusters = clusters;
        this.stalactites = stalactites;
        this.pillars = pillars;
        this.structures = structures;
        this.raw = raw;
    }

    public static CavePresetBuilder builder() {
        return new CavePresetBuilder();
    }

    public CavePresetBuilder toBuilder() {
        return new CavePresetBuilder().enabled(this.enabled).overrides(this.overrides).tunnels(this.tunnels).ravines(this.ravines).caverns(this.caverns).burrows(this.burrows).layers(this.layers).clusters(this.clusters).stalactites(this.stalactites).pillars(this.pillars).structures(this.structures).raw(this.raw);
    }

    public static final class Fields {
        public static final String enabled = "enabled";
        public static final String overrides = "overrides";
        public static final String tunnels = "tunnels";
        public static final String ravines = "ravines";
        public static final String caverns = "caverns";
        public static final String burrows = "burrows";
        public static final String layers = "layers";
        public static final String clusters = "clusters";
        public static final String stalactites = "stalactites";
        public static final String pillars = "pillars";
        public static final String structures = "structures";
        public static final String raw = "raw";
    }

    public static class CavePresetBuilder {
        private boolean enabled$set;
        private boolean enabled$value;
        private boolean overrides$set;
        private OverrideSettings overrides$value;
        private boolean tunnels$set;
        private List<TunnelSettings> tunnels$value;
        private boolean ravines$set;
        private List<RavineSettings> ravines$value;
        private boolean caverns$set;
        private List<CavernSettings> caverns$value;
        private boolean burrows$set;
        private List<BurrowSettings> burrows$value;
        private boolean layers$set;
        private List<LayerSettings> layers$value;
        private boolean clusters$set;
        private List<ClusterSettings> clusters$value;
        private boolean stalactites$set;
        private List<StalactiteSettings> stalactites$value;
        private boolean pillars$set;
        private List<PillarSettings> pillars$value;
        private boolean structures$set;
        private List<StructureSettings> structures$value;
        private JsonObject raw;

        CavePresetBuilder() {
        }

        public CavePresetBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public CavePresetBuilder overrides(OverrideSettings overrides) {
            this.overrides$value = overrides;
            this.overrides$set = true;
            return this;
        }

        public CavePresetBuilder tunnels(List<TunnelSettings> tunnels) {
            this.tunnels$value = tunnels;
            this.tunnels$set = true;
            return this;
        }

        public CavePresetBuilder ravines(List<RavineSettings> ravines) {
            this.ravines$value = ravines;
            this.ravines$set = true;
            return this;
        }

        public CavePresetBuilder caverns(List<CavernSettings> caverns) {
            this.caverns$value = caverns;
            this.caverns$set = true;
            return this;
        }

        public CavePresetBuilder burrows(List<BurrowSettings> burrows) {
            this.burrows$value = burrows;
            this.burrows$set = true;
            return this;
        }

        public CavePresetBuilder layers(List<LayerSettings> layers) {
            this.layers$value = layers;
            this.layers$set = true;
            return this;
        }

        public CavePresetBuilder clusters(List<ClusterSettings> clusters) {
            this.clusters$value = clusters;
            this.clusters$set = true;
            return this;
        }

        public CavePresetBuilder stalactites(List<StalactiteSettings> stalactites) {
            this.stalactites$value = stalactites;
            this.stalactites$set = true;
            return this;
        }

        public CavePresetBuilder pillars(List<PillarSettings> pillars) {
            this.pillars$value = pillars;
            this.pillars$set = true;
            return this;
        }

        public CavePresetBuilder structures(List<StructureSettings> structures) {
            this.structures$value = structures;
            this.structures$set = true;
            return this;
        }

        public CavePresetBuilder raw(JsonObject raw) {
            this.raw = raw;
            return this;
        }

        public CavePreset build() {
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = CavePreset.$default$enabled();
            }
            OverrideSettings overrides$value = this.overrides$value;
            if (!this.overrides$set) {
                overrides$value = CavePreset.$default$overrides();
            }
            List tunnels$value = this.tunnels$value;
            if (!this.tunnels$set) {
                tunnels$value = CavePreset.$default$tunnels();
            }
            List ravines$value = this.ravines$value;
            if (!this.ravines$set) {
                ravines$value = CavePreset.$default$ravines();
            }
            List caverns$value = this.caverns$value;
            if (!this.caverns$set) {
                caverns$value = CavePreset.$default$caverns();
            }
            List burrows$value = this.burrows$value;
            if (!this.burrows$set) {
                burrows$value = CavePreset.$default$burrows();
            }
            List layers$value = this.layers$value;
            if (!this.layers$set) {
                layers$value = CavePreset.$default$layers();
            }
            List clusters$value = this.clusters$value;
            if (!this.clusters$set) {
                clusters$value = CavePreset.$default$clusters();
            }
            List stalactites$value = this.stalactites$value;
            if (!this.stalactites$set) {
                stalactites$value = CavePreset.$default$stalactites();
            }
            List pillars$value = this.pillars$value;
            if (!this.pillars$set) {
                pillars$value = CavePreset.$default$pillars();
            }
            List structures$value = this.structures$value;
            if (!this.structures$set) {
                structures$value = CavePreset.$default$structures();
            }
            return new CavePreset(enabled$value, overrides$value, tunnels$value, ravines$value, caverns$value, burrows$value, layers$value, clusters$value, stalactites$value, pillars$value, structures$value, this.raw);
        }

        public String toString() {
            return "CavePreset.CavePresetBuilder(enabled$value=" + this.enabled$value + ", overrides$value=" + this.overrides$value + ", tunnels$value=" + this.tunnels$value + ", ravines$value=" + this.ravines$value + ", caverns$value=" + this.caverns$value + ", burrows$value=" + this.burrows$value + ", layers$value=" + this.layers$value + ", clusters$value=" + this.clusters$value + ", stalactites$value=" + this.stalactites$value + ", pillars$value=" + this.pillars$value + ", structures$value=" + this.structures$value + ", raw=" + this.raw + ")";
        }
    }
}

