/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class FieldHistory {
    public static ObjectResolver withPath(String ... path) {
        return new StaticObjectResolver(path);
    }

    public static ObjectResolver recursive(String key) {
        return new RecursiveObjectResolver(key);
    }

    public static class MemberTransformationHelper
    implements Updater {
        private final ObjectResolver resolver;
        private final String key;
        private final MemberTransformation transformation;

        private MemberTransformationHelper(ObjectResolver resolver, String key, MemberTransformation transformation) {
            this.resolver = resolver;
            this.key = key;
            this.transformation = transformation;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::transform);
        }

        private void transform(JsonObject json) {
            JsonValue value = json.get(this.key);
            if (value != null) {
                Pair<String, JsonValue> updated = this.transformation.transform(this.key, value);
                json.remove(this.key);
                json.set((String)updated.getKey(), (JsonValue)updated.getValue());
            }
        }
    }

    @FunctionalInterface
    public static interface MemberTransformation {
        public Pair<String, JsonValue> transform(String var1, JsonValue var2);
    }

    public static class FieldRenameHelper
    implements Updater {
        private final ObjectResolver resolver;
        private final String key;
        private final String from;
        private final String to;

        private FieldRenameHelper(ObjectResolver resolver, String key, String from, String to) {
            this.resolver = resolver;
            this.key = key;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::renameValue);
        }

        private void renameValue(JsonObject json) {
            JsonValue value = json.get(this.key);
            if (value != null && value.isString() && this.from.equalsIgnoreCase(value.asString())) {
                json.set(this.key, this.to);
            }
        }
    }

    public static class RemovedFieldNotifier
    implements Updater {
        private final ObjectResolver resolver;
        private final String key;
        private final String version;

        private RemovedFieldNotifier(ObjectResolver resolver, String key, String version) {
            this.resolver = resolver;
            this.key = key;
            this.version = version;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::markRemoved);
        }

        private void markRemoved(JsonObject json) {
            JsonValue value = json.get(this.key);
            if (value != null) {
                json.setCondensed(false);
                value.setEOLComment(CommonMethods.f("Removed in {}. You can delete this field.", this.version));
            }
        }
    }

    public static class RangeConverter
    implements Updater {
        private final ObjectResolver resolver;
        private final String minKey;
        private final Number minDefault;
        private final String maxKey;
        private final Number maxDefault;
        private final String newKey;

        private RangeConverter(ObjectResolver resolver, String minKey, Number minDefault, String maxKey, Number maxDefault, String newKey) {
            this.resolver = resolver;
            this.minKey = minKey;
            this.minDefault = minDefault;
            this.maxKey = maxKey;
            this.maxDefault = maxDefault;
            this.newKey = newKey;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::convert);
        }

        private void convert(JsonObject json) {
            if (json.has(this.minKey) || json.has(this.maxKey)) {
                if (this.minDefault instanceof Double || this.minDefault instanceof Float) {
                    float min = HjsonTools.getFloatOr(json, this.minKey, this.minDefault.floatValue());
                    float max = HjsonTools.getFloatOr(json, this.maxKey, this.maxDefault.floatValue());
                    json.set(this.newKey, this.getRange(min, max));
                } else {
                    int min = HjsonTools.getIntOr(json, this.minKey, this.minDefault.intValue());
                    int max = HjsonTools.getIntOr(json, this.maxKey, this.maxDefault.intValue());
                    json.set(this.newKey, this.getRange(min, max));
                }
                json.remove(this.minKey);
                json.remove(this.maxKey);
            }
        }

        private JsonValue getRange(float min, float max) {
            if (min == max) {
                return JsonValue.valueOf(min);
            }
            return new JsonArray().add(min).add(max).setCondensed(true);
        }

        private JsonValue getRange(int min, int max) {
            if (min == max) {
                return JsonValue.valueOf(min);
            }
            return new JsonArray().add(min).add(max).setCondensed(true);
        }
    }

    public static class PathCollapseHelper
    implements Updater {
        private final ObjectResolver resolver;
        private final String outer;
        private final String inner;

        private PathCollapseHelper(ObjectResolver resolver, String outer, String inner) {
            this.resolver = resolver;
            this.outer = outer;
            this.inner = inner;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::collapse);
        }

        private void collapse(JsonObject json) {
            JsonValue innerValue;
            JsonValue outerValue = json.get(this.outer);
            if (outerValue != null && outerValue.isObject() && (innerValue = outerValue.asObject().get(this.inner)) != null) {
                json.set(this.outer, innerValue);
            }
        }
    }

    public static class RenameHistory
    implements Updater {
        private final ObjectResolver resolver;
        private final String[] history;

        private RenameHistory(ObjectResolver resolver, String[] history) {
            this.resolver = resolver;
            this.history = history;
        }

        @Override
        public void update(JsonObject json) {
            this.resolver.forEach(json, this::renameFields);
        }

        private void renameFields(JsonObject json) {
            String current = this.history[this.history.length - 1];
            for (int i = 0; i < this.history.length - 1; ++i) {
                String key = this.history[i];
                JsonValue original = json.get(key);
                if (original == null) continue;
                json.set(current, original);
                json.remove(key);
            }
        }
    }

    public static interface Updater {
        public void update(JsonObject var1);
    }

    public static class RecursiveObjectResolver
    extends ObjectResolver {
        private final String key;

        private RecursiveObjectResolver(String key) {
            this.key = key;
        }

        @Override
        public void forEach(JsonObject json, Consumer<JsonObject> fn) {
            for (JsonObject.Member member : json) {
                JsonValue value = member.getValue();
                if (member.getName().equals(this.key)) {
                    HjsonTools.getRegularObjects(json, this.key).forEach(fn);
                }
                if (value.isObject()) {
                    this.forEach(value.asObject(), fn);
                    continue;
                }
                if (!value.isArray()) continue;
                this.forEachInArray(value.asArray(), fn);
            }
        }

        private void forEachInArray(JsonArray array, Consumer<JsonObject> fn) {
            for (JsonValue value : array) {
                if (value.isObject()) {
                    this.forEach(value.asObject(), fn);
                    continue;
                }
                if (!value.isArray()) continue;
                this.forEachInArray(value.asArray(), fn);
            }
        }
    }

    public static class StaticObjectResolver
    extends ObjectResolver {
        private final String[] path;

        private StaticObjectResolver(String[] path) {
            this.path = path;
        }

        @Override
        public void forEach(JsonObject json, Consumer<JsonObject> fn) {
            this.forEachContainer(json, 0, fn);
        }

        private void forEachContainer(JsonObject container, int index, Consumer<JsonObject> fn) {
            if (index < this.path.length) {
                for (JsonObject o : HjsonTools.getRegularObjects(container, this.path[index])) {
                    this.forEachContainer(o, index + 1, fn);
                }
            } else if (index == this.path.length) {
                fn.accept(container);
            }
        }
    }

    public static abstract class ObjectResolver {
        private final List<Updater> updates = new LinkedList<Updater>();

        public final ObjectResolver history(String ... names) {
            this.updates.add(new RenameHistory(this, names));
            return this;
        }

        public final ObjectResolver collapse(String outer, String inner) {
            this.updates.add(new PathCollapseHelper(this, outer, inner));
            return this;
        }

        public final ObjectResolver toRange(String minKey, Number minDefault, String maxKey, Number maxDefault, String newKey) {
            this.updates.add(new RangeConverter(this, minKey, minDefault, maxKey, maxDefault, newKey));
            return this;
        }

        public final ObjectResolver markRemoved(String key, String version) {
            this.updates.add(new RemovedFieldNotifier(this, key, version));
            return this;
        }

        public final ObjectResolver renameValue(String key, String from, String to) {
            this.updates.add(new FieldRenameHelper(this, key, from, to));
            return this;
        }

        public final ObjectResolver transform(String key, MemberTransformation transformation) {
            this.updates.add(new MemberTransformationHelper(this, key, transformation));
            return this;
        }

        public final void updateAll(JsonObject json) {
            for (Updater update : this.updates) {
                update.update(json);
            }
        }

        public abstract void forEach(JsonObject var1, Consumer<JsonObject> var2);
    }
}

