/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.config.PresetReader;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class ImportHelper {
    public static JsonObject getRequiredImport(Map<File, JsonObject> definitions, String exp) {
        Objects.requireNonNull(exp, "Imports may not be null");
        Import helper = new Import(exp);
        JsonObject json = helper.loadObject(definitions).orElseThrow(() -> CommonMethods.runExF("Use of undeclared import: {}", exp));
        return ImportHelper.readImport(json, helper);
    }

    public static JsonObject getRequiredImport(String exp) {
        Objects.requireNonNull(exp, "Imports may not be null");
        Import helper = new Import(exp);
        JsonObject json = helper.tryLoadObject().orElseThrow(() -> CommonMethods.runExF("Invalid import: {}", exp));
        return ImportHelper.readImport(json, helper);
    }

    public static Map<File, JsonObject> locateDefinitions(String exp) {
        Objects.requireNonNull(exp, "Imports may not be null");
        HashMap<File, JsonObject> definitions = new HashMap<File, JsonObject>();
        ImportHelper.locateRecursively(definitions, exp);
        return definitions;
    }

    private static void locateRecursively(Map<File, JsonObject> definitions, String exp) {
        Import helper = new Import(exp);
        File file = helper.locateFile().orElseThrow(() -> CommonMethods.runExF("Unable to locate {} in {}", helper.filename, exp));
        if (definitions.containsKey(file)) {
            return;
        }
        JsonObject json = PresetReader.getPresetJson(file).orElseThrow(() -> CommonMethods.runExF("Error parsing {}", file));
        definitions.put(file, json);
        JsonValue imports = json.get("imports");
        if (imports != null) {
            JsonArray importArray = HjsonTools.asOrToArray(imports);
            for (JsonValue importExp : importArray) {
                if (!importExp.isString()) {
                    throw CommonMethods.runExF("Invalid import expression: {}", importExp);
                }
                ImportHelper.locateRecursively(definitions, importExp.asString());
            }
        }
    }

    public static List<String> getKeys(Map<File, JsonObject> definitions, String exp) {
        Objects.requireNonNull(exp, "Imports may not be null");
        Import helper = new Import(exp);
        if (helper.as.isPresent()) {
            return Collections.singletonList(helper.as.get());
        }
        if (helper.variable.isPresent()) {
            return Collections.singletonList(helper.variable.get());
        }
        JsonObject json = helper.loadObject(definitions).orElseThrow(() -> CommonMethods.runExF("Expression not validated in time: {}", exp));
        return json.getNames();
    }

    private static JsonObject readImport(JsonObject imported, Import helper) {
        if (helper.as.isPresent() && !helper.variable.isPresent()) {
            return new JsonObject().add(helper.as.get(), imported);
        }
        if (helper.variable.isPresent()) {
            String key = helper.variable.get();
            if (!imported.has(key)) {
                String asFunction = key + "()";
                if (imported.has(asFunction)) {
                    key = asFunction;
                } else {
                    throw CommonMethods.runExF("Import refers to unknown key: {}", key);
                }
            }
            String name = helper.as.orElse(key);
            return new JsonObject().add(name, imported.get(key));
        }
        return imported;
    }

    private static class Import {
        final String filename;
        final Optional<String> variable;
        final Optional<String> as;

        Import(String statement) {
            String[] splitAs = statement.split("\\s+(as|AS|As)\\s+");
            String[] splitVar = splitAs[0].split("\\s*::\\s*");
            this.filename = splitVar[0];
            this.variable = splitVar.length > 1 ? CommonMethods.full(splitVar[1]) : CommonMethods.empty();
            this.as = splitAs.length > 1 ? CommonMethods.full(splitAs[1]) : CommonMethods.empty();
        }

        Optional<JsonObject> loadObject(Map<File, JsonObject> defs) {
            JsonObject root = defs.get(new File(CaveInit.IMPORT_DIR, this.filename));
            if (root != null) {
                return CommonMethods.full(root);
            }
            return CommonMethods.find(defs.entrySet(), e -> this.matches((File)e.getKey())).map(Map.Entry::getValue);
        }

        Optional<JsonObject> tryLoadObject() {
            return this.locateFile().flatMap(PresetReader::getPresetJson);
        }

        Optional<File> locateFile() {
            File root = new File(CaveInit.IMPORT_DIR, this.filename);
            if (root.exists()) {
                return CommonMethods.full(root);
            }
            return SafeFileIO.getFileRecursive(CaveInit.IMPORT_DIR, this::matches);
        }

        boolean matches(File f) {
            return f.getPath().replace("\\", "/").endsWith(this.filename);
        }
    }
}

