/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.Optional;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class PresetCompressor {
    public static void compress(JsonObject json) {
        JsonObject clone = new JsonObject();
        for (JsonObject.Member member : json) {
            String name = member.getName();
            JsonValue value = member.getValue();
            clone.add(name, value);
            if (value.isArray()) {
                PresetCompressor.compressSingle(value.asArray()).ifPresent(single -> clone.set(name, (JsonValue)single));
                continue;
            }
            if (!value.isObject()) continue;
            PresetCompressor.compress(value.asObject());
        }
        json.clear();
        json.addAll(clone);
    }

    private static void compressArray(JsonArray array) {
        JsonArray clone = new JsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonValue value = array.get(i);
            clone.add(value);
            if (value.isArray()) {
                Optional<JsonValue> single = PresetCompressor.compressSingle(value.asArray());
                if (!single.isPresent()) continue;
                clone.set(i, single.get());
                continue;
            }
            if (!value.isObject()) continue;
            PresetCompressor.compress(value.asObject());
        }
        array.clear();
        array.addAll(clone);
    }

    private static Optional<JsonValue> compressSingle(JsonArray array) {
        if (array.size() == 1) {
            JsonValue single = array.get(0);
            if (single.isObject()) {
                PresetCompressor.compress(single.asObject());
            } else if (single.isArray()) {
                PresetCompressor.compressArray(single.asArray());
            }
            return CommonMethods.full(single);
        }
        if (!array.isEmpty()) {
            PresetCompressor.compressArray(array);
        }
        return CommonMethods.empty();
    }
}

