/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.config.CavePreset;
import com.personthecat.cavegenerator.data.CaveBlockSettings;
import com.personthecat.cavegenerator.data.CavernSettings;
import com.personthecat.cavegenerator.data.ClusterSettings;
import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.LayerSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.NoiseRegionSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.data.PillarSettings;
import com.personthecat.cavegenerator.data.RavineSettings;
import com.personthecat.cavegenerator.data.ShellSettings;
import com.personthecat.cavegenerator.data.StalactiteSettings;
import com.personthecat.cavegenerator.data.StructureSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.model.Direction;
import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.model.ScalableFloat;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hjson.JsonObject;

public class PresetTester {
    private static final Logger log = LogManager.getLogger(PresetTester.class);
    private final CavePreset preset;
    private final Level low;
    private final Level high;
    private final String name;

    public PresetTester(CavePreset preset, String name, boolean allowCrash) {
        this.low = allowCrash ? Level.WARN : Level.INFO;
        this.high = allowCrash ? Level.FATAL : Level.WARN;
        this.preset = preset;
        this.name = name;
    }

    public void run() {
        log.info(" ### Begin testing {} ###", (Object)this.name);
        log.info(" --- Json diagnostics ---");
        this.debugExistingFields(this.preset.raw);
        this.debugUnusedFields(this.preset.raw);
        log.info(" --- Logic and syntax diagnostics ---");
        this.testTunnels(this.preset.tunnels);
        this.testRavines(this.preset.ravines);
        this.testCaverns(this.preset.caverns);
        this.testStructures(this.preset.structures);
        this.testClusters(this.preset.clusters);
        this.testLayers(this.preset.layers);
        this.testStalactites(this.preset.stalactites);
        this.testPillars(this.preset.pillars);
        log.info(" ### {} testing complete ###", (Object)this.name);
    }

    private void debugExistingFields(JsonObject json) {
        List<String> used = json.getUsedPaths();
        if (used.isEmpty()) {
            log.info("No fields were detected in {}. If you were expecting fields, you may have commented it out.", (Object)this.name);
            return;
        }
        log.info("The following fields were found in {}. If you do not see one, you may have accidentally commented it out.", (Object)this.name);
        for (String s : used) {
            log.info(" + {} ", (Object)s);
        }
    }

    private void debugUnusedFields(JsonObject json) {
        List<String> unused = json.getUnusedPaths();
        if (unused.isEmpty()) {
            log.info("No unused fields were detected inside of {}", (Object)this.name);
            return;
        }
        log.info("The following fields were never used by {}. Any field listed below has no effect whatsoever.", (Object)this.name);
        for (String s : unused) {
            log.log(this.low, " - {}", (Object)s);
        }
    }

    private void testTunnels(List<TunnelSettings> s) {
        String path = "tunnels";
        for (TunnelSettings cfg : s) {
            this.testTunnel(cfg, "tunnels");
            this.testConditions(cfg.conditions, "tunnels");
            this.testDecorators(cfg.decorators, "tunnels");
        }
    }

    private void testTunnel(TunnelSettings s, String path) {
        this.testDistance(s.distance, PresetTester.join(path, "distance"));
        this.assertPositive(s.systemDensity, PresetTester.join(path, "systemDensity"));
        this.testAngle(s.yaw, PresetTester.join(path, "yaw"));
        this.testAngle(s.pitch, PresetTester.join(path, "pitch"));
        this.testScale(s.scale, PresetTester.join(path, "scale"));
        s.branches.ifPresent(b -> this.testTunnel((TunnelSettings)b, PresetTester.join(path, "branches")));
    }

    private void testRavines(List<RavineSettings> s) {
        String path = "tunnels";
        for (RavineSettings cfg : s) {
            this.testRavine(cfg, "tunnels");
            this.testConditions(cfg.conditions, "tunnels");
            this.testDecorators(cfg.decorators, "tunnels");
        }
    }

    private void testRavine(RavineSettings s, String path) {
        this.testDistance(s.distance, PresetTester.join(path, "distance"));
        this.testAngle(s.yaw, PresetTester.join(path, "yaw"));
        this.testAngle(s.pitch, PresetTester.join(path, "pitch"));
        this.testScale(s.scale, PresetTester.join(path, "scale"));
        this.testNoise(s.walls, PresetTester.join(path, "walls"));
    }

    private void testCaverns(List<CavernSettings> s) {
        String path = "caverns";
        for (CavernSettings cfg : s) {
            this.testCavern(cfg, "caverns");
            this.testConditions(cfg.conditions, "caverns");
            this.testDecorators(cfg.decorators, "caverns");
        }
    }

    private void testCavern(CavernSettings s, String path) {
        String fullPath = PresetTester.join(path, "generators");
        for (int i = 0; i < s.generators.size(); ++i) {
            this.testNoise(s.generators.get(i), fullPath + "[" + i + "]");
        }
        if (s.wallInterpolation) {
            log.log(this.low, "{} is experimental. There may be bugs.", (Object)PresetTester.join(path, "wallInterpolation"));
        }
        if ((double)s.wallCurveRatio > 2.0) {
            log.log(this.low, "{} is a little high. You may see borders.", (Object)PresetTester.join(path, "wallCurveRatio"));
        }
        s.walls.ifPresent(n -> this.testNoise((NoiseMapSettings)n, PresetTester.join(path, "walls")));
        s.offset.ifPresent(n -> this.testNoise((NoiseMapSettings)n, PresetTester.join(path, "offset")));
        s.wallOffset.ifPresent(n -> this.testNoise((NoiseMapSettings)n, PresetTester.join(path, "wallOffset")));
    }

    private void testStructures(List<StructureSettings> s) {
        String path = "structures";
        for (StructureSettings cfg : s) {
            this.testStructure(cfg, "structures");
            this.testConditions(cfg.conditions, "structures");
        }
    }

    private void testStructure(StructureSettings s, String path) {
        int checks;
        String fullPath = path + "[name=" + s.name + "]";
        if (s.placement.func_189948_f() < 0.0f || s.placement.func_189948_f() > 1.0f) {
            log.log(this.high, "Invalid integrity @ {}. Use a number between 0 and 1.", (Object)fullPath);
        }
        if (s.count > 100) {
            log.log(this.low, "Unusually high count @ {}. Consider a dedicated mod.", (Object)fullPath);
        }
        if ((checks = s.airChecks.size() + s.waterChecks.size() + s.nonSolidChecks.size() + s.solidChecks.size()) > 25) {
            log.log(this.low, "Unusually high number of checks @ {}. Try to optimize.", (Object)fullPath);
        }
        this.testChance(s.chance, fullPath);
    }

    private void testClusters(List<ClusterSettings> clusters) {
        String path = "clusters";
        for (ClusterSettings cfg : clusters) {
            String fullPath = "clusters[states=" + cfg.states.get(0) + "...]";
            this.testCluster(cfg, fullPath);
            this.testConditions(cfg.conditions, fullPath);
        }
    }

    private void testCluster(ClusterSettings s, String path) {
        Range height = s.conditions.height;
        if (!height.contains(s.centerHeight.min) || height.contains(s.centerHeight.max)) {
            String center = "centerHeight";
            log.log(this.low, "Invalid heights @ {}. {} does not contain {}", (Object)path, (Object)height, (Object)"centerHeight");
        }
        this.testChance(s.chance, path);
    }

    private void testLayers(List<LayerSettings> s) {
        String path = "layers";
        int previousHeight = -1;
        for (LayerSettings l : s) {
            String fullPath = "layers[state=" + l.state + "]";
            int maxRange = l.conditions.ceiling.map(c -> c.range.max).orElse(0);
            int max = l.conditions.height.max + maxRange;
            if (max <= previousHeight) {
                log.log(this.low, "Unclear Layer height settings. The array is not sorted in ascending order.");
            }
            previousHeight = max;
            this.testConditions(l.conditions, fullPath);
        }
    }

    private void testStalactites(List<StalactiteSettings> s) {
        String path = "stalactites";
        for (StalactiteSettings cfg : s) {
            String fullPath = "stalactites[state" + cfg.state + "]";
            this.testStalactite(cfg, fullPath);
            this.testConditions(cfg.conditions, fullPath);
        }
    }

    private void testStalactite(StalactiteSettings s, String path) {
        this.testChance(s.chance, path);
    }

    private void testPillars(List<PillarSettings> s) {
        String path = "pillars";
        for (PillarSettings cfg : s) {
            String fullPath = "pillars[state=" + cfg.state + "]";
            this.testConditions(cfg.conditions, fullPath);
        }
    }

    private void testDistance(int distance, String path) {
        if (distance < 0) {
            log.log(this.low, "Negative value @ {}. This will have no effect.", (Object)path);
        }
    }

    private void testConditions(ConditionSettings s, String path) {
        this.testDimensionList(s.dimensions, s.blacklistDimensions, path);
        this.testBiomeList(s.biomes, s.blacklistBiomes, path);
        s.noise.ifPresent(n -> this.testNoise((NoiseSettings)n, path));
        s.ceiling.ifPresent(n -> this.testNoise((NoiseMapSettings)n, path));
        s.floor.ifPresent(n -> this.testNoise((NoiseMapSettings)n, path));
        s.region.ifPresent(n -> this.testNoise((NoiseRegionSettings)n, path));
    }

    private void testDecorators(DecoratorSettings s, String path) {
        this.testCaveBlocks(s.caveBlocks, path);
        this.testWallDecorators(s.wallDecorators, path);
        this.testShell(s.shell, path);
    }

    private void testCaveBlocks(List<CaveBlockSettings> caveBlocks, String path) {
        int lastMinHeight = -1;
        int lastMaxHeight = -1;
        boolean foundGuaranteed = false;
        for (CaveBlockSettings c : caveBlocks) {
            String fullPath = path + ".caveBlocks[states=" + c.states + "...]";
            if (foundGuaranteed) {
                log.log(this.high, "Additional CaveBlock objects found despite an earlier object where `chance=1`. {} will have no effect.", (Object)fullPath);
            }
            int minY = c.height.min;
            int maxY = c.height.max;
            boolean hasNoise = c.noise.isPresent();
            if (c.integrity == 1.0 && !hasNoise && lastMinHeight == minY && lastMaxHeight == maxY) {
                foundGuaranteed = true;
            }
            lastMinHeight = minY;
            lastMaxHeight = maxY;
            this.testChance(c.integrity, fullPath);
            c.noise.ifPresent(n -> this.testNoise((NoiseSettings)n, fullPath));
        }
    }

    private void testWallDecorators(List<WallDecoratorSettings> wallDecorators, String path) {
        int lastMinHeight = -1;
        int lastMaxHeight = -1;
        boolean foundGuaranteed = false;
        for (WallDecoratorSettings d : wallDecorators) {
            String fullPath = path + ".wallDecorators[states=" + d.states.get(0) + "...]";
            if (foundGuaranteed) {
                log.log(this.high, "Additional WallDecorator objects found despite an earlier object where `chance=1`. {} will have no effect.", (Object)fullPath);
            }
            int minY = d.height.min;
            int maxY = d.height.max;
            boolean hasNoise = d.noise.isPresent();
            if (d.integrity == 1.0 && !hasNoise && lastMinHeight == minY && lastMaxHeight == maxY) {
                log.log(this.low, "{} uses full coverage. It may be better to use Shells or Clusters.", (Object)fullPath);
                foundGuaranteed = true;
            }
            lastMinHeight = minY;
            lastMaxHeight = maxY;
            this.testChance(d.integrity, fullPath);
            this.testDirections(d.directions, fullPath);
            d.noise.ifPresent(s -> this.testNoise((NoiseSettings)s, fullPath));
        }
    }

    private void testShell(ShellSettings shell, String path) {
        String decoratorPath = PresetTester.join(path, "shell", "decorators");
        for (int i = 0; i < shell.decorators.size(); ++i) {
            ShellSettings.Decorator d = shell.decorators.get(i);
            String fullPath = decoratorPath + "[" + i + "]";
            this.testChance(d.integrity, fullPath);
            d.noise.ifPresent(n -> this.testNoise((NoiseSettings)n, fullPath));
        }
    }

    private void testDimensionList(List<Integer> dims, boolean blacklist, String path) {
        if (dims.size() > 8) {
            log.log(this.low, "High number of dimensions in the dimension list @ {}. Consider {} `blacklistDimensions`.", (Object)path, (Object)(blacklist ? "disabling" : "enabling"));
            log.log(this.low, "If you want this feature to spawn anywhere, you can leave the list empty.");
        }
    }

    private void testBiomeList(List<Biome> biomes, boolean blacklist, String path) {
        if (biomes.size() > ForgeRegistries.BIOMES.getValuesCollection().size() / 2) {
            log.log(this.low, "High number of dimensions in the dimension list @ {}. Consider {} `blacklistBiomes`.", (Object)path, (Object)(blacklist ? "disabling" : "enabling"));
            log.log(this.low, "If you want this feature to spawn anywhere, you can leave the list empty.");
        }
    }

    private void assertPositive(int val, String path) {
        if (val <= 0) {
            log.log(this.high, "Invalid number # {}. It must be > 0", (Object)path);
        }
    }

    private void testAngle(ScalableFloat angle, String path) {
        if ((double)angle.startVal > 6.0 || (double)angle.startVal < 0.0) {
            log.log(this.low, "Invalid angle @ {}. This value should be in radians (0 - 6).", (Object)path);
        }
    }

    private void testScale(ScalableFloat scale, String path) {
        if ((double)scale.factor > 2.0 || (double)scale.factor < -2.0) {
            log.log(this.low, "Potentially dangerous factor @ {}. This object will be very large.", (Object)path);
        }
        if ((double)scale.exponent > 1.5) {
            log.log(this.low, "potentially dangerous exponent @ {}. This object will be extremely large.", (Object)path);
        }
    }

    private void testNoise(NoiseSettings noise, String path) {
        this.testNoiseFrequency(noise.frequency, path);
        this.testNoiseThreshold(noise.threshold, path);
        this.testNoiseOctaves(noise.octaves, path);
    }

    private void testNoise(NoiseRegionSettings noise, String path) {
        this.testNoiseFrequency(noise.frequency, path);
        this.testNoiseThreshold(noise.threshold, path);
    }

    private void testNoise(NoiseMapSettings noise, String path) {
        this.testNoiseFrequency(noise.frequency, path);
        this.testNoiseOctaves(noise.octaves, path);
    }

    private void testChance(double chance, String path) {
        if (chance < 0.0 || chance > 1.0) {
            log.log(this.low, "Poor chance @ {}. Use a value between 0 and 1.", (Object)path);
        }
    }

    private void testNoiseFrequency(float frequency, String path) {
        if (frequency < 0.0f || frequency > 1.0f) {
            log.log(this.low, "Poor frequency value @ {}. If you are converting presets from a previous version, `spacing` can be converted using the formula `frequency = 1 / spacing`.", (Object)path);
        }
    }

    private void testNoiseThreshold(FloatRange threshold, String path) {
        if ((double)threshold.min < -1.0 || (double)threshold.max > 1.0) {
            log.log(this.low, "Poor threshold @ {}. Use a range between -1 and 1.", (Object)path);
        }
    }

    private void testNoiseOctaves(int octaves, String path) {
        if (octaves < 0) {
            log.log(this.low, "Octaves are < 0 @ {}. Octaves is a count and should be > 0.", (Object)path);
        } else if (octaves == 0) {
            log.log(this.low, "Octaves are == 0 @ {}. Set dummy: true if you want this generator to have no effect.", (Object)path);
        } else if (octaves > 5) {
            log.log(this.low, "Unusually high octave count @ {}. This is expensive and may have no effect.", (Object)path);
        }
    }

    private void testDirections(List<Direction> directions, String path) {
        boolean containsSide = directions.contains((Object)Direction.SIDE);
        for (Direction d : directions) {
            if ((!d.equals((Object)Direction.ALL) || directions.size() <= 1) && (!containsSide || !PresetTester.isSide(d))) continue;
            log.log(this.low, "Direction array contains unnecessary values @ {}.", (Object)path);
            return;
        }
    }

    private static boolean isSide(Direction d) {
        return d == Direction.NORTH || d == Direction.SOUTH || d == Direction.EAST || d == Direction.WEST;
    }

    private static String join(String ... path) {
        return String.join((CharSequence)".", path);
    }
}

