/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.config;

import com.personthecat.cavegenerator.util.CommonMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hjson.HjsonOptions;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class ReferenceHelper {
    public static final HjsonOptions FORMATTER = new HjsonOptions().setParseLegacyRoot(false).setOutputComments(false).setAllowCondense(true).setAllowMultiVal(true).setCommentSpace(0).setSpace(2).setBracesSameLine(true);

    public static Optional<JsonValue> trySubstitute(JsonObject from, String s) {
        if (!Reference.containsReferences(s)) {
            return CommonMethods.empty();
        }
        return CommonMethods.full(Reference.replaceAll(from, s));
    }

    public static JsonValue readValue(JsonObject from, String ref) {
        if (from.has(ref)) {
            return from.get(ref);
        }
        String asFunction = ref + "()";
        if (from.has(asFunction)) {
            return from.get(asFunction);
        }
        throw CommonMethods.runExF("Use of undeclared variable: {}", ref);
    }

    private static int findQuestion(String val, int index) {
        return ReferenceHelper.findSpecialCharacter(val, index, '?');
    }

    private static int findOpening(String val, int index) {
        return ReferenceHelper.findSpecialCharacter(val, index, '(');
    }

    private static int findSpecialCharacter(String val, int index, char f) {
        for (int i = index; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == f) {
                return i;
            }
            if (!Character.isLetterOrDigit(c)) continue;
            return -1;
        }
        return -1;
    }

    private static int findClosing(String val, int opening, char open, char close) {
        int numP = 0;
        boolean dq = false;
        boolean sq = false;
        boolean esc = false;
        for (int i = opening; i < val.length(); ++i) {
            if (esc) {
                esc = false;
                continue;
            }
            char c = val.charAt(i);
            if (c == '\\') {
                esc = true;
                continue;
            }
            if (c == '\"') {
                dq = !dq;
                continue;
            }
            if (c == '\'') {
                sq = !sq;
                continue;
            }
            if (c == open) {
                if (dq || sq) continue;
                ++numP;
                continue;
            }
            if (c != close || dq || sq || --numP != 0) continue;
            return i;
        }
        throw new IllegalStateException("Missing " + close + " in function");
    }

    private static int findNext(String val, int index, char f, boolean required) {
        boolean esc = false;
        int i = index;
        while (i < val.length()) {
            if (esc) {
                esc = false;
                ++i;
                continue;
            }
            char c = val.charAt(i);
            if (c == '\\') {
                esc = true;
            } else if (c == f) {
                return i;
            }
            if (f == '\"' || f == '\'') {
                ++i;
                continue;
            }
            if (c == '(') {
                i = ReferenceHelper.findClosing(val, i, '(', ')');
                continue;
            }
            if (c == '[') {
                i = ReferenceHelper.findClosing(val, i, '[', ']');
                continue;
            }
            if (c == '{') {
                i = ReferenceHelper.findClosing(val, i, '{', '}');
                continue;
            }
            ++i;
        }
        if (required) {
            throw new IllegalStateException("Missing " + f + " in function");
        }
        return val.length();
    }

    private static String quote(String s) {
        char first = s.charAt(0);
        char last = s.charAt(s.length() - 1);
        if (Character.isWhitespace(first)) {
            boolean single = ReferenceHelper.containsRawDoubleQuote(s);
            return single ? '\'' + s + '\'' : '\"' + s + '\"';
        }
        if (first == '{' && last == '}' || first == '[' && last == ']') {
            return s;
        }
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            boolean single = ReferenceHelper.containsRawDoubleQuote(s);
            return single ? '\'' + s + '\'' : '\"' + s + '\"';
        }
        return s;
    }

    private static boolean containsRawDoubleQuote(String s) {
        boolean escaped = false;
        for (char c : s.toCharArray()) {
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"' && !escaped) {
                return true;
            }
            escaped = false;
        }
        return false;
    }

    private static class Argument {
        static final Pattern ARGUMENT_PATTERN = Pattern.compile("@(\\d+)");
        final int start;
        final int end;
        final int index;
        final boolean optional;
        final String defaultVal;

        static boolean containsArgument(String val) {
            return ARGUMENT_PATTERN.matcher(val).find();
        }

        static int countArguments(String val) {
            Matcher matcher = ARGUMENT_PATTERN.matcher(val);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            return count;
        }

        static String generateValue(JsonObject json, Reference r) {
            JsonValue value = ReferenceHelper.readValue(json, r.key);
            if (value.isString()) {
                return Argument.replaceString(value.asString(), r);
            }
            if (value.isObject()) {
                value = Argument.replaceObject(value.asObject(), r);
            } else if (value.isArray()) {
                value = Argument.replaceArray(value.asArray(), r);
            }
            return value.toString(FORMATTER);
        }

        static String replaceString(String val, Reference r) {
            int numArguments = Argument.countArguments(val);
            String buffer = val;
            int skipped = 0;
            for (int i = 0; i < numArguments; ++i) {
                String sub;
                Argument a = Argument.create(buffer, skipped);
                if (r.args.size() <= a.index) {
                    if (!a.optional) {
                        throw new IllegalStateException("Missing argument: " + (a.index + 1));
                    }
                    sub = a.defaultVal.isEmpty() ? "" : Argument.replaceString(a.defaultVal, r);
                } else {
                    sub = r.args.get(a.index);
                }
                int numParams = Argument.countArguments(sub);
                if (numParams == 1) {
                    Argument param = Argument.create(sub, 0);
                    if (!a.defaultVal.isEmpty() && param.defaultVal.isEmpty()) {
                        sub = sub + "(" + a.defaultVal + ")";
                    }
                }
                buffer = buffer.substring(0, a.start) + sub + buffer.substring(a.end);
                skipped += numParams;
            }
            return buffer;
        }

        static JsonObject replaceObject(JsonObject json, Reference r) {
            JsonObject clone = new JsonObject();
            for (JsonObject.Member member : json) {
                String name = Argument.replaceString(member.getName(), r);
                if (name.isEmpty()) continue;
                JsonValue value = member.getValue();
                if (value.isString()) {
                    String s = Argument.replaceString(value.asString(), r);
                    if (s.isEmpty()) continue;
                    clone.add(name, JsonValue.readHjson(ReferenceHelper.quote(s), FORMATTER));
                    continue;
                }
                if (value.isObject()) {
                    clone.add(name, Argument.replaceObject(value.asObject(), r));
                    continue;
                }
                if (value.isArray()) {
                    clone.add(name, Argument.replaceArray(value.asArray(), r));
                    continue;
                }
                clone.add(name, value);
            }
            return clone;
        }

        static JsonArray replaceArray(JsonArray json, Reference r) {
            JsonArray clone = new JsonArray();
            for (JsonValue value : json) {
                if (value.isString()) {
                    String s = Argument.replaceString(value.asString(), r);
                    if (s.isEmpty()) continue;
                    clone.add(s);
                    continue;
                }
                if (value.isObject()) {
                    clone.add(Argument.replaceObject(value.asObject(), r));
                    continue;
                }
                if (value.isArray()) {
                    clone.add(Argument.replaceArray(value.asArray(), r));
                    continue;
                }
                clone.add(value);
            }
            return clone;
        }

        static Argument create(String val, int skipped) {
            Matcher matcher = ARGUMENT_PATTERN.matcher(val);
            boolean found = matcher.find();
            for (int i = 0; i < skipped; ++i) {
                found &= matcher.find();
            }
            if (!found) {
                throw new IllegalStateException("No arguments");
            }
            int index = Integer.parseInt(matcher.group(1)) - 1;
            int start = matcher.start();
            int end = matcher.end();
            boolean optional = false;
            String defaultVal = "";
            int question = ReferenceHelper.findQuestion(val, end);
            if (question > -1) {
                optional = true;
                end = question + 1;
                int opening = ReferenceHelper.findOpening(val, end);
                if (opening > -1) {
                    int closing = ReferenceHelper.findClosing(val, opening, '(', ')');
                    end = closing + 1;
                    defaultVal = val.substring(opening + 1, closing);
                }
            }
            return new Argument(start, end, index, optional, defaultVal);
        }

        public Argument(int start, int end, int index, boolean optional, String defaultVal) {
            this.start = start;
            this.end = end;
            this.index = index;
            this.optional = optional;
            this.defaultVal = defaultVal;
        }
    }

    private static class Reference {
        static final Pattern REFERENCE_PATTERN = Pattern.compile("(?<!\\\\)\\$(?!\\d)(\\w+)");
        final int start;
        final int end;
        final String key;
        final List<String> args;

        static boolean containsReferences(String val) {
            return REFERENCE_PATTERN.matcher(val).find();
        }

        static JsonValue replaceAll(JsonObject json, String val) {
            String updated;
            String ret = val;
            do {
                Reference r = Reference.create(ret);
                String sub = Argument.generateValue(json, r);
                updated = ret.substring(0, r.start) + sub + ret.substring(r.end);
                if (!ret.equals(updated)) continue;
                throw CommonMethods.runExF("Self reference: {}", sub);
            } while (Reference.containsReferences(ret = updated));
            return JsonValue.readHjson(ret, FORMATTER);
        }

        static Reference create(String val) {
            Matcher matcher = REFERENCE_PATTERN.matcher(val);
            if (!matcher.find()) {
                throw new IllegalStateException("No references");
            }
            ArrayList<String> args = new ArrayList<String>();
            String key = matcher.group(1);
            int start = matcher.start();
            int end = matcher.end();
            int opening = ReferenceHelper.findOpening(val, end);
            if (opening > -1) {
                int closing = ReferenceHelper.findClosing(val, opening, '(', ')');
                end = closing + 1;
                Reference.readArgs(val.substring(opening + 1, closing), args);
            }
            return new Reference(start, end, key, args);
        }

        static void readArgs(String val, List<String> args) {
            for (int i = 0; i < val.length(); ++i) {
                int closing;
                int read;
                char c = val.charAt(i);
                if (c == ' ' || c == '\t') continue;
                switch (c) {
                    case '[': {
                        int bk = ReferenceHelper.findClosing(val, i, '[', ']');
                        closing = read = ReferenceHelper.findNext(val, bk, ',', false);
                        break;
                    }
                    case '{': {
                        int bc = ReferenceHelper.findClosing(val, i, '{', '}');
                        closing = read = ReferenceHelper.findNext(val, bc, ',', false);
                        break;
                    }
                    case '(': {
                        int pr = ReferenceHelper.findClosing(val, i, '(', ')');
                        closing = read = ReferenceHelper.findNext(val, pr, ',', false);
                        break;
                    }
                    case '\"': {
                        read = ReferenceHelper.findNext(val, ++i, '\"', true);
                        closing = ReferenceHelper.findNext(val, read, ',', false);
                        break;
                    }
                    case '\'': {
                        read = ReferenceHelper.findNext(val, ++i, '\'', true);
                        closing = ReferenceHelper.findNext(val, read, ',', false);
                        break;
                    }
                    default: {
                        closing = read = ReferenceHelper.findNext(val, i, ',', false);
                    }
                }
                args.add(val.substring(i, read));
                i = closing + 1;
            }
        }

        public Reference(int start, int end, String key, List<String> args) {
            this.start = start;
            this.end = end;
            this.key = key;
            this.args = args;
        }
    }
}

