/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.data.TunnelSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Optional;
import org.hjson.JsonObject;

public class BurrowSettings {
    private static final NoiseMapSettings DEFAULT_MAP = NoiseMapSettings.builder().frequency(0.005f).perturb(true).perturbAmp(0.1f).perturbFreq(2.5f).build();
    private static final NoiseMapSettings DEFAULT_OFFSET = NoiseMapSettings.builder().frequency(0.01f).range(Range.of(10, 30)).build();
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(10, 50)).build();
    private static final DecoratorSettings DEFAULT_DECORATORS = DecoratorSettings.DEFAULTS;
    public final ConditionSettings conditions;
    public final DecoratorSettings decorators;
    public final NoiseMapSettings map;
    public final NoiseMapSettings offset;
    public final float radius;
    public final float target;
    public final float stretch;
    public final float exponent;
    public final float shift;
    public final float wallDistance;
    public final float wallExponent;
    public final Optional<TunnelSettings> branches;

    public static BurrowSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        DecoratorSettings decorators = overrides.apply(DEFAULT_DECORATORS.toBuilder()).build();
        return BurrowSettings.from(json, BurrowSettings.builder().conditions(conditions).decorators(decorators));
    }

    public static BurrowSettings from(JsonObject json, BurrowSettingsBuilder builder) {
        BurrowSettings original = builder.build();
        return new HjsonMapper(json).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapSelf(o -> builder.decorators(DecoratorSettings.from(o, original.decorators))).mapObject("map", o -> builder.map(NoiseMapSettings.from(o, DEFAULT_MAP))).mapObject("offset", o -> builder.offset(NoiseMapSettings.from(o, DEFAULT_OFFSET))).mapFloat("radius", builder::radius).mapFloat("target", builder::target).mapFloat("stretch", builder::stretch).mapFloat("exponent", builder::exponent).mapFloat("shift", builder::shift).mapFloat("wallDistance", builder::wallDistance).mapFloat("wallExponent", builder::wallExponent).mapObject("branches", o -> BurrowSettings.copyBranches(builder, o)).release(builder::build);
    }

    private static void copyBranches(BurrowSettingsBuilder builder, JsonObject branches) {
        BurrowSettings updated = builder.build();
        builder.branches(CommonMethods.full(TunnelSettings.from(branches, updated.conditions, updated.decorators)));
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static DecoratorSettings $default$decorators() {
        return DEFAULT_DECORATORS;
    }

    private static NoiseMapSettings $default$map() {
        return DEFAULT_MAP;
    }

    private static NoiseMapSettings $default$offset() {
        return DEFAULT_OFFSET;
    }

    private static float $default$radius() {
        return 4.5f;
    }

    private static float $default$target() {
        return 0.1f;
    }

    private static float $default$stretch() {
        return 1.0f;
    }

    private static float $default$exponent() {
        return 4.0f;
    }

    private static float $default$shift() {
        return 0.0f;
    }

    private static float $default$wallDistance() {
        return 18.0f;
    }

    private static float $default$wallExponent() {
        return 2.0f;
    }

    private static Optional<TunnelSettings> $default$branches() {
        return CommonMethods.empty();
    }

    BurrowSettings(ConditionSettings conditions, DecoratorSettings decorators, NoiseMapSettings map, NoiseMapSettings offset, float radius, float target, float stretch, float exponent, float shift, float wallDistance, float wallExponent, Optional<TunnelSettings> branches) {
        this.conditions = conditions;
        this.decorators = decorators;
        this.map = map;
        this.offset = offset;
        this.radius = radius;
        this.target = target;
        this.stretch = stretch;
        this.exponent = exponent;
        this.shift = shift;
        this.wallDistance = wallDistance;
        this.wallExponent = wallExponent;
        this.branches = branches;
    }

    public static BurrowSettingsBuilder builder() {
        return new BurrowSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String decorators = "decorators";
        public static final String map = "map";
        public static final String offset = "offset";
        public static final String radius = "radius";
        public static final String target = "target";
        public static final String stretch = "stretch";
        public static final String exponent = "exponent";
        public static final String shift = "shift";
        public static final String wallDistance = "wallDistance";
        public static final String wallExponent = "wallExponent";
        public static final String branches = "branches";
    }

    public static class BurrowSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private boolean decorators$set;
        private DecoratorSettings decorators$value;
        private boolean map$set;
        private NoiseMapSettings map$value;
        private boolean offset$set;
        private NoiseMapSettings offset$value;
        private boolean radius$set;
        private float radius$value;
        private boolean target$set;
        private float target$value;
        private boolean stretch$set;
        private float stretch$value;
        private boolean exponent$set;
        private float exponent$value;
        private boolean shift$set;
        private float shift$value;
        private boolean wallDistance$set;
        private float wallDistance$value;
        private boolean wallExponent$set;
        private float wallExponent$value;
        private boolean branches$set;
        private Optional<TunnelSettings> branches$value;

        BurrowSettingsBuilder() {
        }

        public BurrowSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public BurrowSettingsBuilder decorators(DecoratorSettings decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public BurrowSettingsBuilder map(NoiseMapSettings map) {
            this.map$value = map;
            this.map$set = true;
            return this;
        }

        public BurrowSettingsBuilder offset(NoiseMapSettings offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public BurrowSettingsBuilder radius(float radius) {
            this.radius$value = radius;
            this.radius$set = true;
            return this;
        }

        public BurrowSettingsBuilder target(float target) {
            this.target$value = target;
            this.target$set = true;
            return this;
        }

        public BurrowSettingsBuilder stretch(float stretch) {
            this.stretch$value = stretch;
            this.stretch$set = true;
            return this;
        }

        public BurrowSettingsBuilder exponent(float exponent) {
            this.exponent$value = exponent;
            this.exponent$set = true;
            return this;
        }

        public BurrowSettingsBuilder shift(float shift) {
            this.shift$value = shift;
            this.shift$set = true;
            return this;
        }

        public BurrowSettingsBuilder wallDistance(float wallDistance) {
            this.wallDistance$value = wallDistance;
            this.wallDistance$set = true;
            return this;
        }

        public BurrowSettingsBuilder wallExponent(float wallExponent) {
            this.wallExponent$value = wallExponent;
            this.wallExponent$set = true;
            return this;
        }

        public BurrowSettingsBuilder branches(Optional<TunnelSettings> branches) {
            this.branches$value = branches;
            this.branches$set = true;
            return this;
        }

        public BurrowSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = BurrowSettings.$default$conditions();
            }
            DecoratorSettings decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = BurrowSettings.$default$decorators();
            }
            NoiseMapSettings map$value = this.map$value;
            if (!this.map$set) {
                map$value = BurrowSettings.$default$map();
            }
            NoiseMapSettings offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = BurrowSettings.$default$offset();
            }
            float radius$value = this.radius$value;
            if (!this.radius$set) {
                radius$value = BurrowSettings.$default$radius();
            }
            float target$value = this.target$value;
            if (!this.target$set) {
                target$value = BurrowSettings.$default$target();
            }
            float stretch$value = this.stretch$value;
            if (!this.stretch$set) {
                stretch$value = BurrowSettings.$default$stretch();
            }
            float exponent$value = this.exponent$value;
            if (!this.exponent$set) {
                exponent$value = BurrowSettings.$default$exponent();
            }
            float shift$value = this.shift$value;
            if (!this.shift$set) {
                shift$value = BurrowSettings.$default$shift();
            }
            float wallDistance$value = this.wallDistance$value;
            if (!this.wallDistance$set) {
                wallDistance$value = BurrowSettings.$default$wallDistance();
            }
            float wallExponent$value = this.wallExponent$value;
            if (!this.wallExponent$set) {
                wallExponent$value = BurrowSettings.$default$wallExponent();
            }
            Optional branches$value = this.branches$value;
            if (!this.branches$set) {
                branches$value = BurrowSettings.$default$branches();
            }
            return new BurrowSettings(conditions$value, decorators$value, map$value, offset$value, radius$value, target$value, stretch$value, exponent$value, shift$value, wallDistance$value, wallExponent$value, branches$value);
        }

        public String toString() {
            return "BurrowSettings.BurrowSettingsBuilder(conditions$value=" + this.conditions$value + ", decorators$value=" + this.decorators$value + ", map$value=" + this.map$value + ", offset$value=" + this.offset$value + ", radius$value=" + this.radius$value + ", target$value=" + this.target$value + ", stretch$value=" + this.stretch$value + ", exponent$value=" + this.exponent$value + ", shift$value=" + this.shift$value + ", wallDistance$value=" + this.wallDistance$value + ", wallExponent$value=" + this.wallExponent$value + ", branches$value=" + this.branches$value + ")";
        }
    }
}

