/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

public class CaveBlockSettings {
    private static final String FEATURE_NAME = "caveBlocks";
    public final List<IBlockState> states;
    public final double integrity;
    public final Range height;
    public final Optional<NoiseSettings> noise;
    public static final NoiseSettings DEFAULT_NOISE = NoiseSettings.builder().frequency(0.02f).threshold(Range.of(-0.8f)).stretch(1.0f).octaves(1).build();

    public static CaveBlockSettings from(JsonObject json) {
        CaveBlockSettingsBuilder builder = CaveBlockSettings.builder();
        return new HjsonMapper(json).mapRequiredStateList("states", FEATURE_NAME, builder::states).mapObject("noise", o -> CaveBlockSettings.copyNoise(o, builder)).mapFloat("integrity", builder::integrity).mapRange("height", builder::height).release(builder::build);
    }

    private static void copyNoise(JsonObject json, CaveBlockSettingsBuilder builder) {
        builder.noise(CommonMethods.full(NoiseSettings.from(json, DEFAULT_NOISE)));
    }

    private static double $default$integrity() {
        return 1.0;
    }

    private static Range $default$height() {
        return Range.of(0, 50);
    }

    private static Optional<NoiseSettings> $default$noise() {
        return CommonMethods.empty();
    }

    CaveBlockSettings(List<IBlockState> states, double integrity, Range height, Optional<NoiseSettings> noise) {
        this.states = states;
        this.integrity = integrity;
        this.height = height;
        this.noise = noise;
    }

    public static CaveBlockSettingsBuilder builder() {
        return new CaveBlockSettingsBuilder();
    }

    public static final class Fields {
        public static final String states = "states";
        public static final String integrity = "integrity";
        public static final String height = "height";
        public static final String noise = "noise";
    }

    public static class CaveBlockSettingsBuilder {
        private List<IBlockState> states;
        private boolean integrity$set;
        private double integrity$value;
        private boolean height$set;
        private Range height$value;
        private boolean noise$set;
        private Optional<NoiseSettings> noise$value;

        CaveBlockSettingsBuilder() {
        }

        public CaveBlockSettingsBuilder states(List<IBlockState> states) {
            this.states = states;
            return this;
        }

        public CaveBlockSettingsBuilder integrity(double integrity) {
            this.integrity$value = integrity;
            this.integrity$set = true;
            return this;
        }

        public CaveBlockSettingsBuilder height(Range height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public CaveBlockSettingsBuilder noise(Optional<NoiseSettings> noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public CaveBlockSettings build() {
            double integrity$value = this.integrity$value;
            if (!this.integrity$set) {
                integrity$value = CaveBlockSettings.$default$integrity();
            }
            Range height$value = this.height$value;
            if (!this.height$set) {
                height$value = CaveBlockSettings.$default$height();
            }
            Optional noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = CaveBlockSettings.$default$noise();
            }
            return new CaveBlockSettings(this.states, integrity$value, height$value, noise$value);
        }

        public String toString() {
            return "CaveBlockSettings.CaveBlockSettingsBuilder(states=" + this.states + ", integrity$value=" + this.integrity$value + ", height$value=" + this.height$value + ", noise$value=" + this.noise$value + ")";
        }
    }
}

