/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.NoiseRegionSettings;
import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.biome.Biome;
import org.hjson.JsonObject;

public class ConditionSettings {
    public final boolean blacklistBiomes;
    public final List<Biome> biomes;
    public final boolean blacklistDimensions;
    public final List<Integer> dimensions;
    public final Range height;
    public final Optional<NoiseMapSettings> floor;
    public final Optional<NoiseMapSettings> ceiling;
    public final Optional<NoiseRegionSettings> region;
    public final Optional<NoiseSettings> noise;

    public static ConditionSettings from(JsonObject json, ConditionSettings defaults) {
        return ConditionSettings.copyInto(json, defaults.toBuilder());
    }

    public static ConditionSettings from(JsonObject json) {
        return ConditionSettings.copyInto(json, ConditionSettings.builder());
    }

    private static ConditionSettings copyInto(JsonObject json, ConditionSettingsBuilder builder) {
        return new HjsonMapper(json).mapBool("blacklistBiomes", builder::blacklistBiomes).mapBiomes("biomes", builder::biomes).mapBool("blacklistDimensions", builder::blacklistDimensions).mapIntList("dimensions", builder::dimensions).mapRange("height", builder::height).mapObject("floor", o -> ConditionSettings.copyFloor(o, builder)).mapObject("ceiling", o -> ConditionSettings.copyCeiling(o, builder)).mapObject("region", o -> ConditionSettings.copyRegion(o, builder)).mapObject("noise", o -> ConditionSettings.copyNoise(o, builder)).release(builder::build);
    }

    private static void copyFloor(JsonObject json, ConditionSettingsBuilder builder) {
        NoiseMapSettings floor = builder.floor$value.map(cfg -> NoiseMapSettings.from(json, cfg)).orElseGet(() -> NoiseMapSettings.from(json));
        builder.floor(CommonMethods.full(floor));
    }

    private static void copyCeiling(JsonObject json, ConditionSettingsBuilder builder) {
        NoiseMapSettings ceiling = builder.ceiling$value.map(cfg -> NoiseMapSettings.from(json, cfg)).orElseGet(() -> NoiseMapSettings.from(json));
        builder.ceiling(CommonMethods.full(ceiling));
    }

    private static void copyRegion(JsonObject json, ConditionSettingsBuilder builder) {
        NoiseRegionSettings region = builder.region$value.map(cfg -> NoiseRegionSettings.from(json, cfg)).orElseGet(() -> NoiseRegionSettings.from(json));
        builder.region(CommonMethods.full(region));
    }

    private static void copyNoise(JsonObject json, ConditionSettingsBuilder builder) {
        NoiseSettings noise = builder.noise$value.map(cfg -> NoiseSettings.from(json, cfg)).orElseGet(() -> NoiseSettings.from(json));
        builder.noise(CommonMethods.full(noise));
    }

    private static boolean $default$blacklistBiomes() {
        return false;
    }

    private static List<Biome> $default$biomes() {
        return Collections.emptyList();
    }

    private static boolean $default$blacklistDimensions() {
        return false;
    }

    private static List<Integer> $default$dimensions() {
        return Collections.emptyList();
    }

    private static Range $default$height() {
        return Range.of(0, 255);
    }

    private static Optional<NoiseMapSettings> $default$floor() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseMapSettings> $default$ceiling() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseRegionSettings> $default$region() {
        return CommonMethods.empty();
    }

    private static Optional<NoiseSettings> $default$noise() {
        return CommonMethods.empty();
    }

    ConditionSettings(boolean blacklistBiomes, List<Biome> biomes, boolean blacklistDimensions, List<Integer> dimensions, Range height, Optional<NoiseMapSettings> floor, Optional<NoiseMapSettings> ceiling, Optional<NoiseRegionSettings> region, Optional<NoiseSettings> noise) {
        this.blacklistBiomes = blacklistBiomes;
        this.biomes = biomes;
        this.blacklistDimensions = blacklistDimensions;
        this.dimensions = dimensions;
        this.height = height;
        this.floor = floor;
        this.ceiling = ceiling;
        this.region = region;
        this.noise = noise;
    }

    public static ConditionSettingsBuilder builder() {
        return new ConditionSettingsBuilder();
    }

    public ConditionSettingsBuilder toBuilder() {
        return new ConditionSettingsBuilder().blacklistBiomes(this.blacklistBiomes).biomes(this.biomes).blacklistDimensions(this.blacklistDimensions).dimensions(this.dimensions).height(this.height).floor(this.floor).ceiling(this.ceiling).region(this.region).noise(this.noise);
    }

    public static final class Fields {
        public static final String blacklistBiomes = "blacklistBiomes";
        public static final String biomes = "biomes";
        public static final String blacklistDimensions = "blacklistDimensions";
        public static final String dimensions = "dimensions";
        public static final String height = "height";
        public static final String floor = "floor";
        public static final String ceiling = "ceiling";
        public static final String region = "region";
        public static final String noise = "noise";
    }

    public static class ConditionSettingsBuilder {
        private boolean blacklistBiomes$set;
        private boolean blacklistBiomes$value;
        private boolean biomes$set;
        private List<Biome> biomes$value;
        private boolean blacklistDimensions$set;
        private boolean blacklistDimensions$value;
        private boolean dimensions$set;
        private List<Integer> dimensions$value;
        private boolean height$set;
        private Range height$value;
        private boolean floor$set;
        private Optional<NoiseMapSettings> floor$value;
        private boolean ceiling$set;
        private Optional<NoiseMapSettings> ceiling$value;
        private boolean region$set;
        private Optional<NoiseRegionSettings> region$value;
        private boolean noise$set;
        private Optional<NoiseSettings> noise$value;

        ConditionSettingsBuilder() {
        }

        public ConditionSettingsBuilder blacklistBiomes(boolean blacklistBiomes) {
            this.blacklistBiomes$value = blacklistBiomes;
            this.blacklistBiomes$set = true;
            return this;
        }

        public ConditionSettingsBuilder biomes(List<Biome> biomes) {
            this.biomes$value = biomes;
            this.biomes$set = true;
            return this;
        }

        public ConditionSettingsBuilder blacklistDimensions(boolean blacklistDimensions) {
            this.blacklistDimensions$value = blacklistDimensions;
            this.blacklistDimensions$set = true;
            return this;
        }

        public ConditionSettingsBuilder dimensions(List<Integer> dimensions) {
            this.dimensions$value = dimensions;
            this.dimensions$set = true;
            return this;
        }

        public ConditionSettingsBuilder height(Range height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public ConditionSettingsBuilder floor(Optional<NoiseMapSettings> floor) {
            this.floor$value = floor;
            this.floor$set = true;
            return this;
        }

        public ConditionSettingsBuilder ceiling(Optional<NoiseMapSettings> ceiling) {
            this.ceiling$value = ceiling;
            this.ceiling$set = true;
            return this;
        }

        public ConditionSettingsBuilder region(Optional<NoiseRegionSettings> region) {
            this.region$value = region;
            this.region$set = true;
            return this;
        }

        public ConditionSettingsBuilder noise(Optional<NoiseSettings> noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public ConditionSettings build() {
            boolean blacklistBiomes$value = this.blacklistBiomes$value;
            if (!this.blacklistBiomes$set) {
                blacklistBiomes$value = ConditionSettings.$default$blacklistBiomes();
            }
            List biomes$value = this.biomes$value;
            if (!this.biomes$set) {
                biomes$value = ConditionSettings.$default$biomes();
            }
            boolean blacklistDimensions$value = this.blacklistDimensions$value;
            if (!this.blacklistDimensions$set) {
                blacklistDimensions$value = ConditionSettings.$default$blacklistDimensions();
            }
            List dimensions$value = this.dimensions$value;
            if (!this.dimensions$set) {
                dimensions$value = ConditionSettings.$default$dimensions();
            }
            Range height$value = this.height$value;
            if (!this.height$set) {
                height$value = ConditionSettings.$default$height();
            }
            Optional floor$value = this.floor$value;
            if (!this.floor$set) {
                floor$value = ConditionSettings.$default$floor();
            }
            Optional ceiling$value = this.ceiling$value;
            if (!this.ceiling$set) {
                ceiling$value = ConditionSettings.$default$ceiling();
            }
            Optional region$value = this.region$value;
            if (!this.region$set) {
                region$value = ConditionSettings.$default$region();
            }
            Optional noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = ConditionSettings.$default$noise();
            }
            return new ConditionSettings(blacklistBiomes$value, biomes$value, blacklistDimensions$value, dimensions$value, height$value, floor$value, ceiling$value, region$value, noise$value);
        }

        public String toString() {
            return "ConditionSettings.ConditionSettingsBuilder(blacklistBiomes$value=" + this.blacklistBiomes$value + ", biomes$value=" + this.biomes$value + ", blacklistDimensions$value=" + this.blacklistDimensions$value + ", dimensions$value=" + this.dimensions$value + ", height$value=" + this.height$value + ", floor$value=" + this.floor$value + ", ceiling$value=" + this.ceiling$value + ", region$value=" + this.region$value + ", noise$value=" + this.noise$value + ")";
        }
    }
}

