/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

public class LayerSettings {
    private static final String FEATURE_NAME = "layers";
    private static final NoiseMapSettings DEFAULT_NOISE = NoiseMapSettings.builder().frequency(0.015f).range(Range.of(-7, 7)).build();
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(0, 20)).ceiling(CommonMethods.full(DEFAULT_NOISE)).build();
    public final ConditionSettings conditions;
    public final IBlockState state;

    public static LayerSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return LayerSettings.copyInto(json, LayerSettings.builder().conditions(conditions));
    }

    public static LayerSettings from(JsonObject json) {
        return LayerSettings.copyInto(json, LayerSettings.builder());
    }

    private static LayerSettings copyInto(JsonObject json, LayerSettingsBuilder builder) {
        LayerSettings original = builder.build();
        return new HjsonMapper(json).mapRequiredState("state", FEATURE_NAME, builder::state).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).release(builder::build);
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    LayerSettings(ConditionSettings conditions, IBlockState state) {
        this.conditions = conditions;
        this.state = state;
    }

    public static LayerSettingsBuilder builder() {
        return new LayerSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String state = "state";
    }

    public static class LayerSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private IBlockState state;

        LayerSettingsBuilder() {
        }

        public LayerSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public LayerSettingsBuilder state(IBlockState state) {
            this.state = state;
            return this;
        }

        public LayerSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = LayerSettings.$default$conditions();
            }
            return new LayerSettings(conditions$value, this.state);
        }

        public String toString() {
            return "LayerSettings.LayerSettingsBuilder(conditions$value=" + this.conditions$value + ", state=" + this.state + ")";
        }
    }
}

