/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.noise.CachedNoiseGenerator;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import fastnoise.FastNoise;
import java.util.Optional;
import java.util.Random;
import net.minecraft.world.World;
import org.hjson.JsonObject;

public class NoiseMapSettings {
    public final Optional<Integer> seed;
    public final float frequency;
    public final FastNoise.NoiseType type;
    public final float perturbAmp;
    public final float perturbFreq;
    public final int octaves;
    public final Range range;
    public final boolean perturb;
    public final boolean invert;
    public final boolean cache;
    public final boolean dummy;
    public final Optional<Float> dummyOutput;

    public static NoiseMapSettings from(JsonObject json, NoiseMapSettings defaults) {
        return NoiseMapSettings.copyInto(json, defaults.toBuilder());
    }

    public static NoiseMapSettings from(JsonObject json) {
        return NoiseMapSettings.copyInto(json, NoiseMapSettings.builder());
    }

    private static NoiseMapSettings copyInto(JsonObject json, NoiseMapSettingsBuilder builder) {
        return new HjsonMapper(json).mapInt("seed", i -> builder.seed(CommonMethods.full(i))).mapFloat("frequency", builder::frequency).mapNoiseType("type", builder::type).mapFloat("perturbAmp", builder::perturbAmp).mapFloat("perturbFreq", builder::perturbFreq).mapInt("octaves", builder::octaves).mapRange("range", builder::range).mapBool("perturb", builder::perturb).mapBool("invert", builder::invert).mapBool("cache", builder::cache).mapBool("dummy", builder::dummy).mapFloat("dummyOutput", f -> builder.dummyOutput(CommonMethods.full(f))).release(builder::build);
    }

    public FastNoise getGenerator(World world) {
        if (this.dummy) {
            return new DummyGenerator(this.dummyOutput.orElseGet(() -> Float.valueOf((float)(this.range.min + this.range.max) / 2.0f)).floatValue());
        }
        FastNoise noise = new FastNoise(this.getSeed(world)).SetNoiseType(this.type).SetFrequency(this.frequency).SetFractalOctaves(this.octaves).SetRange(this.range.min, this.range.max).SetGradientPerturb(this.perturb).SetGradientPerturbAmp(this.perturbAmp).SetGradientPerturbFrequency(this.perturbFreq).SetInterp(FastNoise.Interp.Hermite).SetInvert(this.invert);
        return this.cache ? new CachedNoiseGenerator(noise) : noise;
    }

    private int getSeed(World world) {
        return this.seed.map(num -> {
            XoRoShiRo rand = new XoRoShiRo(world.func_72905_C());
            FastNoise simple = new FastNoise(((Random)rand).nextInt());
            return Float.floatToIntBits(simple.GetNoise(num.intValue()));
        }).orElseGet(world.field_73012_v::nextInt);
    }

    private static Optional<Integer> $default$seed() {
        return CommonMethods.empty();
    }

    private static float $default$frequency() {
        return 1.0f;
    }

    private static FastNoise.NoiseType $default$type() {
        return FastNoise.NoiseType.SimplexFractal;
    }

    private static float $default$perturbAmp() {
        return 1.0f;
    }

    private static float $default$perturbFreq() {
        return 1.0f;
    }

    private static int $default$octaves() {
        return 1;
    }

    private static Range $default$range() {
        return Range.of(-1, 1);
    }

    private static boolean $default$perturb() {
        return false;
    }

    private static boolean $default$invert() {
        return false;
    }

    private static boolean $default$cache() {
        return false;
    }

    private static boolean $default$dummy() {
        return false;
    }

    private static Optional<Float> $default$dummyOutput() {
        return CommonMethods.empty();
    }

    NoiseMapSettings(Optional<Integer> seed, float frequency, FastNoise.NoiseType type, float perturbAmp, float perturbFreq, int octaves, Range range, boolean perturb, boolean invert, boolean cache, boolean dummy, Optional<Float> dummyOutput) {
        this.seed = seed;
        this.frequency = frequency;
        this.type = type;
        this.perturbAmp = perturbAmp;
        this.perturbFreq = perturbFreq;
        this.octaves = octaves;
        this.range = range;
        this.perturb = perturb;
        this.invert = invert;
        this.cache = cache;
        this.dummy = dummy;
        this.dummyOutput = dummyOutput;
    }

    public static NoiseMapSettingsBuilder builder() {
        return new NoiseMapSettingsBuilder();
    }

    public NoiseMapSettingsBuilder toBuilder() {
        return new NoiseMapSettingsBuilder().seed(this.seed).frequency(this.frequency).type(this.type).perturbAmp(this.perturbAmp).perturbFreq(this.perturbFreq).octaves(this.octaves).range(this.range).perturb(this.perturb).invert(this.invert).cache(this.cache).dummy(this.dummy).dummyOutput(this.dummyOutput);
    }

    public static final class Fields {
        public static final String seed = "seed";
        public static final String frequency = "frequency";
        public static final String type = "type";
        public static final String perturbAmp = "perturbAmp";
        public static final String perturbFreq = "perturbFreq";
        public static final String octaves = "octaves";
        public static final String range = "range";
        public static final String perturb = "perturb";
        public static final String invert = "invert";
        public static final String cache = "cache";
        public static final String dummy = "dummy";
        public static final String dummyOutput = "dummyOutput";
    }

    public static class NoiseMapSettingsBuilder {
        private boolean seed$set;
        private Optional<Integer> seed$value;
        private boolean frequency$set;
        private float frequency$value;
        private boolean type$set;
        private FastNoise.NoiseType type$value;
        private boolean perturbAmp$set;
        private float perturbAmp$value;
        private boolean perturbFreq$set;
        private float perturbFreq$value;
        private boolean octaves$set;
        private int octaves$value;
        private boolean range$set;
        private Range range$value;
        private boolean perturb$set;
        private boolean perturb$value;
        private boolean invert$set;
        private boolean invert$value;
        private boolean cache$set;
        private boolean cache$value;
        private boolean dummy$set;
        private boolean dummy$value;
        private boolean dummyOutput$set;
        private Optional<Float> dummyOutput$value;

        NoiseMapSettingsBuilder() {
        }

        public NoiseMapSettingsBuilder seed(Optional<Integer> seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder frequency(float frequency) {
            this.frequency$value = frequency;
            this.frequency$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder type(FastNoise.NoiseType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder perturbAmp(float perturbAmp) {
            this.perturbAmp$value = perturbAmp;
            this.perturbAmp$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder perturbFreq(float perturbFreq) {
            this.perturbFreq$value = perturbFreq;
            this.perturbFreq$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder octaves(int octaves) {
            this.octaves$value = octaves;
            this.octaves$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder range(Range range) {
            this.range$value = range;
            this.range$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder perturb(boolean perturb) {
            this.perturb$value = perturb;
            this.perturb$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder invert(boolean invert) {
            this.invert$value = invert;
            this.invert$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder cache(boolean cache) {
            this.cache$value = cache;
            this.cache$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder dummy(boolean dummy) {
            this.dummy$value = dummy;
            this.dummy$set = true;
            return this;
        }

        public NoiseMapSettingsBuilder dummyOutput(Optional<Float> dummyOutput) {
            this.dummyOutput$value = dummyOutput;
            this.dummyOutput$set = true;
            return this;
        }

        public NoiseMapSettings build() {
            Optional seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = NoiseMapSettings.$default$seed();
            }
            float frequency$value = this.frequency$value;
            if (!this.frequency$set) {
                frequency$value = NoiseMapSettings.$default$frequency();
            }
            FastNoise.NoiseType type$value = this.type$value;
            if (!this.type$set) {
                type$value = NoiseMapSettings.$default$type();
            }
            float perturbAmp$value = this.perturbAmp$value;
            if (!this.perturbAmp$set) {
                perturbAmp$value = NoiseMapSettings.$default$perturbAmp();
            }
            float perturbFreq$value = this.perturbFreq$value;
            if (!this.perturbFreq$set) {
                perturbFreq$value = NoiseMapSettings.$default$perturbFreq();
            }
            int octaves$value = this.octaves$value;
            if (!this.octaves$set) {
                octaves$value = NoiseMapSettings.$default$octaves();
            }
            Range range$value = this.range$value;
            if (!this.range$set) {
                range$value = NoiseMapSettings.$default$range();
            }
            boolean perturb$value = this.perturb$value;
            if (!this.perturb$set) {
                perturb$value = NoiseMapSettings.$default$perturb();
            }
            boolean invert$value = this.invert$value;
            if (!this.invert$set) {
                invert$value = NoiseMapSettings.$default$invert();
            }
            boolean cache$value = this.cache$value;
            if (!this.cache$set) {
                cache$value = NoiseMapSettings.$default$cache();
            }
            boolean dummy$value = this.dummy$value;
            if (!this.dummy$set) {
                dummy$value = NoiseMapSettings.$default$dummy();
            }
            Optional dummyOutput$value = this.dummyOutput$value;
            if (!this.dummyOutput$set) {
                dummyOutput$value = NoiseMapSettings.$default$dummyOutput();
            }
            return new NoiseMapSettings(seed$value, frequency$value, type$value, perturbAmp$value, perturbFreq$value, octaves$value, range$value, perturb$value, invert$value, cache$value, dummy$value, dummyOutput$value);
        }

        public String toString() {
            return "NoiseMapSettings.NoiseMapSettingsBuilder(seed$value=" + this.seed$value + ", frequency$value=" + this.frequency$value + ", type$value=" + (Object)((Object)this.type$value) + ", perturbAmp$value=" + this.perturbAmp$value + ", perturbFreq$value=" + this.perturbFreq$value + ", octaves$value=" + this.octaves$value + ", range$value=" + this.range$value + ", perturb$value=" + this.perturb$value + ", invert$value=" + this.invert$value + ", cache$value=" + this.cache$value + ", dummy$value=" + this.dummy$value + ", dummyOutput$value=" + this.dummyOutput$value + ")";
        }
    }
}

