/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.noise.CachedNoiseGenerator;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import fastnoise.FastNoise;
import java.util.Optional;
import java.util.Random;
import net.minecraft.world.World;
import org.hjson.JsonObject;

public class NoiseRegionSettings {
    public final Optional<Integer> seed;
    public final FloatRange threshold;
    public final float frequency;
    public final boolean invert;
    public final boolean cache;
    public final boolean dummy;
    public final float dummyOutput;
    public final FastNoise.NoiseType type;

    public static NoiseRegionSettings from(JsonObject json, NoiseRegionSettings defaults) {
        return NoiseRegionSettings.copyInto(json, defaults.toBuilder());
    }

    public static NoiseRegionSettings from(JsonObject json) {
        return NoiseRegionSettings.copyInto(json, NoiseRegionSettings.builder());
    }

    private static NoiseRegionSettings copyInto(JsonObject json, NoiseRegionSettingsBuilder builder) {
        return new HjsonMapper(json).mapInt("seed", i -> builder.seed(CommonMethods.full(i))).mapFloat("frequency", builder::frequency).mapFloatRange("threshold", builder::threshold).mapBool("cache", builder::cache).mapBool("dummy", builder::dummy).mapFloat("dummyOutput", builder::dummyOutput).mapNoiseType("type", builder::type).release(builder::build);
    }

    public FastNoise getGenerator(World world) {
        if (this.dummy) {
            return new DummyGenerator(this.dummyOutput);
        }
        FastNoise noise = new FastNoise(this.getSeed(world)).SetNoiseType(this.type).SetThreshold(this.threshold.min, this.threshold.max).SetFrequency(this.frequency).SetInvert(this.invert).SetInterp(FastNoise.Interp.Hermite);
        return this.cache ? new CachedNoiseGenerator(noise) : noise;
    }

    private int getSeed(World world) {
        return this.seed.map(num -> {
            XoRoShiRo rand = new XoRoShiRo(world.func_72905_C());
            FastNoise simple = new FastNoise(((Random)rand).nextInt());
            return Float.floatToIntBits(simple.GetNoise(num.intValue()));
        }).orElseGet(world.field_73012_v::nextInt);
    }

    private static Optional<Integer> $default$seed() {
        return CommonMethods.empty();
    }

    private static FloatRange $default$threshold() {
        return Range.of(0.0f);
    }

    private static float $default$frequency() {
        return 1.0f;
    }

    private static boolean $default$invert() {
        return false;
    }

    private static boolean $default$cache() {
        return false;
    }

    private static boolean $default$dummy() {
        return false;
    }

    private static float $default$dummyOutput() {
        return 1.0f;
    }

    private static FastNoise.NoiseType $default$type() {
        return FastNoise.NoiseType.SimplexFractal;
    }

    NoiseRegionSettings(Optional<Integer> seed, FloatRange threshold, float frequency, boolean invert, boolean cache, boolean dummy, float dummyOutput, FastNoise.NoiseType type) {
        this.seed = seed;
        this.threshold = threshold;
        this.frequency = frequency;
        this.invert = invert;
        this.cache = cache;
        this.dummy = dummy;
        this.dummyOutput = dummyOutput;
        this.type = type;
    }

    public static NoiseRegionSettingsBuilder builder() {
        return new NoiseRegionSettingsBuilder();
    }

    public NoiseRegionSettingsBuilder toBuilder() {
        return new NoiseRegionSettingsBuilder().seed(this.seed).threshold(this.threshold).frequency(this.frequency).invert(this.invert).cache(this.cache).dummy(this.dummy).dummyOutput(this.dummyOutput).type(this.type);
    }

    public static final class Fields {
        public static final String seed = "seed";
        public static final String threshold = "threshold";
        public static final String frequency = "frequency";
        public static final String invert = "invert";
        public static final String cache = "cache";
        public static final String dummy = "dummy";
        public static final String dummyOutput = "dummyOutput";
        public static final String type = "type";
    }

    public static class NoiseRegionSettingsBuilder {
        private boolean seed$set;
        private Optional<Integer> seed$value;
        private boolean threshold$set;
        private FloatRange threshold$value;
        private boolean frequency$set;
        private float frequency$value;
        private boolean invert$set;
        private boolean invert$value;
        private boolean cache$set;
        private boolean cache$value;
        private boolean dummy$set;
        private boolean dummy$value;
        private boolean dummyOutput$set;
        private float dummyOutput$value;
        private boolean type$set;
        private FastNoise.NoiseType type$value;

        NoiseRegionSettingsBuilder() {
        }

        public NoiseRegionSettingsBuilder seed(Optional<Integer> seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder threshold(FloatRange threshold) {
            this.threshold$value = threshold;
            this.threshold$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder frequency(float frequency) {
            this.frequency$value = frequency;
            this.frequency$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder invert(boolean invert) {
            this.invert$value = invert;
            this.invert$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder cache(boolean cache) {
            this.cache$value = cache;
            this.cache$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder dummy(boolean dummy) {
            this.dummy$value = dummy;
            this.dummy$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder dummyOutput(float dummyOutput) {
            this.dummyOutput$value = dummyOutput;
            this.dummyOutput$set = true;
            return this;
        }

        public NoiseRegionSettingsBuilder type(FastNoise.NoiseType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public NoiseRegionSettings build() {
            Optional seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = NoiseRegionSettings.$default$seed();
            }
            FloatRange threshold$value = this.threshold$value;
            if (!this.threshold$set) {
                threshold$value = NoiseRegionSettings.$default$threshold();
            }
            float frequency$value = this.frequency$value;
            if (!this.frequency$set) {
                frequency$value = NoiseRegionSettings.$default$frequency();
            }
            boolean invert$value = this.invert$value;
            if (!this.invert$set) {
                invert$value = NoiseRegionSettings.$default$invert();
            }
            boolean cache$value = this.cache$value;
            if (!this.cache$set) {
                cache$value = NoiseRegionSettings.$default$cache();
            }
            boolean dummy$value = this.dummy$value;
            if (!this.dummy$set) {
                dummy$value = NoiseRegionSettings.$default$dummy();
            }
            float dummyOutput$value = this.dummyOutput$value;
            if (!this.dummyOutput$set) {
                dummyOutput$value = NoiseRegionSettings.$default$dummyOutput();
            }
            FastNoise.NoiseType type$value = this.type$value;
            if (!this.type$set) {
                type$value = NoiseRegionSettings.$default$type();
            }
            return new NoiseRegionSettings(seed$value, threshold$value, frequency$value, invert$value, cache$value, dummy$value, dummyOutput$value, type$value);
        }

        public String toString() {
            return "NoiseRegionSettings.NoiseRegionSettingsBuilder(seed$value=" + this.seed$value + ", threshold$value=" + this.threshold$value + ", frequency$value=" + this.frequency$value + ", invert$value=" + this.invert$value + ", cache$value=" + this.cache$value + ", dummy$value=" + this.dummy$value + ", dummyOutput$value=" + this.dummyOutput$value + ", type$value=" + (Object)((Object)this.type$value) + ")";
        }
    }
}

