/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.NoiseMapSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.model.ScalableFloat;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import org.hjson.JsonObject;

public class RavineSettings {
    private static final String FEATURE_NAME = "ravines";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(20, 66)).build();
    private static final DecoratorSettings DEFAULT_DECORATORS = DecoratorSettings.DEFAULTS;
    public final ConditionSettings conditions;
    public final DecoratorSettings decorators;
    public final Range originHeight;
    public final float noiseYFactor;
    public final ScalableFloat dYaw;
    public final ScalableFloat dPitch;
    public final ScalableFloat scale;
    public final ScalableFloat stretch;
    public final ScalableFloat yaw;
    public final ScalableFloat pitch;
    public final int distance;
    public final int chance;
    public final int resolution;
    public final double cutoffStrength;
    public final boolean useWallNoise;
    public final boolean checkWater;
    public final NoiseMapSettings walls;

    public static RavineSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        DecoratorSettings decorators = overrides.apply(DEFAULT_DECORATORS.toBuilder()).build();
        return RavineSettings.copyInto(json, RavineSettings.builder().conditions(conditions).decorators(decorators));
    }

    public static RavineSettings from(JsonObject json) {
        return RavineSettings.copyInto(json, RavineSettings.builder());
    }

    private static RavineSettings copyInto(JsonObject json, RavineSettingsBuilder builder) {
        RavineSettings original = builder.build();
        return new HjsonMapper(json).mapSelf(o -> builder.conditions(ConditionSettings.from(o, original.conditions))).mapSelf(o -> builder.decorators(DecoratorSettings.from(o, original.decorators))).mapRangeOrTry("originHeight", "height", builder::originHeight).mapFloat("noiseYFactor", builder::noiseYFactor).mapScalableFloat("dYaw", original.dYaw, builder::dYaw).mapScalableFloat("dPitch", original.dPitch, builder::dPitch).mapScalableFloat("scale", original.scale, builder::scale).mapScalableFloat("stretch", original.stretch, builder::stretch).mapScalableFloat("yaw", original.yaw, builder::yaw).mapScalableFloat("pitch", original.pitch, builder::pitch).mapInt("distance", builder::distance).mapFloat("chance", f -> builder.chance(CommonMethods.invert(f.floatValue()))).mapInt("resolution", builder::resolution).mapFloat("cutoffStrength", builder::cutoffStrength).mapObject("walls", o -> RavineSettings.copyWallNoise(o, original, builder)).mapBool("useWallNoise", builder::useWallNoise).mapBool("checkWater", builder::checkWater).release(builder::build);
    }

    private static void copyWallNoise(JsonObject json, RavineSettings original, RavineSettingsBuilder builder) {
        builder.useWallNoise(true).walls(NoiseMapSettings.from(json, original.walls));
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static DecoratorSettings $default$decorators() {
        return DEFAULT_DECORATORS;
    }

    private static Range $default$originHeight() {
        return Range.of(20, 66);
    }

    private static float $default$noiseYFactor() {
        return 0.7f;
    }

    private static ScalableFloat $default$dYaw() {
        return new ScalableFloat(0.0f, 0.0f, 0.5f, 4.0f, 1.0f);
    }

    private static ScalableFloat $default$dPitch() {
        return new ScalableFloat(0.0f, 0.0f, 0.8f, 2.0f, 1.0f);
    }

    private static ScalableFloat $default$scale() {
        return new ScalableFloat(0.0f, 2.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$stretch() {
        return new ScalableFloat(3.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$yaw() {
        return new ScalableFloat(0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    }

    private static ScalableFloat $default$pitch() {
        return new ScalableFloat(0.0f, 0.25f, 1.0f, 0.0f, 1.0f);
    }

    private static int $default$distance() {
        return 0;
    }

    private static int $default$chance() {
        return 5;
    }

    private static int $default$resolution() {
        return 4;
    }

    private static double $default$cutoffStrength() {
        return 5.0;
    }

    private static boolean $default$useWallNoise() {
        return false;
    }

    private static boolean $default$checkWater() {
        return true;
    }

    private static NoiseMapSettings $default$walls() {
        return NoiseMapSettings.builder().frequency(0.5f).range(Range.of(0, 4)).build();
    }

    RavineSettings(ConditionSettings conditions, DecoratorSettings decorators, Range originHeight, float noiseYFactor, ScalableFloat dYaw, ScalableFloat dPitch, ScalableFloat scale, ScalableFloat stretch, ScalableFloat yaw, ScalableFloat pitch, int distance, int chance, int resolution, double cutoffStrength, boolean useWallNoise, boolean checkWater, NoiseMapSettings walls) {
        this.conditions = conditions;
        this.decorators = decorators;
        this.originHeight = originHeight;
        this.noiseYFactor = noiseYFactor;
        this.dYaw = dYaw;
        this.dPitch = dPitch;
        this.scale = scale;
        this.stretch = stretch;
        this.yaw = yaw;
        this.pitch = pitch;
        this.distance = distance;
        this.chance = chance;
        this.resolution = resolution;
        this.cutoffStrength = cutoffStrength;
        this.useWallNoise = useWallNoise;
        this.checkWater = checkWater;
        this.walls = walls;
    }

    public static RavineSettingsBuilder builder() {
        return new RavineSettingsBuilder();
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String decorators = "decorators";
        public static final String originHeight = "originHeight";
        public static final String noiseYFactor = "noiseYFactor";
        public static final String dYaw = "dYaw";
        public static final String dPitch = "dPitch";
        public static final String scale = "scale";
        public static final String stretch = "stretch";
        public static final String yaw = "yaw";
        public static final String pitch = "pitch";
        public static final String distance = "distance";
        public static final String chance = "chance";
        public static final String resolution = "resolution";
        public static final String cutoffStrength = "cutoffStrength";
        public static final String useWallNoise = "useWallNoise";
        public static final String checkWater = "checkWater";
        public static final String walls = "walls";
    }

    public static class RavineSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private boolean decorators$set;
        private DecoratorSettings decorators$value;
        private boolean originHeight$set;
        private Range originHeight$value;
        private boolean noiseYFactor$set;
        private float noiseYFactor$value;
        private boolean dYaw$set;
        private ScalableFloat dYaw$value;
        private boolean dPitch$set;
        private ScalableFloat dPitch$value;
        private boolean scale$set;
        private ScalableFloat scale$value;
        private boolean stretch$set;
        private ScalableFloat stretch$value;
        private boolean yaw$set;
        private ScalableFloat yaw$value;
        private boolean pitch$set;
        private ScalableFloat pitch$value;
        private boolean distance$set;
        private int distance$value;
        private boolean chance$set;
        private int chance$value;
        private boolean resolution$set;
        private int resolution$value;
        private boolean cutoffStrength$set;
        private double cutoffStrength$value;
        private boolean useWallNoise$set;
        private boolean useWallNoise$value;
        private boolean checkWater$set;
        private boolean checkWater$value;
        private boolean walls$set;
        private NoiseMapSettings walls$value;

        RavineSettingsBuilder() {
        }

        public RavineSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public RavineSettingsBuilder decorators(DecoratorSettings decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public RavineSettingsBuilder originHeight(Range originHeight) {
            this.originHeight$value = originHeight;
            this.originHeight$set = true;
            return this;
        }

        public RavineSettingsBuilder noiseYFactor(float noiseYFactor) {
            this.noiseYFactor$value = noiseYFactor;
            this.noiseYFactor$set = true;
            return this;
        }

        public RavineSettingsBuilder dYaw(ScalableFloat dYaw) {
            this.dYaw$value = dYaw;
            this.dYaw$set = true;
            return this;
        }

        public RavineSettingsBuilder dPitch(ScalableFloat dPitch) {
            this.dPitch$value = dPitch;
            this.dPitch$set = true;
            return this;
        }

        public RavineSettingsBuilder scale(ScalableFloat scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return this;
        }

        public RavineSettingsBuilder stretch(ScalableFloat stretch) {
            this.stretch$value = stretch;
            this.stretch$set = true;
            return this;
        }

        public RavineSettingsBuilder yaw(ScalableFloat yaw) {
            this.yaw$value = yaw;
            this.yaw$set = true;
            return this;
        }

        public RavineSettingsBuilder pitch(ScalableFloat pitch) {
            this.pitch$value = pitch;
            this.pitch$set = true;
            return this;
        }

        public RavineSettingsBuilder distance(int distance) {
            this.distance$value = distance;
            this.distance$set = true;
            return this;
        }

        public RavineSettingsBuilder chance(int chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public RavineSettingsBuilder resolution(int resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return this;
        }

        public RavineSettingsBuilder cutoffStrength(double cutoffStrength) {
            this.cutoffStrength$value = cutoffStrength;
            this.cutoffStrength$set = true;
            return this;
        }

        public RavineSettingsBuilder useWallNoise(boolean useWallNoise) {
            this.useWallNoise$value = useWallNoise;
            this.useWallNoise$set = true;
            return this;
        }

        public RavineSettingsBuilder checkWater(boolean checkWater) {
            this.checkWater$value = checkWater;
            this.checkWater$set = true;
            return this;
        }

        public RavineSettingsBuilder walls(NoiseMapSettings walls) {
            this.walls$value = walls;
            this.walls$set = true;
            return this;
        }

        public RavineSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = RavineSettings.$default$conditions();
            }
            DecoratorSettings decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = RavineSettings.$default$decorators();
            }
            Range originHeight$value = this.originHeight$value;
            if (!this.originHeight$set) {
                originHeight$value = RavineSettings.$default$originHeight();
            }
            float noiseYFactor$value = this.noiseYFactor$value;
            if (!this.noiseYFactor$set) {
                noiseYFactor$value = RavineSettings.$default$noiseYFactor();
            }
            ScalableFloat dYaw$value = this.dYaw$value;
            if (!this.dYaw$set) {
                dYaw$value = RavineSettings.$default$dYaw();
            }
            ScalableFloat dPitch$value = this.dPitch$value;
            if (!this.dPitch$set) {
                dPitch$value = RavineSettings.$default$dPitch();
            }
            ScalableFloat scale$value = this.scale$value;
            if (!this.scale$set) {
                scale$value = RavineSettings.$default$scale();
            }
            ScalableFloat stretch$value = this.stretch$value;
            if (!this.stretch$set) {
                stretch$value = RavineSettings.$default$stretch();
            }
            ScalableFloat yaw$value = this.yaw$value;
            if (!this.yaw$set) {
                yaw$value = RavineSettings.$default$yaw();
            }
            ScalableFloat pitch$value = this.pitch$value;
            if (!this.pitch$set) {
                pitch$value = RavineSettings.$default$pitch();
            }
            int distance$value = this.distance$value;
            if (!this.distance$set) {
                distance$value = RavineSettings.$default$distance();
            }
            int chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = RavineSettings.$default$chance();
            }
            int resolution$value = this.resolution$value;
            if (!this.resolution$set) {
                resolution$value = RavineSettings.$default$resolution();
            }
            double cutoffStrength$value = this.cutoffStrength$value;
            if (!this.cutoffStrength$set) {
                cutoffStrength$value = RavineSettings.$default$cutoffStrength();
            }
            boolean useWallNoise$value = this.useWallNoise$value;
            if (!this.useWallNoise$set) {
                useWallNoise$value = RavineSettings.$default$useWallNoise();
            }
            boolean checkWater$value = this.checkWater$value;
            if (!this.checkWater$set) {
                checkWater$value = RavineSettings.$default$checkWater();
            }
            NoiseMapSettings walls$value = this.walls$value;
            if (!this.walls$set) {
                walls$value = RavineSettings.$default$walls();
            }
            return new RavineSettings(conditions$value, decorators$value, originHeight$value, noiseYFactor$value, dYaw$value, dPitch$value, scale$value, stretch$value, yaw$value, pitch$value, distance$value, chance$value, resolution$value, cutoffStrength$value, useWallNoise$value, checkWater$value, walls$value);
        }

        public String toString() {
            return "RavineSettings.RavineSettingsBuilder(conditions$value=" + this.conditions$value + ", decorators$value=" + this.decorators$value + ", originHeight$value=" + this.originHeight$value + ", noiseYFactor$value=" + this.noiseYFactor$value + ", dYaw$value=" + this.dYaw$value + ", dPitch$value=" + this.dPitch$value + ", scale$value=" + this.scale$value + ", stretch$value=" + this.stretch$value + ", yaw$value=" + this.yaw$value + ", pitch$value=" + this.pitch$value + ", distance$value=" + this.distance$value + ", chance$value=" + this.chance$value + ", resolution$value=" + this.resolution$value + ", cutoffStrength$value=" + this.cutoffStrength$value + ", useWallNoise$value=" + this.useWallNoise$value + ", checkWater$value=" + this.checkWater$value + ", walls$value=" + this.walls$value + ")";
        }
    }
}

