/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.DecoratorSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import org.hjson.JsonObject;

public class RoomSettings {
    private static final DecoratorSettings DEFAULT_DECORATORS = DecoratorSettings.DEFAULTS;
    public final DecoratorSettings decorators;
    public final float scale;
    public final float stretch;
    public final int chance;

    public static RoomSettings from(JsonObject json, OverrideSettings overrides) {
        DecoratorSettings decorators = overrides.apply(DEFAULT_DECORATORS.toBuilder()).build();
        return RoomSettings.copyInto(json, RoomSettings.builder().decorators(decorators));
    }

    public static RoomSettings from(JsonObject json) {
        return RoomSettings.copyInto(json, RoomSettings.builder());
    }

    private static RoomSettings copyInto(JsonObject json, RoomSettingsBuilder builder) {
        RoomSettings original = builder.build();
        return new HjsonMapper(json).mapSelf(o -> builder.decorators(DecoratorSettings.from(o, original.decorators))).mapFloat("scale", builder::scale).mapFloat("stretch", builder::stretch).mapFloat("chance", f -> builder.chance(CommonMethods.invert(f.floatValue()))).release(builder::build);
    }

    private static DecoratorSettings $default$decorators() {
        return DEFAULT_DECORATORS;
    }

    private static float $default$scale() {
        return 6.0f;
    }

    private static float $default$stretch() {
        return 0.5f;
    }

    private static int $default$chance() {
        return 10;
    }

    RoomSettings(DecoratorSettings decorators, float scale, float stretch, int chance) {
        this.decorators = decorators;
        this.scale = scale;
        this.stretch = stretch;
        this.chance = chance;
    }

    public static RoomSettingsBuilder builder() {
        return new RoomSettingsBuilder();
    }

    public static final class Fields {
        public static final String decorators = "decorators";
        public static final String scale = "scale";
        public static final String stretch = "stretch";
        public static final String chance = "chance";
    }

    public static class RoomSettingsBuilder {
        private boolean decorators$set;
        private DecoratorSettings decorators$value;
        private boolean scale$set;
        private float scale$value;
        private boolean stretch$set;
        private float stretch$value;
        private boolean chance$set;
        private int chance$value;

        RoomSettingsBuilder() {
        }

        public RoomSettingsBuilder decorators(DecoratorSettings decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public RoomSettingsBuilder scale(float scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return this;
        }

        public RoomSettingsBuilder stretch(float stretch) {
            this.stretch$value = stretch;
            this.stretch$set = true;
            return this;
        }

        public RoomSettingsBuilder chance(int chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public RoomSettings build() {
            DecoratorSettings decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = RoomSettings.$default$decorators();
            }
            float scale$value = this.scale$value;
            if (!this.scale$set) {
                scale$value = RoomSettings.$default$scale();
            }
            float stretch$value = this.stretch$value;
            if (!this.stretch$set) {
                stretch$value = RoomSettings.$default$stretch();
            }
            int chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = RoomSettings.$default$chance();
            }
            return new RoomSettings(decorators$value, scale$value, stretch$value, chance$value);
        }

        public String toString() {
            return "RoomSettings.RoomSettingsBuilder(decorators$value=" + this.decorators$value + ", scale$value=" + this.scale$value + ", stretch$value=" + this.stretch$value + ", chance$value=" + this.chance$value + ")";
        }
    }
}

