/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.hjson.JsonObject;

public class ShellSettings {
    public final double radius;
    public final int sphereResolution;
    public final Optional<Float> noiseThreshold;
    public final List<Decorator> decorators;

    public static ShellSettings from(JsonObject json) {
        ShellSettingsBuilder builder = ShellSettings.builder();
        return new HjsonMapper(json).mapFloat("radius", builder::radius).mapInt("sphereResolution", builder::sphereResolution).mapFloat("noiseThreshold", f -> builder.noiseThreshold(CommonMethods.full(f))).mapArray("decorators", x$0 -> Decorator.from(x$0), builder::decorators).release(builder::build);
    }

    private static double $default$radius() {
        return 0.0;
    }

    private static int $default$sphereResolution() {
        return 2;
    }

    private static Optional<Float> $default$noiseThreshold() {
        return CommonMethods.empty();
    }

    private static List<Decorator> $default$decorators() {
        return Collections.emptyList();
    }

    ShellSettings(double radius, int sphereResolution, Optional<Float> noiseThreshold, List<Decorator> decorators) {
        this.radius = radius;
        this.sphereResolution = sphereResolution;
        this.noiseThreshold = noiseThreshold;
        this.decorators = decorators;
    }

    public static ShellSettingsBuilder builder() {
        return new ShellSettingsBuilder();
    }

    public static final class Fields {
        public static final String radius = "radius";
        public static final String sphereResolution = "sphereResolution";
        public static final String noiseThreshold = "noiseThreshold";
        public static final String decorators = "decorators";
    }

    public static class ShellSettingsBuilder {
        private boolean radius$set;
        private double radius$value;
        private boolean sphereResolution$set;
        private int sphereResolution$value;
        private boolean noiseThreshold$set;
        private Optional<Float> noiseThreshold$value;
        private boolean decorators$set;
        private List<Decorator> decorators$value;

        ShellSettingsBuilder() {
        }

        public ShellSettingsBuilder radius(double radius) {
            this.radius$value = radius;
            this.radius$set = true;
            return this;
        }

        public ShellSettingsBuilder sphereResolution(int sphereResolution) {
            this.sphereResolution$value = sphereResolution;
            this.sphereResolution$set = true;
            return this;
        }

        public ShellSettingsBuilder noiseThreshold(Optional<Float> noiseThreshold) {
            this.noiseThreshold$value = noiseThreshold;
            this.noiseThreshold$set = true;
            return this;
        }

        public ShellSettingsBuilder decorators(List<Decorator> decorators) {
            this.decorators$value = decorators;
            this.decorators$set = true;
            return this;
        }

        public ShellSettings build() {
            double radius$value = this.radius$value;
            if (!this.radius$set) {
                radius$value = ShellSettings.$default$radius();
            }
            int sphereResolution$value = this.sphereResolution$value;
            if (!this.sphereResolution$set) {
                sphereResolution$value = ShellSettings.$default$sphereResolution();
            }
            Optional noiseThreshold$value = this.noiseThreshold$value;
            if (!this.noiseThreshold$set) {
                noiseThreshold$value = ShellSettings.$default$noiseThreshold();
            }
            List decorators$value = this.decorators$value;
            if (!this.decorators$set) {
                decorators$value = ShellSettings.$default$decorators();
            }
            return new ShellSettings(radius$value, sphereResolution$value, noiseThreshold$value, decorators$value);
        }

        public String toString() {
            return "ShellSettings.ShellSettingsBuilder(radius$value=" + this.radius$value + ", sphereResolution$value=" + this.sphereResolution$value + ", noiseThreshold$value=" + this.noiseThreshold$value + ", decorators$value=" + this.decorators$value + ")";
        }
    }

    public static class Decorator {
        public final List<IBlockState> states;
        public final List<IBlockState> matchers;
        public final Range height;
        public final double integrity;
        public final Optional<NoiseSettings> noise;
        public static final NoiseSettings DEFAULT_NOISE = NoiseSettings.builder().frequency(0.02f).threshold(Range.of(-0.8f)).stretch(1.0f).octaves(1).build();

        private static Decorator from(JsonObject json) {
            DecoratorBuilder builder = Decorator.builder();
            return new HjsonMapper(json).mapRequiredStateList("states", "decorators", builder::states).mapStateList("matchers", builder::matchers).mapRange("height", builder::height).mapFloat("integrity", builder::integrity).mapObject("noise", o -> Decorator.copyNoise(o, builder)).release(builder::build);
        }

        private static void copyNoise(JsonObject json, DecoratorBuilder builder) {
            builder.noise(CommonMethods.full(NoiseSettings.from(json, DEFAULT_NOISE)));
        }

        private static List<IBlockState> $default$matchers() {
            return Collections.singletonList(Blocks.field_150348_b.func_176223_P());
        }

        private static Range $default$height() {
            return Range.of(0, 63);
        }

        private static double $default$integrity() {
            return 1.0;
        }

        private static Optional<NoiseSettings> $default$noise() {
            return CommonMethods.empty();
        }

        public static DecoratorBuilder builder() {
            return new DecoratorBuilder();
        }

        public Decorator(List<IBlockState> states, List<IBlockState> matchers, Range height, double integrity, Optional<NoiseSettings> noise) {
            this.states = states;
            this.matchers = matchers;
            this.height = height;
            this.integrity = integrity;
            this.noise = noise;
        }

        public static final class Fields {
            public static final String states = "states";
            public static final String matchers = "matchers";
            public static final String height = "height";
            public static final String integrity = "integrity";
            public static final String noise = "noise";
        }

        public static class DecoratorBuilder {
            private List<IBlockState> states;
            private boolean matchers$set;
            private List<IBlockState> matchers$value;
            private boolean height$set;
            private Range height$value;
            private boolean integrity$set;
            private double integrity$value;
            private boolean noise$set;
            private Optional<NoiseSettings> noise$value;

            DecoratorBuilder() {
            }

            public DecoratorBuilder states(List<IBlockState> states) {
                this.states = states;
                return this;
            }

            public DecoratorBuilder matchers(List<IBlockState> matchers) {
                this.matchers$value = matchers;
                this.matchers$set = true;
                return this;
            }

            public DecoratorBuilder height(Range height) {
                this.height$value = height;
                this.height$set = true;
                return this;
            }

            public DecoratorBuilder integrity(double integrity) {
                this.integrity$value = integrity;
                this.integrity$set = true;
                return this;
            }

            public DecoratorBuilder noise(Optional<NoiseSettings> noise) {
                this.noise$value = noise;
                this.noise$set = true;
                return this;
            }

            public Decorator build() {
                List matchers$value = this.matchers$value;
                if (!this.matchers$set) {
                    matchers$value = Decorator.$default$matchers();
                }
                Range height$value = this.height$value;
                if (!this.height$set) {
                    height$value = Decorator.$default$height();
                }
                double integrity$value = this.integrity$value;
                if (!this.integrity$set) {
                    integrity$value = Decorator.$default$integrity();
                }
                Optional noise$value = this.noise$value;
                if (!this.noise$set) {
                    noise$value = Decorator.$default$noise();
                }
                return new Decorator(this.states, matchers$value, height$value, integrity$value, noise$value);
            }

            public String toString() {
                return "ShellSettings.Decorator.DecoratorBuilder(states=" + this.states + ", matchers$value=" + this.matchers$value + ", height$value=" + this.height$value + ", integrity$value=" + this.integrity$value + ", noise$value=" + this.noise$value + ")";
            }
        }
    }
}

