/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.data.NoiseRegionSettings;
import com.personthecat.cavegenerator.data.OverrideSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import org.hjson.JsonObject;

@ParametersAreNonnullByDefault
public class StalactiteSettings {
    private static final String FEATURE_NAME = "stalactites";
    private static final ConditionSettings DEFAULT_CONDITIONS = ConditionSettings.builder().height(Range.of(11, 55)).build();
    public final ConditionSettings conditions;
    public final IBlockState state;
    public final Type type;
    public final Size size;
    public final double chance;
    public final Range length;
    public final int space;
    public final boolean symmetrical;
    public final List<IBlockState> matchers;
    public static final NoiseRegionSettings DEFAULT_NOISE = NoiseRegionSettings.builder().frequency(0.025f).threshold(Range.of(-0.425f)).build();

    public static StalactiteSettings from(JsonObject json, OverrideSettings overrides) {
        ConditionSettings conditions = overrides.apply(DEFAULT_CONDITIONS.toBuilder()).build();
        return StalactiteSettings.copyInto(json, StalactiteSettings.builder().conditions(conditions));
    }

    public static StalactiteSettings from(JsonObject json) {
        return StalactiteSettings.copyInto(json, StalactiteSettings.builder().conditions(DEFAULT_CONDITIONS));
    }

    private static StalactiteSettings copyInto(JsonObject json, StalactiteSettingsBuilder builder) {
        return new HjsonMapper(json).mapRequiredState("state", FEATURE_NAME, builder::state).mapSelf(o -> builder.conditions(ConditionSettings.from(o, builder.conditions$value))).mapEnum("type", Type.class, builder::type).mapEnum("size", Size.class, builder::size).mapFloat("chance", builder::chance).mapRange("length", builder::length).mapInt("space", builder::space).mapBool("symmetrical", builder::symmetrical).mapStateList("matchers", builder::matchers).release(builder::build);
    }

    private static ConditionSettings $default$conditions() {
        return DEFAULT_CONDITIONS;
    }

    private static Type $default$type() {
        return Type.STALACTITE;
    }

    private static Size $default$size() {
        return Size.MEDIUM;
    }

    private static double $default$chance() {
        return 0.167f;
    }

    private static Range $default$length() {
        return Range.of(3, 5);
    }

    private static int $default$space() {
        return 3;
    }

    private static boolean $default$symmetrical() {
        return true;
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.emptyList();
    }

    StalactiteSettings(ConditionSettings conditions, IBlockState state, Type type, Size size, double chance, Range length, int space, boolean symmetrical, List<IBlockState> matchers) {
        this.conditions = conditions;
        this.state = state;
        this.type = type;
        this.size = size;
        this.chance = chance;
        this.length = length;
        this.space = space;
        this.symmetrical = symmetrical;
        this.matchers = matchers;
    }

    public static StalactiteSettingsBuilder builder() {
        return new StalactiteSettingsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StalactiteSettings)) {
            return false;
        }
        StalactiteSettings other = (StalactiteSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.chance, other.chance) != 0) {
            return false;
        }
        if (this.space != other.space) {
            return false;
        }
        if (this.symmetrical != other.symmetrical) {
            return false;
        }
        ConditionSettings this$conditions = this.conditions;
        ConditionSettings other$conditions = other.conditions;
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        IBlockState this$state = this.state;
        IBlockState other$state = other.state;
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Type this$type = this.type;
        Type other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Size this$size = this.size;
        Size other$size = other.size;
        if (this$size == null ? other$size != null : !((Object)((Object)this$size)).equals((Object)other$size)) {
            return false;
        }
        Range this$length = this.length;
        Range other$length = other.length;
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        List<IBlockState> this$matchers = this.matchers;
        List<IBlockState> other$matchers = other.matchers;
        return !(this$matchers == null ? other$matchers != null : !((Object)this$matchers).equals(other$matchers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StalactiteSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $chance = Double.doubleToLongBits(this.chance);
        result = result * 59 + (int)($chance >>> 32 ^ $chance);
        result = result * 59 + this.space;
        result = result * 59 + (this.symmetrical ? 79 : 97);
        ConditionSettings $conditions = this.conditions;
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        IBlockState $state = this.state;
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Size $size = this.size;
        result = result * 59 + ($size == null ? 43 : ((Object)((Object)$size)).hashCode());
        Range $length = this.length;
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        List<IBlockState> $matchers = this.matchers;
        result = result * 59 + ($matchers == null ? 43 : ((Object)$matchers).hashCode());
        return result;
    }

    public static final class Fields {
        public static final String conditions = "conditions";
        public static final String state = "state";
        public static final String type = "type";
        public static final String size = "size";
        public static final String chance = "chance";
        public static final String length = "length";
        public static final String space = "space";
        public static final String symmetrical = "symmetrical";
        public static final String matchers = "matchers";
    }

    public static class StalactiteSettingsBuilder {
        private boolean conditions$set;
        private ConditionSettings conditions$value;
        private IBlockState state;
        private boolean type$set;
        private Type type$value;
        private boolean size$set;
        private Size size$value;
        private boolean chance$set;
        private double chance$value;
        private boolean length$set;
        private Range length$value;
        private boolean space$set;
        private int space$value;
        private boolean symmetrical$set;
        private boolean symmetrical$value;
        private boolean matchers$set;
        private List<IBlockState> matchers$value;

        StalactiteSettingsBuilder() {
        }

        public StalactiteSettingsBuilder conditions(ConditionSettings conditions) {
            this.conditions$value = conditions;
            this.conditions$set = true;
            return this;
        }

        public StalactiteSettingsBuilder state(IBlockState state) {
            this.state = state;
            return this;
        }

        public StalactiteSettingsBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public StalactiteSettingsBuilder size(Size size) {
            this.size$value = size;
            this.size$set = true;
            return this;
        }

        public StalactiteSettingsBuilder chance(double chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public StalactiteSettingsBuilder length(Range length) {
            this.length$value = length;
            this.length$set = true;
            return this;
        }

        public StalactiteSettingsBuilder space(int space) {
            this.space$value = space;
            this.space$set = true;
            return this;
        }

        public StalactiteSettingsBuilder symmetrical(boolean symmetrical) {
            this.symmetrical$value = symmetrical;
            this.symmetrical$set = true;
            return this;
        }

        public StalactiteSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public StalactiteSettings build() {
            ConditionSettings conditions$value = this.conditions$value;
            if (!this.conditions$set) {
                conditions$value = StalactiteSettings.$default$conditions();
            }
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = StalactiteSettings.$default$type();
            }
            Size size$value = this.size$value;
            if (!this.size$set) {
                size$value = StalactiteSettings.$default$size();
            }
            double chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = StalactiteSettings.$default$chance();
            }
            Range length$value = this.length$value;
            if (!this.length$set) {
                length$value = StalactiteSettings.$default$length();
            }
            int space$value = this.space$value;
            if (!this.space$set) {
                space$value = StalactiteSettings.$default$space();
            }
            boolean symmetrical$value = this.symmetrical$value;
            if (!this.symmetrical$set) {
                symmetrical$value = StalactiteSettings.$default$symmetrical();
            }
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = StalactiteSettings.$default$matchers();
            }
            return new StalactiteSettings(conditions$value, this.state, type$value, size$value, chance$value, length$value, space$value, symmetrical$value, matchers$value);
        }

        public String toString() {
            return "StalactiteSettings.StalactiteSettingsBuilder(conditions$value=" + this.conditions$value + ", state=" + this.state + ", type$value=" + (Object)((Object)this.type$value) + ", size$value=" + (Object)((Object)this.size$value) + ", chance$value=" + this.chance$value + ", length$value=" + this.length$value + ", space$value=" + this.space$value + ", symmetrical$value=" + this.symmetrical$value + ", matchers$value=" + this.matchers$value + ")";
        }
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE,
        GIANT;

    }

    public static enum Type {
        STALAGMITE,
        STALACTITE,
        SPELEOTHEM;

    }
}

