/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.data;

import com.personthecat.cavegenerator.data.NoiseSettings;
import com.personthecat.cavegenerator.model.Direction;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import org.hjson.JsonObject;

public class WallDecoratorSettings {
    private static final String FEATURE_NAME = "wallDecorators";
    public final List<IBlockState> states;
    public final double integrity;
    public final Range height;
    public final List<Direction> directions;
    public final List<IBlockState> matchers;
    public final Placement placement;
    public final Optional<NoiseSettings> noise;
    public static final NoiseSettings DEFAULT_NOISE = NoiseSettings.builder().frequency(0.02f).threshold(Range.of(0.0f)).stretch(1.0f).build();

    public static WallDecoratorSettings from(JsonObject json) {
        WallDecoratorSettingsBuilder builder = WallDecoratorSettings.builder();
        return new HjsonMapper(json).mapRequiredStateList("states", FEATURE_NAME, builder::states).mapObject("noise", o -> WallDecoratorSettings.copyNoise(o, builder)).mapFloat("integrity", builder::integrity).mapRange("height", builder::height).mapDirectionList("directions", builder::directions).mapStateList("matchers", builder::matchers).mapPlacementPreference("placement", builder::placement).release(builder::build);
    }

    private static void copyNoise(JsonObject json, WallDecoratorSettingsBuilder builder) {
        builder.noise(CommonMethods.full(NoiseSettings.from(json, DEFAULT_NOISE)));
    }

    private static double $default$integrity() {
        return 1.0;
    }

    private static Range $default$height() {
        return Range.of(10, 50);
    }

    private static List<Direction> $default$directions() {
        return Collections.singletonList(Direction.ALL);
    }

    private static List<IBlockState> $default$matchers() {
        return Collections.singletonList(Blocks.field_150348_b.func_176223_P());
    }

    private static Placement $default$placement() {
        return Placement.EMBED;
    }

    private static Optional<NoiseSettings> $default$noise() {
        return CommonMethods.empty();
    }

    WallDecoratorSettings(List<IBlockState> states, double integrity, Range height, List<Direction> directions, List<IBlockState> matchers, Placement placement, Optional<NoiseSettings> noise) {
        this.states = states;
        this.integrity = integrity;
        this.height = height;
        this.directions = directions;
        this.matchers = matchers;
        this.placement = placement;
        this.noise = noise;
    }

    public static WallDecoratorSettingsBuilder builder() {
        return new WallDecoratorSettingsBuilder();
    }

    public static final class Fields {
        public static final String states = "states";
        public static final String integrity = "integrity";
        public static final String height = "height";
        public static final String directions = "directions";
        public static final String matchers = "matchers";
        public static final String placement = "placement";
        public static final String noise = "noise";
    }

    public static class WallDecoratorSettingsBuilder {
        private List<IBlockState> states;
        private boolean integrity$set;
        private double integrity$value;
        private boolean height$set;
        private Range height$value;
        private boolean directions$set;
        private List<Direction> directions$value;
        private boolean matchers$set;
        private List<IBlockState> matchers$value;
        private boolean placement$set;
        private Placement placement$value;
        private boolean noise$set;
        private Optional<NoiseSettings> noise$value;

        WallDecoratorSettingsBuilder() {
        }

        public WallDecoratorSettingsBuilder states(List<IBlockState> states) {
            this.states = states;
            return this;
        }

        public WallDecoratorSettingsBuilder integrity(double integrity) {
            this.integrity$value = integrity;
            this.integrity$set = true;
            return this;
        }

        public WallDecoratorSettingsBuilder height(Range height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public WallDecoratorSettingsBuilder directions(List<Direction> directions) {
            this.directions$value = directions;
            this.directions$set = true;
            return this;
        }

        public WallDecoratorSettingsBuilder matchers(List<IBlockState> matchers) {
            this.matchers$value = matchers;
            this.matchers$set = true;
            return this;
        }

        public WallDecoratorSettingsBuilder placement(Placement placement) {
            this.placement$value = placement;
            this.placement$set = true;
            return this;
        }

        public WallDecoratorSettingsBuilder noise(Optional<NoiseSettings> noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public WallDecoratorSettings build() {
            double integrity$value = this.integrity$value;
            if (!this.integrity$set) {
                integrity$value = WallDecoratorSettings.$default$integrity();
            }
            Range height$value = this.height$value;
            if (!this.height$set) {
                height$value = WallDecoratorSettings.$default$height();
            }
            List directions$value = this.directions$value;
            if (!this.directions$set) {
                directions$value = WallDecoratorSettings.$default$directions();
            }
            List matchers$value = this.matchers$value;
            if (!this.matchers$set) {
                matchers$value = WallDecoratorSettings.$default$matchers();
            }
            Placement placement$value = this.placement$value;
            if (!this.placement$set) {
                placement$value = WallDecoratorSettings.$default$placement();
            }
            Optional noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = WallDecoratorSettings.$default$noise();
            }
            return new WallDecoratorSettings(this.states, integrity$value, height$value, directions$value, matchers$value, placement$value, noise$value);
        }

        public String toString() {
            return "WallDecoratorSettings.WallDecoratorSettingsBuilder(states=" + this.states + ", integrity$value=" + this.integrity$value + ", height$value=" + this.height$value + ", directions$value=" + this.directions$value + ", matchers$value=" + this.matchers$value + ", placement$value=" + (Object)((Object)this.placement$value) + ", noise$value=" + this.noise$value + ")";
        }
    }

    public static enum Placement {
        OVERLAY,
        EMBED;


        public static Placement from(String s) {
            Optional<Placement> pref = CommonMethods.find(Placement.values(), v -> v.toString().equalsIgnoreCase(s));
            return pref.orElseThrow(() -> {
                String o = Arrays.toString((Object[])Placement.values());
                return CommonMethods.runExF("Error: Preference \"{}\" does not exist. The following are valid options:\n\n{}", s, o);
            });
        }
    }
}

