/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.io;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.io.SafeFileIO;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.world.feature.StructureSpawner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class JarFiles {
    private static final Logger log = LogManager.getLogger(JarFiles.class);
    private static final String ASSETS_PATH = "assets/cavegenerator";
    private static final String CAT_FOLDER_NAME = "cat";
    private static final String TUTORIAL_NAME = "TUTORIAL.cave";
    private static final String REFERENCE_NAME = "REFERENCE.cave";
    private static final File CAT_DIR = new File(CaveInit.IMPORT_DIR, "cat");
    private static final String[] EXAMPLES = new String[]{"flooded_vanilla", "large_caves", "spirals", "tunnels", "caverns", "stone_layers", "stalactites", "ravines", "stone_clusters", "large_stalactites", "vanilla", "underground_forest", "euclids_tunnels", "lower_caves", "cluster_caverns"};
    private static final String[] CAT_IMPORTS = new String[]{"common", "crack", "desert", "generic", "jungle", "lava_aquifers", "maze", "mountain", "mushroom", "snow", "water"};
    private static final String[] DEFAULTS = new String[]{"cat", "cat_lite", "geodes", "ore_veins"};
    private static final String[] STRUCTURES = new String[]{"brown_mushroom_lg", "brown_mushroom_sm", "bush1_sm", "bush2_sm", "bush3_sm", "bush4_med", "hanging_spawner", "hanging_spawner_skeleton", "hanging_spawner_zombie", "red_mushroom"};
    private static final String[] IMPORTS = new String[]{"blocks", "conditions", "defaults", "types"};

    public static void copyFiles() {
        SafeFileIO.ensureDirExists(CaveInit.EXAMPLE_DIR).expect("Error: Unable to create the example preset directory");
        SafeFileIO.ensureDirExists(CaveInit.IMPORT_DIR).expect("Error: Unable to create the import directory");
        JarFiles.copyExamples();
        JarFiles.copyDefaults();
        JarFiles.copyImports();
        JarFiles.copyCatImports();
        JarFiles.copyStructures();
        JarFiles.copyTutorial();
    }

    public static JsonObject getDefaults() {
        JsonObject json;
        String fromLocation = "assets/cavegenerator/imports/defaults.cave";
        InputStream is = SafeFileIO.getRequiredResource("assets/cavegenerator/imports/defaults.cave");
        InputStreamReader rx = new InputStreamReader(is);
        try {
            json = JsonValue.readHjson(rx).asObject();
        }
        catch (IOException e) {
            throw CommonMethods.runEx("Reading internal defaults.cave");
        }
        finally {
            try {
                is.close();
                ((Reader)rx).close();
            }
            catch (IOException e) {
                log.warn("Unable to dispose resources.");
            }
        }
        return json;
    }

    private static void copyExamples() {
        for (String fileName : EXAMPLES) {
            String fromLocation = "assets/cavegenerator/presets/" + fileName + ".cave";
            String toLocation = CaveInit.EXAMPLE_DIR + "/" + fileName + ".cave";
            if (SafeFileIO.fileExists(new File(toLocation), "Security error on " + toLocation)) continue;
            JarFiles.copyFile(fromLocation, toLocation);
        }
    }

    private static void copyDefaults() {
        if (!SafeFileIO.fileExists(CaveInit.PRESET_DIR, "Error: Unable to read from preset directory")) {
            SafeFileIO.mkdirs(CaveInit.PRESET_DIR).expect("Error: Unable to create preset directory");
            for (String s : DEFAULTS) {
                JarFiles.copyDefault(s + ".cave");
            }
        }
    }

    private static void copyDefault(String name) {
        String fromLocation = "assets/cavegenerator/presets/" + name;
        String toLocation = CaveInit.PRESET_DIR + "/" + name;
        JarFiles.copyFile(fromLocation, toLocation);
    }

    private static void copyImports() {
        SafeFileIO.ensureDirExists(CaveInit.IMPORT_DIR).expect("Error creating import directory");
        for (String i : IMPORTS) {
            String fromLocation = "assets/cavegenerator/imports/" + i + ".cave";
            String toLocation = CaveInit.IMPORT_DIR + "/" + i + ".cave";
            if (SafeFileIO.fileExists(new File(toLocation), "Unable to check " + toLocation)) continue;
            JarFiles.copyFile(fromLocation, toLocation);
        }
    }

    private static void copyCatImports() {
        SafeFileIO.ensureDirExists(new File(CaveInit.IMPORT_DIR, CAT_FOLDER_NAME)).expect("Error creating cat directory");
        for (String i : CAT_IMPORTS) {
            String fromLocation = "assets/cavegenerator/imports/cat/" + i + ".cave";
            String toLocation = CAT_DIR + "/" + i + ".cave";
            if (SafeFileIO.fileExists(new File(toLocation), "Unable to check + " + toLocation)) continue;
            JarFiles.copyFile(fromLocation, toLocation);
        }
    }

    private static void copyStructures() {
        if (!SafeFileIO.fileExists(StructureSpawner.DIR, "Error: Unable to read from structure directory")) {
            SafeFileIO.mkdirs(StructureSpawner.DIR).expect("Error: Unable to create structure directory.");
            for (String structure : STRUCTURES) {
                String fromLocation = "assets/cavegenerator/structures/" + structure + ".nbt";
                String toLocation = StructureSpawner.DIR + "/" + structure + ".nbt";
                JarFiles.copyFile(fromLocation, toLocation);
            }
        }
    }

    private static void copyTutorial() {
        String fromLocation = "assets/cavegenerator/TUTORIAL.cave";
        String toLocation = CaveInit.CG_DIR + "/" + TUTORIAL_NAME;
        JarFiles.copyFile("assets/cavegenerator/TUTORIAL.cave", toLocation);
        String fromLocation2 = "assets/cavegenerator/REFERENCE.cave";
        String toLocation2 = CaveInit.CG_DIR + "/" + REFERENCE_NAME;
        JarFiles.copyFile("assets/cavegenerator/REFERENCE.cave", toLocation2);
    }

    private static void copyFile(String fromLocation, String toLocation) {
        try {
            InputStream toCopy = SafeFileIO.getRequiredResource(fromLocation);
            FileOutputStream output = new FileOutputStream(toLocation);
            SafeFileIO.copyStream(toCopy, output, 1024).expect("Error copying file data. Perhaps the jar is corrupt.");
            output.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open FileOutputStream", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing FileOutputStream", e);
        }
    }
}

