/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.io;

import com.personthecat.cavegenerator.CaveInit;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.Result;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;

public class SafeFileIO {
    @CheckReturnValue
    public static Result<SecurityException> ensureDirExists(File file) {
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (SecurityException e) {
            return Result.of(e);
        }
        return Result.ok();
    }

    @CheckReturnValue
    public static Result<SecurityException> mkdirs(File file) {
        try {
            file.mkdirs();
        }
        catch (SecurityException e) {
            return Result.of(e);
        }
        return Result.ok();
    }

    public static boolean fileExists(File file, String error) {
        boolean ret;
        try {
            ret = file.exists();
        }
        catch (SecurityException e) {
            throw CommonMethods.runEx(error);
        }
        return ret;
    }

    @CheckReturnValue
    public static Result<IOException> copy(File file, File toDir) {
        try {
            Files.copy(file.toPath(), new File(toDir, file.getName()).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            return Result.of(e);
        }
        return Result.ok();
    }

    public static void backup(File file) {
        SafeFileIO.backup(file, false);
    }

    public static void backup(File file, boolean move) {
        if (!SafeFileIO.fileExists(CaveInit.BACKUP_DIR, "Unable to handle backup directory.")) {
            SafeFileIO.mkdirs(CaveInit.BACKUP_DIR).throwIfPresent();
        }
        File backup = new File(CaveInit.BACKUP_DIR, file.getName());
        BackupHelper helper = new BackupHelper(file);
        helper.cycle();
        if (SafeFileIO.fileExists(backup, "Unable to handle existing backup file.")) {
            throw CommonMethods.runExF("Could not rename backups: {}", file.getName());
        }
        if (move) {
            if (!file.renameTo(backup)) {
                throw CommonMethods.runExF("Error moving {} to backups", file.getName());
            }
        } else {
            SafeFileIO.copy(file, CaveInit.BACKUP_DIR).throwIfPresent();
        }
    }

    public static void rename(File file, String name) {
        File path = new File(file.getParentFile(), name);
        if (!file.renameTo(path)) {
            throw CommonMethods.runExF("Cannot rename: {}", path);
        }
    }

    @CheckReturnValue
    public static Optional<File[]> listFiles(File dir) {
        return Optional.ofNullable(dir.listFiles());
    }

    @CheckReturnValue
    public static Optional<File[]> listFiles(File dir, FileFilter filter) {
        return Optional.ofNullable(dir.listFiles(filter));
    }

    @CheckReturnValue
    public static Optional<File> getFileRecursive(File dir, FileFilter filter) {
        File[] inDir = dir.listFiles();
        if (inDir != null) {
            for (File f : inDir) {
                if (f.isDirectory()) {
                    Optional<File> found = SafeFileIO.getFileRecursive(f, filter);
                    if (!found.isPresent()) continue;
                    return found;
                }
                if (!filter.accept(f)) continue;
                return CommonMethods.full(f);
            }
        }
        return CommonMethods.empty();
    }

    public static Optional<List<String>> safeContents(File file) {
        try {
            return CommonMethods.full(Files.readAllLines(file.toPath()));
        }
        catch (IOException ignored) {
            return CommonMethods.empty();
        }
    }

    @CheckReturnValue
    public static Result<IOException> copyStream(InputStream input, OutputStream output, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        try {
            int length;
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            return Result.of(e);
        }
        return Result.ok();
    }

    @CheckReturnValue
    public static Optional<InputStream> getResource(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return CommonMethods.nullable(SafeFileIO.class.getResourceAsStream(path));
    }

    public static InputStream getRequiredResource(String path) {
        return SafeFileIO.getResource(path).orElseThrow(() -> CommonMethods.runExF("The required file \"{}\" was not present in the jar.", path));
    }

    private static class BackupHelper {
        final String base;
        final String ext;
        final Pattern pattern;

        BackupHelper(File file) {
            String name = file.getName();
            int dotIndex = name.indexOf(".");
            if (dotIndex > 0) {
                this.base = name.substring(0, dotIndex);
                this.ext = name.substring(dotIndex);
            } else {
                this.base = name;
                this.ext = "";
            }
            this.pattern = Pattern.compile(this.base + "(\\s\\((\\d+)\\))?" + this.ext);
        }

        void cycle() {
            List<File> matching = Arrays.asList(CaveInit.BACKUP_DIR.listFiles(this::matches));
            matching.sort(this::compare);
            for (File f : matching) {
                int number = this.getNumber(f) + 1;
                File newFile = new File(f.getParentFile(), this.base + " (" + number + ")" + this.ext);
                if (f.renameTo(newFile)) continue;
                throw CommonMethods.runExF("Could not increment backup: {}", f.getName());
            }
        }

        boolean matches(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }

        int getNumber(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            if (!matcher.find()) {
                throw CommonMethods.runExF("Backup deleted externally: {}", file.getName());
            }
            String g2 = matcher.group(2);
            return g2 == null ? 0 : Integer.parseInt(g2);
        }

        private int compare(File f1, File f2) {
            return Integer.compare(this.getNumber(f2), this.getNumber(f1));
        }
    }
}

