/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonMapper;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class BlockCheck {
    private static final String FEATURE_NAME = "blockChecks";
    public final List<IBlockState> matchers;
    public final List<BlockPos> positions;

    public static BlockCheck fromValue(JsonValue json) {
        if (json.isObject()) {
            return BlockCheck.from(json.asObject());
        }
        if (json.isArray()) {
            return BlockCheck.from(json.asArray());
        }
        throw CommonMethods.runExF("Expected object or array: {}", json);
    }

    public static BlockCheck from(JsonObject json) {
        BlockCheckBuilder builder = BlockCheck.builder();
        return new HjsonMapper(json).mapRequiredStateList("matchers", FEATURE_NAME, builder::matchers).mapRequiredBlockPosList("positions", FEATURE_NAME, builder::positions).release(builder::build);
    }

    public static BlockCheck from(JsonArray json) {
        JsonArray matchers = new JsonArray();
        JsonArray positions = new JsonArray();
        for (JsonValue value : json) {
            if (value.isString()) {
                matchers.add(value);
                continue;
            }
            if (value.isArray()) {
                positions.add(value);
                continue;
            }
            throw CommonMethods.runExF("Expected array or string: {}", value);
        }
        return BlockCheck.from(new JsonObject().add("matchers", matchers).add("positions", positions));
    }

    BlockCheck(List<IBlockState> matchers, List<BlockPos> positions) {
        this.matchers = matchers;
        this.positions = positions;
    }

    public static BlockCheckBuilder builder() {
        return new BlockCheckBuilder();
    }

    public static final class Fields {
        public static final String matchers = "matchers";
        public static final String positions = "positions";
    }

    public static class BlockCheckBuilder {
        private List<IBlockState> matchers;
        private List<BlockPos> positions;

        BlockCheckBuilder() {
        }

        public BlockCheckBuilder matchers(List<IBlockState> matchers) {
            this.matchers = matchers;
            return this;
        }

        public BlockCheckBuilder positions(List<BlockPos> positions) {
            this.positions = positions;
            return this;
        }

        public BlockCheck build() {
            return new BlockCheck(this.matchers, this.positions);
        }

        public String toString() {
            return "BlockCheck.BlockCheckBuilder(matchers=" + this.matchers + ", positions=" + this.positions + ")";
        }
    }
}

