/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.noise.DummyGenerator;
import fastnoise.FastNoise;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Conditions {
    public final Predicate<Biome> biomes;
    public final boolean hasBiomes;
    public final boolean hasRegion;
    public final Predicate<Integer> dimensions;
    public final Range height;
    public final FastNoise floor;
    public final FastNoise ceiling;
    public final FastNoise region;
    public final FastNoise noise;

    public static Conditions compile(ConditionSettings settings, World world) {
        ConditionsBuilder builder = Conditions.builder().hasBiomes(settings.blacklistBiomes || !settings.biomes.isEmpty()).hasRegion(settings.region.isPresent()).biomes(Conditions.compileBiomes(settings)).dimensions(Conditions.compileDimensions(settings)).height(settings.height);
        settings.floor.ifPresent(c -> builder.floor(c.getGenerator(world)));
        settings.ceiling.ifPresent(c -> builder.ceiling(c.getGenerator(world)));
        settings.region.ifPresent(c -> builder.region(c.getGenerator(world)));
        settings.noise.ifPresent(c -> builder.noise(c.getGenerator(world)));
        return builder.build();
    }

    private static Predicate<Biome> compileBiomes(ConditionSettings settings) {
        List<Biome> list = settings.biomes;
        if (list.isEmpty()) {
            return b -> true;
        }
        if (list.size() == 1) {
            Biome listed = list.get(0);
            return settings.blacklistBiomes ? b -> !listed.equals(b) : listed::equals;
        }
        List<Biome> nonRedundant = Collections.unmodifiableList(new ArrayList<Biome>(new HashSet<Biome>(list)));
        return settings.blacklistBiomes ? b -> !nonRedundant.contains(b) : nonRedundant::contains;
    }

    private static Predicate<Integer> compileDimensions(ConditionSettings settings) {
        List<Integer> list = settings.dimensions;
        if (list.isEmpty()) {
            return d -> true;
        }
        if (list.size() == 1) {
            int listed = list.get(0);
            return settings.blacklistDimensions ? d -> listed != d : d -> listed == d;
        }
        IntList nonRedundant = IntLists.unmodifiable((IntList)new IntArrayList(new HashSet<Integer>(list)));
        return settings.blacklistDimensions ? d -> !nonRedundant.contains(d) : arg_0 -> nonRedundant.contains(arg_0);
    }

    public Range getColumn(int x, int z) {
        int min = this.height.min + (int)this.floor.GetAdjustedNoise(x, z);
        int max = this.height.max + (int)this.ceiling.GetAdjustedNoise(x, z);
        return Range.checkedOrEmpty(min, max);
    }

    public Range getColumn(int[][] heightmap, int x, int z) {
        int min = this.height.min + (int)this.floor.GetAdjustedNoise(x, z);
        int max = Math.min(this.height.max, heightmap[x & 0xF][z & 0xF]) + (int)this.ceiling.GetAdjustedNoise(x, z);
        return Range.checkedOrEmpty(min, max);
    }

    private static Predicate<Biome> $default$biomes() {
        return b -> true;
    }

    private static boolean $default$hasBiomes() {
        return false;
    }

    private static boolean $default$hasRegion() {
        return false;
    }

    private static Predicate<Integer> $default$dimensions() {
        return d -> true;
    }

    private static Range $default$height() {
        return Range.of(0, 255);
    }

    private static FastNoise $default$floor() {
        return new DummyGenerator(0.0f);
    }

    private static FastNoise $default$ceiling() {
        return new DummyGenerator(0.0f);
    }

    private static FastNoise $default$region() {
        return new DummyGenerator(0.0f);
    }

    private static FastNoise $default$noise() {
        return new DummyGenerator(0.0f);
    }

    Conditions(Predicate<Biome> biomes, boolean hasBiomes, boolean hasRegion, Predicate<Integer> dimensions, Range height, FastNoise floor, FastNoise ceiling, FastNoise region, FastNoise noise) {
        this.biomes = biomes;
        this.hasBiomes = hasBiomes;
        this.hasRegion = hasRegion;
        this.dimensions = dimensions;
        this.height = height;
        this.floor = floor;
        this.ceiling = ceiling;
        this.region = region;
        this.noise = noise;
    }

    public static ConditionsBuilder builder() {
        return new ConditionsBuilder();
    }

    public ConditionsBuilder toBuilder() {
        return new ConditionsBuilder().biomes(this.biomes).hasBiomes(this.hasBiomes).hasRegion(this.hasRegion).dimensions(this.dimensions).height(this.height).floor(this.floor).ceiling(this.ceiling).region(this.region).noise(this.noise);
    }

    public static class ConditionsBuilder {
        private boolean biomes$set;
        private Predicate<Biome> biomes$value;
        private boolean hasBiomes$set;
        private boolean hasBiomes$value;
        private boolean hasRegion$set;
        private boolean hasRegion$value;
        private boolean dimensions$set;
        private Predicate<Integer> dimensions$value;
        private boolean height$set;
        private Range height$value;
        private boolean floor$set;
        private FastNoise floor$value;
        private boolean ceiling$set;
        private FastNoise ceiling$value;
        private boolean region$set;
        private FastNoise region$value;
        private boolean noise$set;
        private FastNoise noise$value;

        ConditionsBuilder() {
        }

        public ConditionsBuilder biomes(Predicate<Biome> biomes) {
            this.biomes$value = biomes;
            this.biomes$set = true;
            return this;
        }

        public ConditionsBuilder hasBiomes(boolean hasBiomes) {
            this.hasBiomes$value = hasBiomes;
            this.hasBiomes$set = true;
            return this;
        }

        public ConditionsBuilder hasRegion(boolean hasRegion) {
            this.hasRegion$value = hasRegion;
            this.hasRegion$set = true;
            return this;
        }

        public ConditionsBuilder dimensions(Predicate<Integer> dimensions) {
            this.dimensions$value = dimensions;
            this.dimensions$set = true;
            return this;
        }

        public ConditionsBuilder height(Range height) {
            this.height$value = height;
            this.height$set = true;
            return this;
        }

        public ConditionsBuilder floor(FastNoise floor) {
            this.floor$value = floor;
            this.floor$set = true;
            return this;
        }

        public ConditionsBuilder ceiling(FastNoise ceiling) {
            this.ceiling$value = ceiling;
            this.ceiling$set = true;
            return this;
        }

        public ConditionsBuilder region(FastNoise region) {
            this.region$value = region;
            this.region$set = true;
            return this;
        }

        public ConditionsBuilder noise(FastNoise noise) {
            this.noise$value = noise;
            this.noise$set = true;
            return this;
        }

        public Conditions build() {
            Predicate biomes$value = this.biomes$value;
            if (!this.biomes$set) {
                biomes$value = Conditions.$default$biomes();
            }
            boolean hasBiomes$value = this.hasBiomes$value;
            if (!this.hasBiomes$set) {
                hasBiomes$value = Conditions.$default$hasBiomes();
            }
            boolean hasRegion$value = this.hasRegion$value;
            if (!this.hasRegion$set) {
                hasRegion$value = Conditions.$default$hasRegion();
            }
            Predicate dimensions$value = this.dimensions$value;
            if (!this.dimensions$set) {
                dimensions$value = Conditions.$default$dimensions();
            }
            Range height$value = this.height$value;
            if (!this.height$set) {
                height$value = Conditions.$default$height();
            }
            FastNoise floor$value = this.floor$value;
            if (!this.floor$set) {
                floor$value = Conditions.$default$floor();
            }
            FastNoise ceiling$value = this.ceiling$value;
            if (!this.ceiling$set) {
                ceiling$value = Conditions.$default$ceiling();
            }
            FastNoise region$value = this.region$value;
            if (!this.region$set) {
                region$value = Conditions.$default$region();
            }
            FastNoise noise$value = this.noise$value;
            if (!this.noise$set) {
                noise$value = Conditions.$default$noise();
            }
            return new Conditions(biomes$value, hasBiomes$value, hasRegion$value, dimensions$value, height$value, floor$value, ceiling$value, region$value, noise$value);
        }

        public String toString() {
            return "Conditions.ConditionsBuilder(biomes$value=" + this.biomes$value + ", hasBiomes$value=" + this.hasBiomes$value + ", hasRegion$value=" + this.hasRegion$value + ", dimensions$value=" + this.dimensions$value + ", height$value=" + this.height$value + ", floor$value=" + this.floor$value + ", ceiling$value=" + this.ceiling$value + ", region$value=" + this.region$value + ", noise$value=" + this.noise$value + ")";
        }
    }
}

