/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.model;

import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.model.ConfiguredWallDecorator;
import com.personthecat.cavegenerator.model.Direction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.World;

public class WallDecoratorMap {
    public final List<ConfiguredWallDecorator> all;
    public final List<ConfiguredWallDecorator> side;
    public final List<ConfiguredWallDecorator> up;
    public final List<ConfiguredWallDecorator> down;
    public final List<ConfiguredWallDecorator> north;
    public final List<ConfiguredWallDecorator> south;
    public final List<ConfiguredWallDecorator> east;
    public final List<ConfiguredWallDecorator> west;
    public final boolean containsAny;

    public static WallDecoratorMap sort(List<WallDecoratorSettings> decorators, World world) {
        WallDecoratorMapBuilder builder = WallDecoratorMap.builder().containsAny(!decorators.isEmpty());
        for (WallDecoratorSettings cfg : decorators) {
            ConfiguredWallDecorator wall = new ConfiguredWallDecorator(cfg, world);
            for (Direction d : cfg.directions) {
                switch (d) {
                    case ALL: {
                        builder.all(wall);
                        break;
                    }
                    case SIDE: {
                        builder.side(wall);
                        break;
                    }
                    case UP: {
                        builder.up(wall);
                        break;
                    }
                    case DOWN: {
                        builder.down(wall);
                        break;
                    }
                    case NORTH: {
                        builder.north(wall);
                        break;
                    }
                    case SOUTH: {
                        builder.south(wall);
                        break;
                    }
                    case EAST: {
                        builder.east(wall);
                        break;
                    }
                    case WEST: {
                        builder.west(wall);
                    }
                }
            }
        }
        return builder.build();
    }

    WallDecoratorMap(List<ConfiguredWallDecorator> all, List<ConfiguredWallDecorator> side, List<ConfiguredWallDecorator> up, List<ConfiguredWallDecorator> down, List<ConfiguredWallDecorator> north, List<ConfiguredWallDecorator> south, List<ConfiguredWallDecorator> east, List<ConfiguredWallDecorator> west, boolean containsAny) {
        this.all = all;
        this.side = side;
        this.up = up;
        this.down = down;
        this.north = north;
        this.south = south;
        this.east = east;
        this.west = west;
        this.containsAny = containsAny;
    }

    public static WallDecoratorMapBuilder builder() {
        return new WallDecoratorMapBuilder();
    }

    public static class WallDecoratorMapBuilder {
        private ArrayList<ConfiguredWallDecorator> all;
        private ArrayList<ConfiguredWallDecorator> side;
        private ArrayList<ConfiguredWallDecorator> up;
        private ArrayList<ConfiguredWallDecorator> down;
        private ArrayList<ConfiguredWallDecorator> north;
        private ArrayList<ConfiguredWallDecorator> south;
        private ArrayList<ConfiguredWallDecorator> east;
        private ArrayList<ConfiguredWallDecorator> west;
        private boolean containsAny;

        WallDecoratorMapBuilder() {
        }

        public WallDecoratorMapBuilder all(ConfiguredWallDecorator all) {
            if (this.all == null) {
                this.all = new ArrayList();
            }
            this.all.add(all);
            return this;
        }

        public WallDecoratorMapBuilder all(Collection<? extends ConfiguredWallDecorator> all) {
            if (all == null) {
                throw new NullPointerException("all cannot be null");
            }
            if (this.all == null) {
                this.all = new ArrayList();
            }
            this.all.addAll(all);
            return this;
        }

        public WallDecoratorMapBuilder clearAll() {
            if (this.all != null) {
                this.all.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder side(ConfiguredWallDecorator side) {
            if (this.side == null) {
                this.side = new ArrayList();
            }
            this.side.add(side);
            return this;
        }

        public WallDecoratorMapBuilder side(Collection<? extends ConfiguredWallDecorator> side) {
            if (side == null) {
                throw new NullPointerException("side cannot be null");
            }
            if (this.side == null) {
                this.side = new ArrayList();
            }
            this.side.addAll(side);
            return this;
        }

        public WallDecoratorMapBuilder clearSide() {
            if (this.side != null) {
                this.side.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder up(ConfiguredWallDecorator up) {
            if (this.up == null) {
                this.up = new ArrayList();
            }
            this.up.add(up);
            return this;
        }

        public WallDecoratorMapBuilder up(Collection<? extends ConfiguredWallDecorator> up) {
            if (up == null) {
                throw new NullPointerException("up cannot be null");
            }
            if (this.up == null) {
                this.up = new ArrayList();
            }
            this.up.addAll(up);
            return this;
        }

        public WallDecoratorMapBuilder clearUp() {
            if (this.up != null) {
                this.up.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder down(ConfiguredWallDecorator down) {
            if (this.down == null) {
                this.down = new ArrayList();
            }
            this.down.add(down);
            return this;
        }

        public WallDecoratorMapBuilder down(Collection<? extends ConfiguredWallDecorator> down) {
            if (down == null) {
                throw new NullPointerException("down cannot be null");
            }
            if (this.down == null) {
                this.down = new ArrayList();
            }
            this.down.addAll(down);
            return this;
        }

        public WallDecoratorMapBuilder clearDown() {
            if (this.down != null) {
                this.down.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder north(ConfiguredWallDecorator north) {
            if (this.north == null) {
                this.north = new ArrayList();
            }
            this.north.add(north);
            return this;
        }

        public WallDecoratorMapBuilder north(Collection<? extends ConfiguredWallDecorator> north) {
            if (north == null) {
                throw new NullPointerException("north cannot be null");
            }
            if (this.north == null) {
                this.north = new ArrayList();
            }
            this.north.addAll(north);
            return this;
        }

        public WallDecoratorMapBuilder clearNorth() {
            if (this.north != null) {
                this.north.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder south(ConfiguredWallDecorator south) {
            if (this.south == null) {
                this.south = new ArrayList();
            }
            this.south.add(south);
            return this;
        }

        public WallDecoratorMapBuilder south(Collection<? extends ConfiguredWallDecorator> south) {
            if (south == null) {
                throw new NullPointerException("south cannot be null");
            }
            if (this.south == null) {
                this.south = new ArrayList();
            }
            this.south.addAll(south);
            return this;
        }

        public WallDecoratorMapBuilder clearSouth() {
            if (this.south != null) {
                this.south.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder east(ConfiguredWallDecorator east) {
            if (this.east == null) {
                this.east = new ArrayList();
            }
            this.east.add(east);
            return this;
        }

        public WallDecoratorMapBuilder east(Collection<? extends ConfiguredWallDecorator> east) {
            if (east == null) {
                throw new NullPointerException("east cannot be null");
            }
            if (this.east == null) {
                this.east = new ArrayList();
            }
            this.east.addAll(east);
            return this;
        }

        public WallDecoratorMapBuilder clearEast() {
            if (this.east != null) {
                this.east.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder west(ConfiguredWallDecorator west) {
            if (this.west == null) {
                this.west = new ArrayList();
            }
            this.west.add(west);
            return this;
        }

        public WallDecoratorMapBuilder west(Collection<? extends ConfiguredWallDecorator> west) {
            if (west == null) {
                throw new NullPointerException("west cannot be null");
            }
            if (this.west == null) {
                this.west = new ArrayList();
            }
            this.west.addAll(west);
            return this;
        }

        public WallDecoratorMapBuilder clearWest() {
            if (this.west != null) {
                this.west.clear();
            }
            return this;
        }

        public WallDecoratorMapBuilder containsAny(boolean containsAny) {
            this.containsAny = containsAny;
            return this;
        }

        public WallDecoratorMap build() {
            List<ConfiguredWallDecorator> west;
            List<ConfiguredWallDecorator> east;
            List<ConfiguredWallDecorator> south;
            List<ConfiguredWallDecorator> north;
            List<ConfiguredWallDecorator> down;
            List<ConfiguredWallDecorator> up;
            List<ConfiguredWallDecorator> side;
            List<ConfiguredWallDecorator> all;
            switch (this.all == null ? 0 : this.all.size()) {
                case 0: {
                    all = Collections.emptyList();
                    break;
                }
                case 1: {
                    all = Collections.singletonList(this.all.get(0));
                    break;
                }
                default: {
                    all = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.all));
                }
            }
            switch (this.side == null ? 0 : this.side.size()) {
                case 0: {
                    side = Collections.emptyList();
                    break;
                }
                case 1: {
                    side = Collections.singletonList(this.side.get(0));
                    break;
                }
                default: {
                    side = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.side));
                }
            }
            switch (this.up == null ? 0 : this.up.size()) {
                case 0: {
                    up = Collections.emptyList();
                    break;
                }
                case 1: {
                    up = Collections.singletonList(this.up.get(0));
                    break;
                }
                default: {
                    up = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.up));
                }
            }
            switch (this.down == null ? 0 : this.down.size()) {
                case 0: {
                    down = Collections.emptyList();
                    break;
                }
                case 1: {
                    down = Collections.singletonList(this.down.get(0));
                    break;
                }
                default: {
                    down = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.down));
                }
            }
            switch (this.north == null ? 0 : this.north.size()) {
                case 0: {
                    north = Collections.emptyList();
                    break;
                }
                case 1: {
                    north = Collections.singletonList(this.north.get(0));
                    break;
                }
                default: {
                    north = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.north));
                }
            }
            switch (this.south == null ? 0 : this.south.size()) {
                case 0: {
                    south = Collections.emptyList();
                    break;
                }
                case 1: {
                    south = Collections.singletonList(this.south.get(0));
                    break;
                }
                default: {
                    south = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.south));
                }
            }
            switch (this.east == null ? 0 : this.east.size()) {
                case 0: {
                    east = Collections.emptyList();
                    break;
                }
                case 1: {
                    east = Collections.singletonList(this.east.get(0));
                    break;
                }
                default: {
                    east = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.east));
                }
            }
            switch (this.west == null ? 0 : this.west.size()) {
                case 0: {
                    west = Collections.emptyList();
                    break;
                }
                case 1: {
                    west = Collections.singletonList(this.west.get(0));
                    break;
                }
                default: {
                    west = Collections.unmodifiableList(new ArrayList<ConfiguredWallDecorator>(this.west));
                }
            }
            return new WallDecoratorMap(all, side, up, down, north, south, east, west, this.containsAny);
        }

        public String toString() {
            return "WallDecoratorMap.WallDecoratorMapBuilder(all=" + this.all + ", side=" + this.side + ", up=" + this.up + ", down=" + this.down + ", north=" + this.north + ", south=" + this.south + ", east=" + this.east + ", west=" + this.west + ", containsAny=" + this.containsAny + ")";
        }
    }
}

