/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import com.personthecat.cavegenerator.data.WallDecoratorSettings;
import com.personthecat.cavegenerator.model.Direction;
import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.model.ScalableFloat;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.HjsonTools;
import fastnoise.FastNoise;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class HjsonMapper {
    private final JsonObject json;

    public HjsonMapper mapBool(String field, Consumer<Boolean> ifPresent) {
        HjsonTools.getBool(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapInt(String field, Consumer<Integer> ifPresent) {
        HjsonTools.getInt(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapIntList(String field, Consumer<List<Integer>> ifPresent) {
        HjsonTools.getIntList(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapFloat(String field, Consumer<Float> ifPresent) {
        HjsonTools.getFloat(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapString(String field, Consumer<String> ifPresent) {
        HjsonTools.getString(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapRequiredString(String field, String parent, Consumer<String> mapper) {
        mapper.accept(HjsonTools.getString(this.json, field).orElseThrow(() -> CommonMethods.runExF("{}.{} is required", parent, field)));
        return this;
    }

    public HjsonMapper mapBiomes(String field, Consumer<List<Biome>> ifPresent) {
        HjsonTools.getBiomeList(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapRange(String field, Consumer<Range> ifPresent) {
        HjsonTools.getRange(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapRangeOrTry(String field, String otherField, Consumer<Range> ifPresent) {
        Optional<Range> range = HjsonTools.getRange(this.json, field);
        range.ifPresent(ifPresent);
        if (!range.isPresent()) {
            return this.mapRange(otherField, ifPresent);
        }
        return this;
    }

    public HjsonMapper mapFloatRange(String field, Consumer<FloatRange> ifPresent) {
        HjsonTools.getFloatRange(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapDistFunc(String field, Consumer<FastNoise.CellularDistanceFunction> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, FastNoise.CellularDistanceFunction.class).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapReturnType(String field, Consumer<FastNoise.CellularReturnType> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, FastNoise.CellularReturnType.class).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapFractalType(String field, Consumer<FastNoise.FractalType> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, FastNoise.FractalType.class).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapInterp(String field, Consumer<FastNoise.Interp> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, FastNoise.Interp.class).ifPresent(ifPresent);
        return this;
    }

    public <E extends Enum<E>> HjsonMapper mapEnum(String field, Class<E> e, Consumer<E> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, e).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapNoiseType(String field, Consumer<FastNoise.NoiseType> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, FastNoise.NoiseType.class).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapDirectionList(String field, Consumer<List<Direction>> ifPresent) {
        HjsonTools.getDirectionList(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapPlacementPreference(String field, Consumer<WallDecoratorSettings.Placement> ifPresent) {
        HjsonTools.getEnumValue(this.json, field, WallDecoratorSettings.Placement.class).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapState(String field, Consumer<IBlockState> ifPresent) {
        HjsonTools.getState(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapStateList(String field, Consumer<List<IBlockState>> ifPresent) {
        HjsonTools.getStateList(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapRequiredState(String field, String parent, Consumer<IBlockState> mapper) {
        mapper.accept(HjsonTools.getState(this.json, field).orElseThrow(() -> CommonMethods.runExF("{}.{} is required", parent, field)));
        return this;
    }

    public HjsonMapper mapRequiredStateList(String field, String parent, Consumer<List<IBlockState>> mapper) {
        List<IBlockState> states = HjsonTools.getStateList(this.json, field).orElseThrow(() -> CommonMethods.runExF("{}.{} is required", parent, field));
        mapper.accept(states);
        return this;
    }

    public HjsonMapper mapBlockPos(String field, Consumer<BlockPos> ifPresent) {
        HjsonTools.getPosition(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapBlockPosList(String field, Consumer<List<BlockPos>> ifPresent) {
        HjsonTools.getPositionList(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public HjsonMapper mapRequiredBlockPosList(String field, String parent, Consumer<List<BlockPos>> mapper) {
        List<BlockPos> positions = HjsonTools.getPositionList(this.json, field).orElseThrow(() -> CommonMethods.runExF("{}.{} is required", parent, field));
        mapper.accept(positions);
        return this;
    }

    public HjsonMapper mapScalableFloat(String field, ScalableFloat defaults, Consumer<ScalableFloat> ifPresent) {
        if (this.json.has(field)) {
            ifPresent.accept(HjsonTools.getScalableFloatOr(this.json, field, defaults));
        }
        return this;
    }

    public HjsonMapper mapPlacementSettings(Consumer<PlacementSettings> mapper) {
        mapper.accept(HjsonTools.getPlacementSettings(this.json));
        return this;
    }

    public HjsonMapper mapObject(String field, Consumer<JsonObject> ifPresent) {
        HjsonTools.getObject(this.json, field).ifPresent(ifPresent);
        return this;
    }

    public <T> HjsonMapper mapArray(String field, Function<JsonObject, T> mapper, Consumer<List<T>> ifPresent) {
        if (this.json.has(field)) {
            List list = HjsonTools.getObjectArray(this.json, field).stream().map(mapper).collect(Collectors.toList());
            ifPresent.accept(list);
        }
        return this;
    }

    public <T> HjsonMapper mapValueArray(String field, Function<JsonValue, T> mapper, Consumer<List<T>> ifPresent) {
        JsonValue value = this.json.get(field);
        if (value != null) {
            ArrayList<T> list = new ArrayList<T>();
            for (JsonValue inner : HjsonTools.asOrToArray(value)) {
                list.add(mapper.apply(inner));
            }
            ifPresent.accept(list);
        }
        return this;
    }

    public HjsonMapper mapSelf(Consumer<JsonObject> mapper) {
        mapper.accept(this.json);
        return this;
    }

    public <T> T release(Supplier<T> supplier) {
        return supplier.get();
    }

    public HjsonMapper(JsonObject json) {
        this.json = json;
    }
}

