/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.util;

import com.personthecat.cavegenerator.model.Direction;
import com.personthecat.cavegenerator.model.FloatRange;
import com.personthecat.cavegenerator.model.Range;
import com.personthecat.cavegenerator.model.ScalableFloat;
import com.personthecat.cavegenerator.util.CommonMethods;
import com.personthecat.cavegenerator.util.PathComponent;
import com.personthecat.cavegenerator.util.Result;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.io.output.NullWriter;
import org.hjson.HjsonOptions;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;
import org.hjson.Stringify;

public class HjsonTools {
    public static final HjsonOptions FORMATTER = new HjsonOptions().setAllowCondense(true).setAllowMultiVal(true).setCommentSpace(0).setSpace(2).setBracesSameLine(true).setOutputComments(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<IOException> writeJson(JsonObject json, File file) {
        Result<IOException> result = Result.ok();
        Object tw = new NullWriter();
        try {
            tw = new FileWriter(file);
            if (CommonMethods.extension(file).equals("json")) {
                json.writeTo((Writer)tw, Stringify.FORMATTED);
            } else {
                json.writeTo((Writer)tw, FORMATTER);
            }
        }
        catch (IOException e) {
            result = Result.of(e);
        }
        finally {
            HjsonTools.assertCloseWriter((Writer)tw);
        }
        return result;
    }

    private static void assertCloseWriter(Writer tw) {
        try {
            tw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonObject setOrAdd(JsonObject json, String field, boolean value) {
        return HjsonTools.setOrAdd(json, field, JsonValue.valueOf(value));
    }

    public static JsonObject setOrAdd(JsonObject json, String field, JsonValue value) {
        if (json.get(field) != null) {
            return json.set(field, value);
        }
        return json.add(field, value);
    }

    public static void setValueFromPath(JsonObject json, List<PathComponent> path, JsonValue value) {
        if (path.isEmpty()) {
            return;
        }
        PathComponent lastVal = path.get(path.size() - 1);
        HjsonTools.setEither(HjsonTools.getLastContainer(json, path), lastVal, value);
    }

    public static JsonValue getLastContainer(JsonObject json, List<PathComponent> path) {
        if (path.isEmpty()) {
            return json;
        }
        JsonValue current = json;
        for (int i = 0; i < path.size() - 1; ++i) {
            PathComponent val = path.get(i);
            PathComponent peek = path.get(i + 1);
            current = val.index.isPresent() ? HjsonTools.getOrTryNew(current.asArray(), val.index.get(), peek) : (peek.key.isPresent() ? HjsonTools.getObjectOrNew(((JsonValue)current).asObject(), val.key.orElseThrow(() -> CommonMethods.runEx("Unreachable."))) : HjsonTools.getArrayOrNew(((JsonValue)current).asObject(), val.key.orElseThrow(() -> CommonMethods.runEx("Unreachable."))));
        }
        return current;
    }

    private static JsonValue getOrTryNew(JsonArray array, int index, PathComponent type) {
        if (index == array.size()) {
            type.key.ifPresent(s -> array.add(new JsonObject()));
            type.index.ifPresent(i -> array.add(new JsonArray()));
        }
        return array.get(index);
    }

    private static void setEither(JsonValue container, PathComponent either, JsonValue value) {
        either.key.ifPresent(key -> container.asObject().set((String)key, value));
        either.index.ifPresent(index -> container.asArray().set((int)index, value));
    }

    public static Optional<Boolean> getBool(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(JsonValue::asBoolean);
    }

    public static Optional<Integer> getInt(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(JsonValue::asInt);
    }

    public static int getIntOr(JsonObject json, String field, int orElse) {
        return HjsonTools.getInt(json, field).orElse(orElse);
    }

    public static Optional<Range> getRange(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).map(HjsonTools::toIntArray).map(CommonMethods::sort).map(HjsonTools::toRange);
    }

    private static Range toRange(int[] range) {
        if (range.length == 0) {
            return new Range(0);
        }
        return range.length == 1 ? new Range(range[0]) : new Range(range[0], range[range.length - 1]);
    }

    public static Optional<FloatRange> getFloatRange(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).map(HjsonTools::toFloatArray).map(CommonMethods::sort).map(HjsonTools::toFloatRange);
    }

    private static FloatRange toFloatRange(float[] range) {
        if (range.length == 0) {
            return new FloatRange(0.0f);
        }
        return range.length == 1 ? new FloatRange(range[0]) : new FloatRange(range[0], range[range.length - 1]);
    }

    public static Optional<Float> getFloat(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(JsonValue::asFloat);
    }

    public static float getFloatOr(JsonObject json, String field, float orElse) {
        return HjsonTools.getFloat(json, field).orElse(Float.valueOf(orElse)).floatValue();
    }

    public static Optional<String> getString(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(JsonValue::asString);
    }

    public static Optional<JsonArray> getArray(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray);
    }

    public static JsonArray getArrayOrNew(JsonObject json, String field) {
        if (!json.has(field)) {
            json.set(field, new JsonArray());
        }
        return HjsonTools.getArray(json, field).orElseThrow(() -> CommonMethods.runEx("Unreachable."));
    }

    public static JsonArray asOrToArray(JsonValue value) {
        return value.isArray() ? value.asArray() : new JsonArray().add(value);
    }

    public static Optional<JsonObject> getObject(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(JsonValue::asObject);
    }

    public static JsonObject getObjectOrNew(JsonObject json, String field) {
        if (!json.has(field)) {
            json.set(field, new JsonObject());
        }
        return HjsonTools.getObject(json, field).orElseThrow(() -> CommonMethods.runEx("Unreachable."));
    }

    public static Optional<JsonValue> getValue(JsonObject json, String field) {
        return Optional.ofNullable(json.get(field));
    }

    public static List<JsonObject> getObjectArray(JsonObject json, String field) {
        ArrayList<JsonObject> array = new ArrayList<JsonObject>();
        HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).ifPresent(a -> HjsonTools.flatten(array, a));
        return array;
    }

    private static void flatten(List<JsonObject> array, JsonArray source) {
        for (JsonValue value : source) {
            if (value.isArray()) {
                HjsonTools.flatten(array, value.asArray());
                continue;
            }
            array.add(value.asObject());
        }
    }

    public static List<JsonObject> getRegularObjects(JsonObject json, String field) {
        ArrayList<JsonObject> list = new ArrayList<JsonObject>();
        JsonArray array = HjsonTools.getValue(json, field).map(HjsonTools::asOrToArray).orElseGet(JsonArray::new);
        HjsonTools.flattenRegularObjects(list, array);
        return list;
    }

    private static void flattenRegularObjects(List<JsonObject> array, JsonArray source) {
        for (JsonValue value : source) {
            if (value.isArray()) {
                HjsonTools.flattenRegularObjects(array, value.asArray());
                continue;
            }
            if (!value.isObject()) continue;
            array.add(value.asObject());
        }
    }

    public static Optional<List<Integer>> getIntList(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(HjsonTools::toIntList);
    }

    private static List<Integer> toIntList(JsonArray array) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (JsonValue value : array) {
            if (!value.isNumber()) {
                throw CommonMethods.runExF("Expected an numeric value: {}", value);
            }
            ints.add(value.asInt());
        }
        return ints;
    }

    public static int[] toIntArray(JsonArray array) {
        int[] ints = new int[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            ints[i] = array.get(i).asInt();
        }
        return ints;
    }

    public static float[] toFloatArray(JsonArray array) {
        float[] floats = new float[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            floats[i] = array.get(i).asFloat();
        }
        return floats;
    }

    public static Optional<List<String>> getStringArray(JsonObject json, String field) {
        return HjsonTools.getValue(json, field).map(v -> HjsonTools.toStringArray(HjsonTools.asOrToArray(v)));
    }

    public static List<String> toStringArray(JsonArray array) {
        ArrayList<String> strings = new ArrayList<String>();
        for (JsonValue value : array) {
            strings.add(value.asString());
        }
        return strings;
    }

    public static Optional<IBlockState> getState(JsonObject json, String field) {
        return HjsonTools.getString(json, field).map(id -> CommonMethods.getBlockState(id).orElseThrow(() -> HjsonTools.noBlockNamed(id)));
    }

    public static Optional<List<IBlockState>> getStateList(JsonObject json, String field) {
        return HjsonTools.getStringArray(json, field).map(HjsonTools::toStateList);
    }

    private static List<IBlockState> toStateList(List<String> ids) {
        return ids.stream().map(id -> CommonMethods.getBlockState(id).orElseThrow(() -> HjsonTools.noBlockNamed(id))).collect(Collectors.toList());
    }

    public static Optional<List<Direction>> getDirectionList(JsonObject json, String field) {
        return HjsonTools.getStringArray(json, field).map(HjsonTools::toDirections);
    }

    private static List<Direction> toDirections(List<String> directions) {
        return directions.stream().map(s -> HjsonTools.toEnumValue(s, Direction.class)).collect(Collectors.toList());
    }

    public static Optional<BlockPos> getPosition(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(HjsonTools::toPosition);
    }

    public static Optional<List<BlockPos>> getPositionList(JsonObject json, String field) {
        return HjsonTools.getArray(json, field).map(HjsonTools::toPositionList);
    }

    public static BlockPos toPosition(JsonArray coordinates) {
        if (coordinates.size() != 3) {
            throw CommonMethods.runEx("Relative coordinates must be specified in an array of 3 elements, e.g. [0, 0, 0].");
        }
        return new BlockPos(coordinates.get(0).asInt(), coordinates.get(1).asInt(), coordinates.get(2).asInt());
    }

    private static List<BlockPos> toPositionList(JsonArray positions) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (JsonValue position : positions) {
            if (position.isNumber()) {
                return Collections.singletonList(HjsonTools.toPosition(positions));
            }
            if (!position.isArray()) {
                throw CommonMethods.runEx("Expected a list of positions, e.g. [[0, 0, 0], [1, 1, 1]].");
            }
            list.add(HjsonTools.toPosition(position.asArray()));
        }
        return list;
    }

    public static Optional<List<Biome>> getBiomeList(JsonObject json, String field) {
        return HjsonTools.getObject(json, field).map(HjsonTools::toBiomes);
    }

    private static List<Biome> toBiomes(JsonObject json) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        HjsonTools.getArray(json, "names").map(HjsonTools::toStringArray).ifPresent(a -> {
            for (String s : a) {
                biomes.add(CommonMethods.getBiome(s).orElseThrow(() -> HjsonTools.noBiomeNamed(s)));
            }
        });
        HjsonTools.getArray(json, "IDs").map(HjsonTools::toIntArray).ifPresent(a -> {
            for (int i : a) {
                biomes.add(CommonMethods.getBiome(i).orElseThrow(() -> HjsonTools.noBiomeID(i)));
            }
        });
        HjsonTools.getArray(json, "types").map(HjsonTools::toBiomeTypes).ifPresent(a -> {
            for (BiomeDictionary.Type t : a) {
                Collections.addAll(biomes, CommonMethods.getBiomes(t));
            }
        });
        return biomes;
    }

    public static List<BiomeDictionary.Type> toBiomeTypes(JsonArray array) {
        ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
        for (JsonValue value : array) {
            types.add(CommonMethods.getBiomeType(value.asString()));
        }
        return types;
    }

    public static PlacementSettings getPlacementSettings(JsonObject json) {
        PlacementSettings settings = new PlacementSettings().func_186225_a(Blocks.field_150348_b);
        HjsonTools.getFloat(json, "integrity").ifPresent(arg_0 -> ((PlacementSettings)settings).func_189946_a(arg_0));
        HjsonTools.getState(json, "replacedBlock").ifPresent(s -> settings.func_186225_a(s.func_177230_c()));
        HjsonTools.getEnumValue(json, "mirror", Mirror.class).ifPresent(arg_0 -> ((PlacementSettings)settings).func_186214_a(arg_0));
        HjsonTools.getBool(json, "ignoreEntities").ifPresent(arg_0 -> ((PlacementSettings)settings).func_186222_a(arg_0));
        return settings;
    }

    private static Optional<ScalableFloat> getScalableFloat(JsonObject json, String field, ScalableFloat defaults) {
        return HjsonTools.getValue(json, field).map(v -> {
            if (v.isNumber()) {
                return HjsonTools.toScalableFloat(v.asInt(), defaults);
            }
            if (v.isObject()) {
                return HjsonTools.toScalableFloat(v.asObject(), defaults);
            }
            if (!v.isArray()) {
                throw CommonMethods.runEx("Scalable float values must be a number, array, or object.");
            }
            return HjsonTools.toScalableFloat(v.asArray(), defaults);
        });
    }

    public static ScalableFloat getScalableFloatOr(JsonObject json, String field, ScalableFloat defaults) {
        return HjsonTools.getScalableFloat(json, field, defaults).orElse(defaults);
    }

    public static ScalableFloat toScalableFloat(int startVal, ScalableFloat defaults) {
        return new ScalableFloat(startVal, defaults.startValRandFactor, defaults.factor, defaults.randFactor, defaults.exponent);
    }

    public static ScalableFloat toScalableFloat(JsonArray array, ScalableFloat defaults) {
        return new ScalableFloat(array.size() > 0 ? array.get(0).asFloat() : defaults.startVal, array.size() > 1 ? array.get(1).asFloat() : defaults.startValRandFactor, array.size() > 2 ? array.get(2).asFloat() : defaults.factor, array.size() > 3 ? array.get(3).asFloat() : defaults.randFactor, array.size() > 4 ? array.get(4).asFloat() : defaults.exponent);
    }

    public static ScalableFloat toScalableFloat(JsonObject json, ScalableFloat defaults) {
        return new ScalableFloat(HjsonTools.getFloatOr(json, "startVal", defaults.startVal), HjsonTools.getFloatOr(json, "startValRandFactor", defaults.startValRandFactor), HjsonTools.getFloatOr(json, "factor", defaults.factor), HjsonTools.getFloatOr(json, "randFactor", defaults.randFactor), HjsonTools.getFloatOr(json, "exponent", defaults.exponent));
    }

    public static <T extends Enum<T>> Optional<T> getEnumValue(JsonObject json, String field, Class<T> clazz) {
        return HjsonTools.getString(json, field).map(s -> HjsonTools.toEnumValue(s, clazz));
    }

    private static <T extends Enum<T>> T toEnumValue(String s, Class<T> clazz) {
        Enum[] constants = (Enum[])clazz.getEnumConstants();
        return (T)CommonMethods.find(constants, v -> v.toString().equalsIgnoreCase(s)).orElseThrow(() -> {
            String name = clazz.getSimpleName();
            String values = Arrays.toString(constants);
            return CommonMethods.runExF("{} \"{}\" does not exist. Valid options are: {}", name, s, values);
        });
    }

    public static RuntimeException noBiomeNamed(String name) {
        return CommonMethods.runExF("There is no biome named \"{}.\"", name);
    }

    public static RuntimeException noBiomeID(int ID) {
        return CommonMethods.runExF("There is no biome with id \"%d.\"", ID);
    }

    public static RuntimeException noBlockNamed(String name) {
        return CommonMethods.runExF("There is no block named \"{}.\"", name);
    }
}

