/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world;

import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.util.Lazy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeSearch {
    public final Lazy<Biome[]> current;
    public final Lazy<Data[]> surrounding;

    public boolean anyMatches(Predicate<Biome> predicate) {
        for (Biome b : this.current.get()) {
            if (!predicate.test(b)) continue;
            return true;
        }
        return false;
    }

    public static int size() {
        int d = ConfigFile.biomeRange * 2 + 1;
        return d * d;
    }

    public static BiomeSearch in(World world, int x, int z) {
        Lazy<Supplier<Biome[]>> current = Lazy.of(() -> BiomeSearch.inner(world, x, z));
        Lazy<Supplier<Data[]>> surrounding = Lazy.of(() -> BiomeSearch.outer(world, x, z, ConfigFile.biomeRange));
        return new BiomeSearch(current, surrounding);
    }

    private static Biome[] inner(World world, int x, int z) {
        BiomeProvider provider = world.func_72959_q();
        int actualX = x << 4;
        int actualZ = z << 4;
        List<Biome> biomes = Arrays.asList(provider.func_180631_a(new BlockPos(actualX + 1, 0, actualZ + 1)), provider.func_180631_a(new BlockPos(actualX + 1, 0, actualZ + 14)), provider.func_180631_a(new BlockPos(actualX + 14, 0, actualZ + 1)), provider.func_180631_a(new BlockPos(actualX + 14, 0, actualZ + 14)));
        return new HashSet<Biome>(biomes).toArray(new Biome[0]);
    }

    private static Data[] outer(World world, int x, int z, int r) {
        int d = r * 2 + 1;
        Data[] biomes = new Data[d * d];
        int index = 0;
        for (int cX = x - r; cX <= x + r; ++cX) {
            for (int cZ = z - r; cZ <= z + r; ++cZ) {
                biomes[index++] = Data.create(world, cX, cZ);
            }
        }
        return biomes;
    }

    private BiomeSearch(Lazy<Biome[]> current, Lazy<Data[]> surrounding) {
        this.current = current;
        this.surrounding = surrounding;
    }

    public static class Data {
        public final Biome biome;
        public final int chunkX;
        public final int chunkZ;
        public final int centerX;
        public final int centerZ;

        private static Data create(World world, int chunkX, int chunkZ) {
            int centerX = (chunkX << 4) + 8;
            int centerZ = (chunkZ << 4) + 8;
            Biome biome = world.func_72959_q().func_180631_a(new BlockPos(centerX, 0, centerZ));
            return new Data(biome, chunkX, chunkZ, centerX, centerZ);
        }

        private Data(Biome biome, int chunkX, int chunkZ, int centerX, int centerZ) {
            this.biome = biome;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.centerX = centerX;
            this.centerZ = centerZ;
        }
    }
}

