/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.event;

import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.world.generator.EarlyCaveHook;
import com.personthecat.cavegenerator.world.generator.NoGeneration;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ReplaceVanillaCaveGen {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInitMapGen(InitMapGenEvent event) {
        boolean isOriginalGen = event.getNewGen().equals(event.getOriginalGen());
        switch (event.getType()) {
            case CAVE: {
                if (isOriginalGen) {
                    event.setNewGen((MapGenBase)new EarlyCaveHook(null));
                    break;
                }
                event.setNewGen((MapGenBase)new EarlyCaveHook(event.getNewGen()));
                break;
            }
            case RAVINE: {
                if (!isOriginalGen) break;
                event.setNewGen((MapGenBase)NoGeneration.getInstance());
                break;
            }
            case NETHER_CAVE: {
                if (!ConfigFile.netherGenerate) break;
                if (isOriginalGen) {
                    event.setNewGen((MapGenBase)new EarlyCaveHook(null));
                    break;
                }
                event.setNewGen((MapGenBase)new EarlyCaveHook(event.getNewGen()));
                break;
            }
            case MINESHAFT: {
                if (ConfigFile.enableMineshafts || !isOriginalGen) break;
                event.setNewGen((MapGenBase)NoGeneration.getInstance());
            }
        }
    }
}

