/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.ConditionSettings;
import com.personthecat.cavegenerator.model.Conditions;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import java.lang.ref.WeakReference;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class BasicGenerator {
    protected static final IBlockState BLK_AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BLK_STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState BLK_WATER = Blocks.field_150355_j.func_176223_P();
    protected final Conditions conditions;
    protected final WeakReference<World> world;

    public BasicGenerator(ConditionSettings conditions, World world) {
        Objects.requireNonNull(world, "Nullable world types are not yet supported.");
        this.conditions = Conditions.compile(conditions, world);
        this.world = new WeakReference<World>(world);
    }

    protected final World getWorld() {
        return Objects.requireNonNull((World)this.world.get(), "World reference has been culled.");
    }

    public void generate(PrimerContext ctx) {
        Biome b;
        int dim = ctx.world.field_73011_w.getDimension();
        if (this.conditions.dimensions.test(dim) && this.conditions.biomes.test(b = ctx.world.func_180494_b(new BlockPos(ctx.offsetX, 0, ctx.offsetZ)))) {
            this.generateChecked(ctx);
        }
    }

    protected abstract void generateChecked(PrimerContext var1);
}

