/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.Main;
import com.personthecat.cavegenerator.config.ConfigFile;
import com.personthecat.cavegenerator.noise.CachedNoiseHelper;
import com.personthecat.cavegenerator.world.BiomeSearch;
import com.personthecat.cavegenerator.world.GeneratorController;
import com.personthecat.cavegenerator.world.HeightMapLocator;
import com.personthecat.cavegenerator.world.generator.PrimerContext;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;
import org.apache.commons.lang3.ArrayUtils;

@ParametersAreNonnullByDefault
public class EarlyCaveHook
extends MapGenBase {
    @Nullable
    MapGenBase priorCaves;

    public EarlyCaveHook(@Nullable MapGenBase priorCaves) {
        this.priorCaves = priorCaves;
    }

    public void func_186125_a(World world, int x, int z, ChunkPrimer primer) {
        if (ConfigFile.otherGeneratorEnabled && this.priorCaves != null) {
            this.priorCaves.func_186125_a(world, x, z, primer);
        }
        Map<String, GeneratorController> generators = Main.instance.loadGenerators(world);
        int[][] heightmap = ArrayUtils.contains((int[])ConfigFile.heightMapDims, (int)world.field_73011_w.getDimension()) ? HeightMapLocator.getHeightFromPrimer(primer) : HeightMapLocator.FAUX_MAP;
        BiomeSearch biomes = BiomeSearch.in(world, x, z);
        PrimerContext ctx = new PrimerContext(biomes, heightmap, world, x, z, primer);
        ctx.world.field_73012_v.setSeed(ctx.world.func_72905_C());
        for (GeneratorController generator : generators.values()) {
            generator.earlyGenerate(ctx);
            generator.mapGenerate(ctx);
        }
        CachedNoiseHelper.resetAll();
    }
}

