/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.cavegenerator.world.generator;

import com.personthecat.cavegenerator.data.RavineSettings;
import com.personthecat.cavegenerator.model.PrimerData;
import com.personthecat.cavegenerator.util.XoRoShiRo;
import com.personthecat.cavegenerator.world.generator.MapGenerator;
import com.personthecat.cavegenerator.world.generator.SphereData;
import com.personthecat.cavegenerator.world.generator.TunnelPathInfo;
import fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class RavineGenerator
extends MapGenerator {
    private final float[] mut = new float[256];
    private final RavineSettings cfg;
    private final FastNoise wallNoise;
    private final double cutoff;

    public RavineGenerator(RavineSettings cfg, World world) {
        super(cfg.conditions, cfg.decorators, world, cfg.checkWater);
        this.cfg = cfg;
        this.wallNoise = cfg.walls.getGenerator(world);
        this.cutoff = 1.0 + cfg.cutoffStrength;
    }

    @Override
    protected void mapGenerate(MapGenerator.MapGenerationContext ctx) {
        if (ctx.rand.nextInt(this.cfg.chance) == 0) {
            this.startRavine(ctx.world, ctx.rand.nextLong(), ctx.destChunkX, ctx.destChunkZ, ctx.chunkX, ctx.chunkZ, ctx.primer);
        }
    }

    @Override
    protected void fillSphere(SphereData sphere, double cX, double cY, double cZ, int absX, int absZ, double rXZ, double rY, int miX, int maX, int miY, int maY, int miZ, int maZ) {
        for (int x = miX; x < maX; ++x) {
            double distX = ((double)(x + absX) + 0.5 - cX) / rXZ;
            double distX2 = distX * distX;
            for (int z = miZ; z < maZ; ++z) {
                double distZ = ((double)(z + absZ) + 0.5 - cZ) / rXZ;
                double distZ2 = distZ * distZ;
                if (distX2 + distZ2 >= 1.0) continue;
                for (int y = maY; y > miY; --y) {
                    double distY = ((double)(y - 1) + 0.5 - cY) / rY;
                    double distY2 = distY * distY;
                    if (!((distX2 + distZ2) * (double)this.mut[y - 1] + distY2 / this.cutoff < 1.0)) continue;
                    sphere.inner.add(x, y, z);
                }
            }
        }
    }

    @Override
    protected void fillDouble(SphereData sphere, double cX, double cY, double cZ, int absX, int absZ, double rXZ, double rY, double roXZ, double roY, int miX, int maX, int miY, int maY, int miZ, int maZ) {
        double rXZ2 = rXZ * rXZ;
        double rY2 = rY * rY;
        double roXZ2 = roXZ * roXZ;
        double roY2 = roY * roY;
        int d = (int)(roY - rY);
        int miOY = Math.max(1, miY - d);
        int maOY = Math.min(248, maY + d);
        for (int x = miX; x < maX; ++x) {
            double distX = (double)(x + absX) + 0.5 - cX;
            double distX2 = distX * distX;
            for (int z = miZ; z < maZ; ++z) {
                double distZ = (double)(z + absZ) + 0.5 - cZ;
                double distZ2 = distZ * distZ;
                double sumRoXZ = distX2 / roXZ2 + distZ2 / roXZ2;
                if (sumRoXZ >= 1.0) continue;
                double sumRXZ = distX2 / rXZ2 + distZ2 / rXZ2;
                this.coverOuter(sphere, sumRoXZ, roY2, x, z, cY, miOY, miY);
                this.coverOuter(sphere, sumRoXZ, roY2, x, z, cY, maY, maOY);
                for (int y = maY; y > miY; --y) {
                    double distY = (double)(y - 1) + 0.5 - cY;
                    double distY2 = distY * distY;
                    if (sumRXZ * (double)this.mut[y - 1] + distY2 / rY2 / this.cutoff < 1.0) {
                        sphere.inner.add(x, y, z);
                        continue;
                    }
                    if (!(sumRoXZ * (double)this.mut[y - 1] + distY2 / roY2 / this.cutoff < 1.0)) continue;
                    sphere.shell.add(x, y, z);
                }
            }
        }
    }

    private void coverOuter(SphereData sphere, double sumRoXZ, double roY2, int x, int z, double cY, int min, int max) {
        if (this.cutoff > 1.0) {
            for (int y = max; y > min; --y) {
                double distY = (double)(y - 1) + 0.5 - cY;
                double distY2 = distY * distY;
                if (!(sumRoXZ * (double)this.mut[y - 1] + distY2 / roY2 / this.cutoff < 1.0)) continue;
                sphere.shell.add(x, y, z);
            }
        }
    }

    private void startRavine(World world, long seed, int destX, int destZ, int x, int z, ChunkPrimer primer) {
        XoRoShiRo rand = new XoRoShiRo(seed);
        int distance = this.cfg.distance;
        PrimerData data = new PrimerData(primer, x, z);
        TunnelPathInfo path = new TunnelPathInfo(this.cfg, (Random)rand, destX, destZ);
        if (this.conditions.getColumn((int)path.getX(), (int)path.getZ()).contains((int)path.getY()) && this.conditions.noise.GetBoolean(path.getX(), path.getY(), path.getZ())) {
            this.addRavine(world, ((Random)rand).nextLong(), data, path, distance);
        }
    }

    private void addRavine(World world, long seed, PrimerData data, TunnelPathInfo path, int distance) {
        XoRoShiRo mast = new XoRoShiRo(seed);
        XoRoShiRo dec = new XoRoShiRo(seed);
        distance = this.getDistance(mast, distance);
        this.fillMutations(mast);
        for (int currentPos = 0; currentPos < distance; ++currentPos) {
            double rXZ = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentPos * (float)Math.PI / (float)distance)) * path.getScale());
            double rY = rXZ * (double)path.getStretch();
            double d = this.decorators.shell.cfg.radius;
            double roXZ = rXZ + d;
            double roY = rY + d;
            path.update(mast, true, this.cfg.noiseYFactor, 0.05f);
            if (((Random)mast).nextInt(this.cfg.resolution) == 0) continue;
            if (path.travelledTooFar(data, currentPos, distance)) {
                return;
            }
            if (!path.touchesChunk(data, roXZ * 2.0) || this.getNearestBorder((int)path.getX(), (int)path.getZ()) < roXZ + 9.0 || !this.conditions.height.contains((int)path.getY())) continue;
            this.generateSphere(data, world, dec, path.getX(), path.getY(), path.getZ(), rXZ, rY, roXZ, roY);
        }
    }

    private void fillMutations(Random rand) {
        if (this.cfg.useWallNoise) {
            this.fillMutationsWithNoise();
        } else {
            this.fillMutationsVanilla(rand);
        }
    }

    private void fillMutationsVanilla(Random rand) {
        float val = 1.0f;
        for (int i = 0; i < this.mut.length; ++i) {
            if (i == 0 || rand.nextInt(3) == 0) {
                val = rand.nextFloat() * rand.nextFloat() + 1.0f;
            }
            this.mut[i] = val * val;
        }
    }

    private void fillMutationsWithNoise() {
        for (int i = 0; i < this.mut.length; ++i) {
            this.mut[i] = this.wallNoise.GetAdjustedNoise(0.0f, i);
        }
    }
}

