/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.Writer;
import org.hjson.HjsonParser;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonType;
import org.hjson.JsonValue;

class JsonWriter {
    boolean format;

    public JsonWriter(boolean format) {
        this.format = format;
    }

    void nl(Writer tw, int level) throws IOException {
        if (this.format) {
            tw.write(JsonValue.eol);
            for (int i = 0; i < level; ++i) {
                tw.write("  ");
            }
        }
    }

    public void save(JsonValue value, Writer tw, int level) throws IOException {
        boolean following = false;
        switch (value.getType()) {
            case OBJECT: {
                JsonObject obj = value.asObject();
                if (obj.size() > 0) {
                    this.nl(tw, level);
                }
                tw.write(123);
                for (JsonObject.Member pair : obj) {
                    if (following) {
                        tw.write(",");
                    }
                    this.nl(tw, level + 1);
                    tw.write(34);
                    tw.write(JsonWriter.escapeString(pair.getName()));
                    tw.write("\":");
                    JsonValue v = pair.getValue();
                    JsonType vType = v.getType();
                    if (this.format && vType != JsonType.ARRAY && vType != JsonType.OBJECT) {
                        tw.write(" ");
                    }
                    if (v == null) {
                        tw.write("null");
                    } else {
                        this.save(v, tw, level + 1);
                    }
                    following = true;
                }
                if (following) {
                    this.nl(tw, level);
                }
                tw.write(125);
                break;
            }
            case ARRAY: {
                JsonArray arr = value.asArray();
                int n = arr.size();
                if (n > 0) {
                    this.nl(tw, level);
                }
                tw.write(91);
                for (int i = 0; i < n; ++i) {
                    JsonValue v;
                    JsonType vType;
                    if (following) {
                        tw.write(",");
                    }
                    if ((vType = (v = arr.get(i)).getType()) != JsonType.ARRAY && vType != JsonType.OBJECT) {
                        this.nl(tw, level + 1);
                    }
                    this.save(v, tw, level + 1);
                    following = true;
                }
                if (following) {
                    this.nl(tw, level);
                }
                tw.write(93);
                break;
            }
            case BOOLEAN: {
                tw.write(value.isTrue() ? "true" : "false");
                break;
            }
            case STRING: {
                tw.write(34);
                tw.write(JsonWriter.escapeString(value.asString()));
                tw.write(34);
                break;
            }
            default: {
                tw.write(value.toString());
            }
        }
    }

    static String escapeName(String name) {
        boolean needsEscape = name.length() == 0;
        for (char ch : name.toCharArray()) {
            if (!HjsonParser.isWhitespace(ch) && ch != '{' && ch != '}' && ch != '[' && ch != ']' && ch != ',' && ch != ':') continue;
            needsEscape = true;
            break;
        }
        if (needsEscape) {
            return "\"" + JsonWriter.escapeString(name) + "\"";
        }
        return name;
    }

    static String escapeString(String src) {
        if (src == null) {
            return null;
        }
        for (int i = 0; i < src.length(); ++i) {
            if (JsonWriter.getEscapedChar(src.charAt(i)) == null) continue;
            StringBuilder sb = new StringBuilder();
            if (i > 0) {
                sb.append(src, 0, i);
            }
            return JsonWriter.doEscapeString(sb, src, i);
        }
        return src;
    }

    private static String doEscapeString(StringBuilder sb, String src, int cur) {
        int start = cur;
        for (int i = cur; i < src.length(); ++i) {
            String escaped = JsonWriter.getEscapedChar(src.charAt(i));
            if (escaped == null) continue;
            sb.append(src, start, i);
            sb.append(escaped);
            start = i + 1;
        }
        sb.append(src, start, src.length());
        return sb.toString();
    }

    private static String getEscapedChar(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }
}

