/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped;

import com.grimbo.chipped.block.ChippedBlocks;
import java.util.ArrayList;
import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.fml.RegistryObject;

public class ChippedTags {
    public static Hashtable<String, ITag.INamedTag<Block>> blocks = new Hashtable();
    public static Hashtable<String, ITag.INamedTag<Item>> items = new Hashtable();

    public static void register() {
        ChippedTags.createFromList("stones", ChippedBlocks.stones);
        ChippedTags.createFromList("wools", ChippedBlocks.wools);
        ChippedTags.createFromList("carpets", ChippedBlocks.carpets);
        ChippedTags.createFromList("glasses", ChippedBlocks.glasses);
        ChippedTags.createFromList("stained_glasses", ChippedBlocks.stainedGlasses);
        ChippedTags.createFromList("hay_blocks", ChippedBlocks.hayBlock);
        ChippedTags.createFromList("clays", ChippedBlocks.clays);
        ChippedTags.createFromList("terracottas", ChippedBlocks.terracottas);
        ChippedTags.createFromList("concretes", ChippedBlocks.concretes);
        ChippedTags.createFromList("woods", ChippedBlocks.woods);
        ChippedTags.createFromBlock("vines", (Block)ChippedBlocks.VINE_1.get());
    }

    private static void createFromBlock(String type, Block block) {
        String blockName = block.getRegistryName().func_110623_a().split("_([1-9])")[0];
        blocks.put(blockName, (ITag.INamedTag<Block>)Blocks.forge(type + "/" + blockName));
        items.put(blockName, (ITag.INamedTag<Item>)Items.forge(type + "/" + blockName));
    }

    private static void createFromList(String type, ArrayList<RegistryObject<Block>> list) {
        for (RegistryObject<Block> block : list) {
            String blockName = ((Block)block.get()).getRegistryName().func_110623_a().split("_([1-9])")[0];
            blocks.put(blockName, (ITag.INamedTag<Block>)Blocks.forge(type + "/" + blockName));
            items.put(blockName, (ITag.INamedTag<Item>)Items.forge(type + "/" + blockName));
        }
    }

    private static void createFromList(String type, String[] list) {
        for (String block : list) {
            blocks.put(block, (ITag.INamedTag<Block>)Blocks.forge(type + "/" + block));
            items.put(block, (ITag.INamedTag<Item>)Items.forge(type + "/" + block));
        }
    }

    public static class Items {
        private static ITag.INamedTag<Item> forge(String id) {
            return ItemTags.func_199901_a((String)("forge:" + id));
        }

        private static ITag.INamedTag<Item> mod(String id) {
            return ItemTags.func_199901_a((String)("chipped:" + id));
        }
    }

    public static class Blocks {
        private static ITag.INamedTag<Block> forge(String id) {
            return BlockTags.func_199894_a((String)("forge:" + id));
        }

        private static ITag.INamedTag<Block> mod(String id) {
            return BlockTags.func_199894_a((String)("chipped:" + id));
        }
    }
}

