/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.block;

import com.grimbo.chipped.Chipped;
import com.grimbo.chipped.block.ChippedWorkbench;
import com.grimbo.chipped.item.ChippedItems;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.CryingObsidianBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StainedGlassBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ChippedBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"chipped");
    public static ArrayList<RegistryObject<Block>> stones = new ArrayList();
    public static ArrayList<RegistryObject<Block>> wools = new ArrayList();
    public static ArrayList<RegistryObject<Block>> carpets = new ArrayList();
    public static ArrayList<RegistryObject<Block>> glasses = new ArrayList();
    public static ArrayList<RegistryObject<Block>> stainedGlasses = new ArrayList();
    public static ArrayList<RegistryObject<Block>> hayBlock = new ArrayList();
    public static ArrayList<RegistryObject<Block>> clays = new ArrayList();
    public static ArrayList<RegistryObject<Block>> terracottas = new ArrayList();
    public static ArrayList<RegistryObject<Block>> concretes = new ArrayList();
    public static ArrayList<RegistryObject<Block>> woods = new ArrayList();
    public static String[] stonesList = new String[]{"stone", "granite", "diorite", "andesite", "prismarine", "dark_prismarine", "purpur_block"};
    public static String[] stones2List = new String[]{"cobblestone", "quartz_block"};
    public static String[] stones3List = new String[]{"sandstone", "red_sandstone"};
    public static String[] stones4List = new String[]{"nether_bricks", "red_nether_bricks"};
    public static String[] stones5List = new String[]{"end_stone"};
    public static String[] colorsList = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static String[] woodsList = new String[]{"oak", "birch", "spruce", "jungle", "acacia", "dark_oak", "warped", "crimson"};
    public static final RegistryObject<Block> BOTANIST_WORKBENCH = ChippedBlocks.register(() -> new ChippedWorkbench(0, "botanist_workbench", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> GLASSBLOWER = ChippedBlocks.register(() -> new ChippedWorkbench(1, "glassblower", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> CARPENTERS_TABLE = ChippedBlocks.register(() -> new ChippedWorkbench(2, "carpenters_table", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> LOOM_TABLE = ChippedBlocks.register(() -> new ChippedWorkbench(3, "loom_table", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> MASON_TABLE = ChippedBlocks.register(() -> new ChippedWorkbench(4, "mason_table", AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> ALCHEMY_BENCH = ChippedBlocks.register(() -> new ChippedWorkbench(5, "alchemy_bench", AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid)));
    public static final RegistryObject<Block> VINE_1 = ChippedBlocks.register("vine_1", () -> new VineBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200942_a().func_200944_c().func_200943_b(0.2f).func_200947_a(SoundType.field_185850_c)));

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRender(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)BOTANIST_WORKBENCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)LOOM_TABLE.get()), (RenderType)RenderType.func_228643_e_());
        for (RegistryObject<Block> glass : glasses) {
            RenderTypeLookup.setRenderLayer((Block)((Block)glass.get()), (RenderType)RenderType.func_228643_e_());
        }
        for (RegistryObject<Block> stainedGlass : stainedGlasses) {
            RenderTypeLookup.setRenderLayer((Block)((Block)stainedGlass.get()), (RenderType)RenderType.func_228645_f_());
        }
        RenderTypeLookup.setRenderLayer((Block)((Block)VINE_1.get()), (RenderType)RenderType.func_228645_f_());
    }

    public static void register() {
        ChippedBlocks.registerStones();
        ChippedBlocks.registerStones2();
        ChippedBlocks.registerStones3();
        ChippedBlocks.registerStones4();
        ChippedBlocks.registerStones5();
        ChippedBlocks.registerStones6();
        ChippedBlocks.registerStones7();
        ChippedBlocks.registerWools();
        ChippedBlocks.registerCarpets();
        ChippedBlocks.registerGlasses();
        ChippedBlocks.registerWoodGlasses();
        ChippedBlocks.registerStainedGlasses();
        ChippedBlocks.registerHayBlocks();
        ChippedBlocks.registerClays();
        ChippedBlocks.registerTerracottas();
        ChippedBlocks.registerConcretes();
        ChippedBlocks.registerWoods();
        ChippedBlocks.registerStones8();
        ChippedBlocks.registerCryingObsidians();
        ChippedBlocks.registerObsidians();
        ChippedBlocks.registerBasalts();
    }

    private static void registerStones() {
        for (String stone : stonesList) {
            for (int i = 1; i <= 18; ++i) {
                stones.add(ChippedBlocks.register(stone + "_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(1.5f, 6.0f))));
            }
        }
    }

    private static void registerStones2() {
        for (String stone : stones2List) {
            for (int i = 1; i <= 18; ++i) {
                stones.add(ChippedBlocks.register(stone + "_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(2.0f, 6.0f))));
            }
        }
    }

    private static void registerStones3() {
        for (String stone : stones3List) {
            for (int i = 1; i <= 18; ++i) {
                stones.add(ChippedBlocks.register(stone + "_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200943_b(0.8f))));
            }
        }
    }

    private static void registerStones4() {
        for (String stone : stones4List) {
            for (int i = 1; i <= 18; ++i) {
                stones.add(ChippedBlocks.register(stone + "_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_235590_L_))));
            }
        }
    }

    private static void registerStones5() {
        for (String stone : stones5List) {
            for (int i = 1; i <= 18; ++i) {
                stones.add(ChippedBlocks.register(stone + "_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(3.0f, 9.0f))));
            }
        }
    }

    private static void registerStones6() {
        for (int i = 1; i <= 26; ++i) {
            stones.add(ChippedBlocks.register("gilded_blackstone_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235599_U_))));
        }
    }

    private static void registerStones7() {
        for (int i = 1; i <= 18; ++i) {
            stones.add(ChippedBlocks.register("netherrack_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200943_b(0.4f).func_200947_a(SoundType.field_235589_K_))));
        }
    }

    private static void registerStones8() {
        for (int i = 1; i <= 21; ++i) {
            stones.add(ChippedBlocks.register("blackstone_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235599_U_))));
        }
    }

    private static void registerWools() {
        for (String color : colorsList) {
            for (int i = 1; i <= 18; ++i) {
                wools.add(ChippedBlocks.register(color + "_wool_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200948_a(1.0f, 2.0f).func_200947_a(SoundType.field_185854_g))));
            }
        }
    }

    private static void registerCarpets() {
        for (String color : colorsList) {
            for (int i = 1; i <= 18; ++i) {
                carpets.add(ChippedBlocks.register(color + "_carpet_" + i, () -> new CarpetBlock(DyeColor.func_204271_a((String)color, (DyeColor)DyeColor.BLACK), AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.3f).func_200947_a(SoundType.field_185854_g))));
            }
        }
    }

    private static void registerGlasses() {
        for (int i = 1; i <= 14; ++i) {
            glasses.add(ChippedBlocks.register("glass_" + i, () -> new GlassBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid))));
        }
    }

    private static void registerWoodGlasses() {
        for (String wood : woodsList) {
            for (int i = 1; i <= 6; ++i) {
                glasses.add(ChippedBlocks.register(wood + "_wood_glass_" + i, () -> new GlassBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid))));
            }
        }
    }

    private static void registerStainedGlasses() {
        for (String color : colorsList) {
            for (int i = 1; i <= 8; ++i) {
                stainedGlasses.add(ChippedBlocks.register(color + "_stained_glass_" + i, () -> new StainedGlassBlock(DyeColor.func_204271_a((String)color, (DyeColor)DyeColor.BLACK), AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_235827_a_(ChippedBlocks::neverAllowSpawn).func_235828_a_(ChippedBlocks::isntSolid).func_235842_b_(ChippedBlocks::isntSolid).func_235847_c_(ChippedBlocks::isntSolid))));
            }
        }
    }

    private static void registerHayBlocks() {
        for (int i = 1; i <= 8; ++i) {
            hayBlock.add(ChippedBlocks.register("hay_block_" + i, () -> new HayBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c))));
        }
    }

    private static void registerClays() {
        for (int i = 1; i <= 19; ++i) {
            clays.add(ChippedBlocks.register("clay_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b))));
        }
    }

    private static void registerTerracottas() {
        for (String color : colorsList) {
            for (int i = 1; i <= 18; ++i) {
                terracottas.add(ChippedBlocks.register(color + "_terracotta_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.25f, 4.2f).func_200947_a(SoundType.field_185851_d).func_235861_h_())));
            }
        }
    }

    private static void registerConcretes() {
        for (String color : colorsList) {
            for (int i = 1; i <= 18; ++i) {
                concretes.add(ChippedBlocks.register(color + "_concrete_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(1.8f).func_200947_a(SoundType.field_185851_d).func_235861_h_())));
            }
        }
    }

    private static void registerWoods() {
        for (String wood : woodsList) {
            for (int i = 1; i <= 18; ++i) {
                woods.add(ChippedBlocks.register(wood + "_planks_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a))));
            }
        }
    }

    private static void registerCryingObsidians() {
        for (int i = 1; i <= 20; ++i) {
            stones.add(ChippedBlocks.register("crying_obsidian_" + i, () -> new CryingObsidianBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(50.0f, 1200.0f).func_200947_a(SoundType.field_185851_d).func_235861_h_().func_235838_a_(state -> 10))));
        }
    }

    private static void registerObsidians() {
        for (int i = 1; i <= 20; ++i) {
            stones.add(ChippedBlocks.register("obsidian_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(50.0f, 1200.0f).func_200947_a(SoundType.field_185851_d).func_235861_h_())));
        }
    }

    private static void registerBasalts() {
        for (int i = 1; i <= 20; ++i) {
            stones.add(ChippedBlocks.register("basalt_" + i, () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.25f, 4.2f).func_200947_a(SoundType.field_235587_I_).func_235861_h_())));
        }
    }

    private static boolean isntSolid(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    private static Boolean neverAllowSpawn(BlockState state, IBlockReader reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static <T extends Block> RegistryObject<Block> register(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ChippedItems.ITEMS.register(name, () -> new BlockItem((Block)toReturn.get(), new Item.Properties().func_200916_a(Chipped.CHIPPED)));
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Block> register(Supplier<ChippedWorkbench> block) {
        return ChippedBlocks.register(block.get().ITEM_ID, block);
    }
}

