/*
 * Decompiled with CFR 0.152.
 */
package com.grimbo.chipped.block;

import com.grimbo.chipped.container.AlchemyBenchContainer;
import com.grimbo.chipped.container.BotanistWorkbenchContainer;
import com.grimbo.chipped.container.CarpentersTableContainer;
import com.grimbo.chipped.container.GlassblowerContainer;
import com.grimbo.chipped.container.LoomTableContainer;
import com.grimbo.chipped.container.MasonTableContainer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChippedWorkbench
extends Block {
    private final int CONTAINER_ID;
    public final String ITEM_ID;
    private final ITextComponent CONTAINER_NAME;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape WORKBENCH_NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WORKBENCH_SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final EnumProperty<WorkbenchModelType> MODEL_TYPE = EnumProperty.func_177709_a((String)"model", WorkbenchModelType.class);

    public ChippedWorkbench(int containerId, String itemId, AbstractBlock.Properties properties) {
        super(properties);
        this.CONTAINER_ID = containerId;
        this.ITEM_ID = itemId;
        this.CONTAINER_NAME = new TranslationTextComponent("container.chipped." + itemId);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.MAIN)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(state.func_215699_b(worldIn, pos));
        return ActionResultType.CONSUME;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> {
            switch (this.CONTAINER_ID) {
                case 0: {
                    return new BotanistWorkbenchContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
                case 1: {
                    return new GlassblowerContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
                case 2: {
                    return new CarpentersTableContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
                case 3: {
                    return new LoomTableContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
                case 4: {
                    return new MasonTableContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
                case 5: {
                    return new AlchemyBenchContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos));
                }
            }
            return null;
        }, this.CONTAINER_NAME);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            BlockPos otherpos;
            BlockState otherstate;
            WorkbenchModelType workbenchModel = (WorkbenchModelType)((Object)state.func_177229_b(MODEL_TYPE));
            if (workbenchModel == WorkbenchModelType.MAIN && (otherstate = worldIn.func_180495_p(otherpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176746_e()))).func_177230_c() == this) {
                worldIn.func_180501_a(otherpos, Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, otherpos, Block.func_196246_j((BlockState)otherstate));
            }
            if (workbenchModel == WorkbenchModelType.SIDE && (otherstate = worldIn.func_180495_p(otherpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176735_f()))).func_177230_c() == this) {
                worldIn.func_180501_a(otherpos, Blocks.field_150350_a.func_176223_P(), 35);
                worldIn.func_217378_a(player, 2001, otherpos, Block.func_196246_j((BlockState)otherstate));
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176746_e());
            worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a(MODEL_TYPE, (Comparable)((Object)WorkbenchModelType.SIDE)), 3);
            worldIn.func_230547_a_(pos, Blocks.field_150350_a);
            state.func_235734_a_((IWorld)worldIn, pos, 3);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        switch (direction) {
            case NORTH: {
                return WORKBENCH_NORTH_SHAPE;
            }
            case SOUTH: {
                return WORKBENCH_SOUTH_SHAPE;
            }
            case WEST: {
                return WORKBENCH_WEST_SHAPE;
            }
        }
        return WORKBENCH_EAST_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        switch (direction) {
            case NORTH: {
                return WORKBENCH_NORTH_SHAPE;
            }
            case SOUTH: {
                return WORKBENCH_SOUTH_SHAPE;
            }
            case WEST: {
                return WORKBENCH_WEST_SHAPE;
            }
        }
        return WORKBENCH_EAST_SHAPE;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, MODEL_TYPE});
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos otherpos = pos.func_177972_a(((Direction)state.func_177229_b((Property)FACING)).func_176746_e());
        return worldIn.func_180495_p(otherpos).func_196958_f();
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public static enum WorkbenchModelType implements IStringSerializable
    {
        MAIN,
        SIDE;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

