/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.coldsteel.items;

import com.coldspell.coldsteel.abilities.checks.OnDamageItem;
import com.coldspell.coldsteel.abilities.checks.OnHitEntity;
import com.coldspell.coldsteel.abilities.checks.OnRightClick;
import com.coldspell.coldsteel.items.AbilityBonusItem;
import com.coldspell.coldsteel.util.enums.ColdNBT;
import com.coldspell.coldsteel.util.enums.ColdRandomizer;
import com.coldspell.coldsteel.util.enums.ColdSteelWeaponHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.enchantment.LootBonusEnchantment;
import net.minecraft.enchantment.MendingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ColdSteelWeapon
extends TieredItem
implements IVanishable {
    private final float attackDamage;
    private final int minRank;
    private final int xpToLevel;
    private final int minSlots;
    private final String ability1;
    private final int ability1Level;
    private final String ability2;
    private final int ability2Level;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public ColdSteelWeapon(IItemTier tier, int attackDamageIn, float attackSpeedIn, int minRank, int xpToLevel, int minSlots, @Nullable String ability1, int ability1Level, @Nullable String ability2, int ability2Level, Item.Properties builderIn) {
        super(tier, builderIn);
        this.attackDamage = (float)attackDamageIn + tier.func_200929_c();
        this.minRank = minRank;
        this.xpToLevel = xpToLevel;
        this.minSlots = minSlots;
        this.ability1 = ability1;
        this.ability1Level = ability1Level;
        this.ability2 = ability2;
        this.ability2Level = ability2Level;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (ColdSteelWeaponHelper.isUnlocked(stack)) {
            if (this.getRank(stack) < ColdSteelWeaponHelper.getMaxRank(stack)) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7bRANK: " + this.getRank(stack) + "/" + ColdSteelWeaponHelper.getMaxRank(stack)));
                tooltip.add((ITextComponent)new StringTextComponent("\u00a76XP: " + this.getXP(stack) + "/" + this.getXPToLevel(stack)));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75RANK: " + this.getRank(stack)));
            }
            if (this.getRank(stack) >= ColdSteelWeaponHelper.getMaxRank(stack)) {
                if (ColdSteelWeaponHelper.getMaxSlots(stack) - this.getSlotsUsed(stack) > 0) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a7eSockets: " + (ColdSteelWeaponHelper.getMaxSlots(stack) - this.getSlotsUsed(stack))));
                }
            } else if (ColdSteelWeaponHelper.getMaxSlots(stack) - this.getSlotsUsed(stack) > 0) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7cSockets: " + (ColdSteelWeaponHelper.getMaxSlots(stack) - this.getSlotsUsed(stack))));
                tooltip.add((ITextComponent)new StringTextComponent("\u00a7cSockets Unlock at Max Rank"));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a75RANK: 0"));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a76XP: " + this.getXP(stack) + "/" + this.getXPToLevel(stack)));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a7cReveal your Weapons Potential"));
            tooltip.add((ITextComponent)new StringTextComponent("\u00a7cby reaching Rank 1"));
        }
        if (ColdNBT.getReinforced(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Reinforced " + ColdNBT.getReinforced(stack)));
        }
        if (ColdNBT.getBlinding(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Blinding "));
        }
        if (ColdNBT.getWither(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Wither "));
        }
        if (ColdNBT.getFlurry(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Flurry " + ColdNBT.getFlurry(stack)));
        }
        if (ColdNBT.getLevitate(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Levitate "));
        }
        if (ColdNBT.getStrength(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Strength " + ColdNBT.getStrength(stack)));
        }
        if (ColdNBT.getCrit(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Crit " + ColdNBT.getCrit(stack)));
        }
        if (ColdNBT.getCounter(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Counter " + ColdNBT.getCounter(stack)));
        }
        if (ColdNBT.getMomentum(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Momentum " + ColdNBT.getMomentum(stack)));
        }
        if (ColdNBT.getWarding(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Warding " + ColdNBT.getWarding(stack)));
        }
        if (ColdNBT.getLifeSteal(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Life Stealing " + ColdNBT.getLifeSteal(stack)));
        }
        if (ColdNBT.getHealing(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Healing " + ColdNBT.getHealing(stack)));
        }
        if (ColdNBT.getNourish(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Nourishment " + ColdNBT.getNourish(stack)));
        }
        if (ColdNBT.getVenom(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Venomous " + ColdNBT.getVenom(stack)));
        }
        if (ColdNBT.getFreeze(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Freezing " + ColdNBT.getFreeze(stack)));
        }
        if (ColdNBT.getFirebrand(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Firebrand " + ColdNBT.getFirebrand(stack)));
        }
        if (ColdNBT.getSteal(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Stealing " + ColdNBT.getSteal(stack)));
        }
        if (ColdNBT.getButcher(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Butchering " + ColdNBT.getButcher(stack)));
        }
        if (ColdNBT.getTorchbringer(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Torchbringer"));
        }
        if (ColdNBT.getCleave(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Cleave " + ColdNBT.getCleave(stack)));
        }
        if (ColdNBT.getGravity(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gravity " + ColdNBT.getGravity(stack)));
        }
        if (ColdNBT.getWisdom(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Wisdom " + ColdNBT.getWisdom(stack)));
        }
        if (ColdNBT.getFrostball(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Frostball " + ColdNBT.getFrostball(stack)));
        }
        if (ColdNBT.getFireball(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Fireball " + ColdNBT.getFireball(stack)));
        }
        if (ColdNBT.getEnderThrow(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Ender Throw"));
        }
        if (ColdNBT.getFrostfire(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Frostfire" + ColdNBT.getFrostfire(stack)));
        }
        if (ColdNBT.getRenew(stack) > 0) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Renew"));
        }
        tooltip.add((ITextComponent)new StringTextComponent("\u00a78iLevel: " + ((float)(ColdSteelWeaponHelper.getMaxRank(stack) + ColdSteelWeaponHelper.getMaxSlots(stack)) + this.getAttackDamage()) * 0.5f));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public void addAbility(ItemStack stack, String ability, int addAmount) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b(ability)) {
            nbt.func_74768_a(ability, nbt.func_74762_e(ability) + addAmount);
        } else {
            nbt.func_74768_a(ability, addAmount);
        }
    }

    public int getRank(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("rank")) {
            return nbt.func_74762_e("rank");
        }
        return 0;
    }

    public void setRank(ItemStack stack, int rank) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("rank", Math.min(rank, ColdSteelWeaponHelper.getMaxRank(stack)));
    }

    public int getSlotsUsed(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("slotsused")) {
            return nbt.func_74762_e("slotsused");
        }
        return 0;
    }

    public void setSlotsUsed(ItemStack stack, int rank) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("slotsused", Math.min(rank, ColdSteelWeaponHelper.getMaxRank(stack)));
    }

    public void addUsedSlot(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("slotsused")) {
            nbt.func_74768_a("slotsused", nbt.func_74762_e("slotsused") + 1);
        } else {
            nbt.func_74768_a("slotsused", 1);
        }
    }

    public int getXP(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("xp")) {
            return nbt.func_74762_e("xp");
        }
        return 0;
    }

    public void setXP(ItemStack stack, int xp) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("xp", xp);
    }

    public int getXPToLevel(ItemStack stack) {
        int xpToRankOne = this.xpToLevel;
        if (this.getRank(stack) != 0) {
            return (int)((double)(this.getRank(stack) * xpToRankOne) * 2.1);
        }
        return xpToRankOne;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.setXP(stack, this.getXP(stack) + 1);
        OnHitEntity.abilityCheck(stack, target, attacker);
        OnDamageItem.attemptDamage(stack);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.func_201670_d()) {
            if (ColdSteelWeaponHelper.getMaxRank(stack) == 0) {
                ColdSteelWeaponHelper.setMaxRank(stack, 1);
            }
            if (this.getRank(stack) == ColdSteelWeaponHelper.getMaxRank(stack) && !ColdSteelWeaponHelper.isUnlocked(stack)) {
                ColdSteelWeaponHelper.rankOne(stack, this.minRank, this.minSlots);
            } else if (this.getRank(stack) < ColdSteelWeaponHelper.getMaxRank(stack) && this.getXP(stack) >= this.getXPToLevel(stack)) {
                this.gainRank(stack);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment instanceof MendingEnchantment || enchantment instanceof LootBonusEnchantment;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184614_ca();
        ItemStack offItem = playerIn.func_184592_cb();
        if (!worldIn.field_72995_K) {
            if (offItem.func_77973_b() instanceof AbilityBonusItem) {
                AbilityBonusItem abilityBonusItem = (AbilityBonusItem)offItem.func_77973_b();
                if (abilityBonusItem.abilityIn.equals("xp")) {
                    if (ColdSteelWeaponHelper.getMaxRank(itemstack) > this.getRank(itemstack)) {
                        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                        this.gainRank(itemstack);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            offItem.func_190918_g(1);
                        }
                    }
                } else if (abilityBonusItem.abilityIn.equals("slotsused")) {
                    if (ColdSteelWeaponHelper.getMaxRank(itemstack) > this.getRank(itemstack)) {
                        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187825_fO, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                        this.addAbility(itemstack, abilityBonusItem.abilityIn, abilityBonusItem.abilityAdd);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            offItem.func_190918_g(1);
                        }
                    }
                } else if (this.getRank(itemstack) >= ColdSteelWeaponHelper.getMaxRank(itemstack) && ColdSteelWeaponHelper.getMaxSlots(itemstack) - this.getSlotsUsed(itemstack) > 0) {
                    if (abilityBonusItem.abilityIn.equals("random")) {
                        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187654_U, SoundCategory.NEUTRAL, 0.5f, 2.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                        ColdRandomizer.giveRandomAbility(itemstack);
                        this.addUsedSlot(itemstack);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            offItem.func_190918_g(1);
                        }
                    } else if (abilityBonusItem.canAddAbility(itemstack)) {
                        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187654_U, SoundCategory.NEUTRAL, 0.5f, 2.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                        this.addAbility(itemstack, abilityBonusItem.abilityIn, abilityBonusItem.abilityAdd);
                        this.addUsedSlot(itemstack);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            offItem.func_190918_g(1);
                        }
                    }
                }
            }
            if (!(offItem.func_77973_b() instanceof AbilityBonusItem)) {
                OnRightClick.click(worldIn, playerIn, handIn);
                OnDamageItem.attemptDamage(itemstack);
            }
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        return ActionResult.func_233538_a_((Object)playerIn.func_184586_b(handIn), (boolean)worldIn.func_201670_d());
    }

    private void gainRank(ItemStack stack) {
        this.setRank(stack, this.getRank(stack) + 1);
        this.setXP(stack, 0);
        ColdRandomizer.giveRandomAbility(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        if (this.ability1 != null) {
            this.setAbility(stack, this.ability1, this.ability1Level);
        }
        if (this.ability2 != null) {
            this.setAbility(stack, this.ability2, this.ability2Level);
        }
        return super.func_77636_d(stack);
    }

    private void setAbility(ItemStack stack, String ability, int abilityLevel) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b(ability)) {
            if (nbt.func_74762_e(ability) < abilityLevel) {
                nbt.func_74768_a(ability, abilityLevel);
            }
        } else {
            nbt.func_74768_a(ability, abilityLevel);
        }
    }
}

