/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.consecration.common.impl;

import com.illusivesoulworks.consecration.api.ConsecrationApi;
import com.illusivesoulworks.consecration.api.UndeadType;
import com.illusivesoulworks.consecration.common.config.ConsecrationConfig;
import com.illusivesoulworks.consecration.common.impl.UndeadTypes;
import com.illusivesoulworks.consecration.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiFunction;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1686;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class HolySources {
    private static final Queue<BiFunction<class_1309, class_1282, Boolean>> HOLY_ATTACKS = new ConcurrentLinkedQueue<BiFunction<class_1309, class_1282, Boolean>>();
    private static final Queue<BiFunction<class_1309, class_1282, Integer>> HOLY_PROTECTION = new ConcurrentLinkedQueue<BiFunction<class_1309, class_1282, Integer>>();
    private static final Set<String> HOLY_MATERIALS = new HashSet<String>();
    private static class_6862<class_8110> HOLY_DAMAGES = null;

    public static void reloadConfigs() {
        HOLY_MATERIALS.clear();
        HOLY_MATERIALS.addAll((Collection)ConsecrationConfig.CONFIG.holyMaterials.get());
    }

    public static void addHolyAttack(BiFunction<class_1309, class_1282, Boolean> func) {
        HOLY_ATTACKS.add(func);
    }

    public static void addHolyProtection(BiFunction<class_1309, class_1282, Integer> func) {
        HOLY_PROTECTION.add(func);
    }

    public static boolean contains(class_1792 item) {
        return Services.REGISTRY.isHolyTag(item);
    }

    public static boolean contains(class_1291 effect) {
        return Services.REGISTRY.isHolyTag(effect);
    }

    public static boolean contains(class_1887 enchantment) {
        return Services.REGISTRY.isHolyTag(enchantment);
    }

    public static boolean contains(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        ArrayList effects = new ArrayList();
        if (entity instanceof class_1686) {
            effects.addAll(class_1844.method_8067((class_1799)((class_1686)entity).method_7495()));
        } else if (entity instanceof class_1295) {
            class_1295 cloud = (class_1295)entity;
            effects.addAll(cloud.method_35048().method_8049());
        }
        for (class_1293 effect : effects) {
            if (!HolySources.contains(effect.method_5579())) continue;
            return true;
        }
        return Services.REGISTRY.isHolyTag(entity.method_5864());
    }

    public static int getHolyProtectionLevel(class_1309 attacker, class_1309 defender, class_1282 damageSource) {
        if (UndeadTypes.getType(attacker) == UndeadType.RESISTANT) {
            return 0;
        }
        int level = 0;
        for (class_1799 class_17992 : defender.method_5661()) {
            if (class_17992.method_7960()) continue;
            class_1792 item = class_17992.method_7909();
            if (item instanceof class_1738) {
                class_1741 material = ((class_1738)item).method_7686();
                class_1856 ing = material.method_7695();
                if (ing == null) continue;
                for (class_1799 mat : ing.method_8105()) {
                    class_2960 resourceLocation = Services.REGISTRY.getKey(mat.method_7909());
                    if (resourceLocation == null || !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.toString()) && !ConsecrationApi.getInstance().isHolyMaterial(resourceLocation.method_12832())) continue;
                    ++level;
                }
                continue;
            }
            if (!ConsecrationApi.getInstance().isHolyItem(class_17992)) continue;
            ++level;
        }
        for (BiFunction biFunction : HOLY_PROTECTION) {
            level += ((Integer)biFunction.apply(defender, damageSource)).intValue();
        }
        return level;
    }

    public static boolean isHolyAttack(class_1309 livingEntity, class_1282 damageSource) {
        for (BiFunction biFunction : HOLY_ATTACKS) {
            if (!((Boolean)biFunction.apply(livingEntity, damageSource)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMaterial(String material) {
        for (String holyMaterial : HOLY_MATERIALS) {
            String pattern = "(^|\\w*[_-])" + holyMaterial + "(\\b|[_-]\\w*)";
            if (!material.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDamage(class_1282 damageSource) {
        if (HOLY_DAMAGES == null) {
            HOLY_DAMAGES = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)new class_2960("consecration", "holy"));
        }
        return damageSource.method_48789(HOLY_DAMAGES);
    }
}

