/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppedEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationSeed;
import top.theillusivec4.consecration.common.HolyRegistry;
import top.theillusivec4.consecration.common.capability.UndyingCapability;
import top.theillusivec4.consecration.common.integration.AbstractModule;
import top.theillusivec4.consecration.common.integration.SilentGearModule;
import top.theillusivec4.consecration.common.registry.ConsecrationRegistry;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

@Mod(value="consecration")
public class Consecration {
    public static final String MODID = "consecration";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Map<String, Class<? extends AbstractModule>> MODULES = new HashMap<String, Class<? extends AbstractModule>>();
    public static final List<AbstractModule> ACTIVE_MODULES = new ArrayList<AbstractModule>();

    public Consecration() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::registerCaps);
        eventBus.addListener(this::imcEnqueue);
        eventBus.addListener(this::imcProcess);
        eventBus.addListener(this::config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConsecrationConfig.CONFIG_SPEC);
        MODULES.forEach((id, module) -> {
            if (ModList.get().isLoaded(id)) {
                try {
                    ACTIVE_MODULES.add((AbstractModule)module.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error("Error adding module for mod " + id);
                }
            }
        });
    }

    private void setup(FMLCommonSetupEvent evt) {
        UndyingCapability.register();
        CriteriaTriggers.m_10595_((CriterionTrigger)SmiteTrigger.INSTANCE);
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43602_)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42436_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.HOLY_POTION));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.HOLY_POTION)}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ConsecrationRegistry.STRONG_HOLY_POTION));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void imcEnqueue(InterModEnqueueEvent evt) {
        ACTIVE_MODULES.forEach(AbstractModule::enqueueImc);
    }

    private void imcProcess(InterModProcessEvent evt) {
        ConsecrationSeed.registerImc(evt.getIMCStream());
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(UndyingCapability.IUndying.class);
    }

    private void config(ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MODID)) {
            ConsecrationConfig.bake();
        }
    }

    @SubscribeEvent
    public void serverStart(FMLServerAboutToStartEvent evt) {
        ConsecrationApi.setHolyRegistry(new HolyRegistry());
        ConsecrationSeed.fillRegistry();
    }

    @SubscribeEvent
    public void serverStopped(FMLServerStoppedEvent evt) {
        ConsecrationApi.setHolyRegistry(null);
    }

    @SubscribeEvent
    public void makeCampfireArrow(PlayerInteractEvent.RightClickBlock evt) {
        Player player;
        Block block;
        ItemStack stack = evt.getItemStack();
        if (stack.m_41720_() == Items.f_42412_ && ((block = (player = evt.getPlayer()).m_20193_().m_8055_(evt.getPos()).m_60734_()) == Blocks.f_50683_ || block == Blocks.f_50684_)) {
            stack.m_41774_(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ConsecrationRegistry.FIRE_ARROW), (int)player.m_150109_().f_35977_);
        }
    }

    static {
        MODULES.put("silentgear", SilentGearModule.class);
    }
}

