/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.ConsecrationConfig;

public class ConsecrationUtils {
    public static int protect(LivingEntity attacker, LivingEntity protect, DamageSource source) {
        if (ConsecrationUtils.getUndeadType(attacker.m_6095_()) == ConsecrationApi.UndeadType.ABSOLUTE) {
            return 0;
        }
        int[] level = new int[1];
        for (ItemStack itemStack : protect.m_6168_()) {
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorMaterial material = ((ArmorItem)item).m_40401_();
                for (ItemStack mat : material.m_6230_().m_43908_()) {
                    ResourceLocation resourceLocation = mat.m_41720_().getRegistryName();
                    if (resourceLocation == null || !ConsecrationUtils.containsHolyMaterial(resourceLocation)) continue;
                    level[0] = level[0] + 1;
                }
                continue;
            }
            if (!ConsecrationUtils.isHolyItem(item)) continue;
            level[0] = level[0] + 1;
        }
        for (BiFunction biFunction : ConsecrationApi.getHolyRegistry().getHolyProtection()) {
            level[0] = level[0] + (Integer)biFunction.apply(protect, source);
        }
        return level[0];
    }

    public static DamageType smite(LivingEntity target, DamageSource source) {
        ConsecrationApi.UndeadType undeadType = ConsecrationUtils.getUndeadType(target.m_6095_());
        if (undeadType == ConsecrationApi.UndeadType.ABSOLUTE) {
            return DamageType.NONE;
        }
        if (!target.m_6095_().m_20672_() && source.m_19384_() && undeadType != ConsecrationApi.UndeadType.UNHOLY) {
            return DamageType.FIRE;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)entity;
            ItemStack stack = damager.m_21205_();
            Item item = stack.m_41720_();
            Item item2 = item;
            if (item2 instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item2;
                Tier tier = tieredItem.m_43314_();
                for (ItemStack mat : tier.m_6282_().m_43908_()) {
                    ResourceLocation resourceLocation = mat.m_41720_().getRegistryName();
                    if (resourceLocation == null || !ConsecrationUtils.containsHolyMaterial(resourceLocation)) continue;
                    return DamageType.HOLY;
                }
            }
            if (ConsecrationUtils.isHolyItem(item) || ConsecrationUtils.hasHolyEnchantment(stack)) {
                return DamageType.HOLY;
            }
        }
        if (ConsecrationUtils.isHolyDamage(source) || ConsecrationUtils.isHolyEntity(source.m_7640_()) || ConsecrationUtils.isHolyPotion(source.m_7640_())) {
            return DamageType.HOLY;
        }
        return ConsecrationUtils.processHolyFunctions(target, source);
    }

    public static boolean isUndying(LivingEntity livingEntity) {
        return ConsecrationUtils.isValidCreature(livingEntity) && ConsecrationUtils.isValidDimension(livingEntity.m_20193_().m_46472_().m_135782_());
    }

    public static boolean isValidCreature(LivingEntity livingEntity) {
        return ConsecrationConfig.defaultUndead && livingEntity.m_6336_() == MobType.f_21641_ || ConsecrationApi.getHolyRegistry().getUndead().containsKey(livingEntity.m_6095_());
    }

    public static boolean isValidDimension(ResourceLocation resourceLocation) {
        Set<ResourceLocation> dimensions = ConsecrationConfig.dimensions;
        ConsecrationConfig.PermissionMode permissionMode = ConsecrationConfig.dimensionPermission;
        if (dimensions.isEmpty()) {
            return true;
        }
        if (permissionMode == ConsecrationConfig.PermissionMode.BLACKLIST) {
            return !dimensions.contains(resourceLocation);
        }
        return dimensions.contains(resourceLocation);
    }

    public static boolean containsUndead(EntityType<?> entityType) {
        return ConsecrationApi.getHolyRegistry().getUndead().containsKey(entityType);
    }

    public static ConsecrationApi.UndeadType getUndeadType(EntityType<?> entityType) {
        return ConsecrationApi.getHolyRegistry().getUndead().getOrDefault(entityType, ConsecrationApi.UndeadType.NORMAL);
    }

    public static boolean isHolyEffect(MobEffect effect) {
        return ConsecrationApi.getHolyRegistry().getHolyEffects().contains(effect);
    }

    public static boolean isHolyPotion(Entity entity) {
        ArrayList effects = Lists.newArrayList();
        if (entity instanceof ThrownPotion) {
            effects.addAll(PotionUtils.m_43547_((ItemStack)((ThrownPotion)entity).m_7846_()));
        } else {
            Entity entity2 = entity;
            if (entity2 instanceof AreaEffectCloud) {
                AreaEffectCloud cloud = (AreaEffectCloud)entity2;
                effects.addAll(cloud.m_146791_().m_43488_());
            }
        }
        Set<MobEffect> holyEffects = ConsecrationApi.getHolyRegistry().getHolyEffects();
        for (MobEffectInstance effect : effects) {
            MobEffect potion = effect.m_19544_();
            if (!holyEffects.contains(potion)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHolyEnchantment(ItemStack stack) {
        Set<Enchantment> enchantments = ConsecrationApi.getHolyRegistry().getHolyEnchantments();
        for (Enchantment enchantment : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
            if (!enchantments.contains(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static DamageType processHolyFunctions(LivingEntity target, DamageSource source) {
        for (BiFunction<LivingEntity, DamageSource, Boolean> func : ConsecrationApi.getHolyRegistry().getHolyAttacks()) {
            if (!func.apply(target, source).booleanValue()) continue;
            return DamageType.HOLY;
        }
        return DamageType.NONE;
    }

    public static boolean isHolyEntity(@Nullable Entity entity) {
        return entity != null && ConsecrationApi.getHolyRegistry().getHolyEntities().contains(entity.m_6095_());
    }

    public static boolean isHolyDamage(DamageSource source) {
        return ConsecrationApi.getHolyRegistry().getHolyDamage().contains(source.m_19385_());
    }

    public static boolean isHolyItem(Item item) {
        return ConsecrationApi.getHolyRegistry().getHolyItems().contains(item);
    }

    public static boolean containsHolyMaterial(ResourceLocation resourceLocation) {
        for (String mat : ConsecrationApi.getHolyRegistry().getHolyMaterials()) {
            String pattern = "^" + mat + "(\\b|[_-]\\w*)";
            if (!resourceLocation.m_135815_().matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public static enum DamageType {
        NONE,
        FIRE,
        HOLY;

    }
}

