/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.ConsecrationConfig;
import top.theillusivec4.consecration.common.ConsecrationUtils;
import top.theillusivec4.consecration.common.capability.UndyingCapability;
import top.theillusivec4.consecration.common.trigger.SmiteTrigger;

public class CapabilityEventsHandler {
    private static final UUID SPEED_MOD = UUID.fromString("b812ef3d-0ef9-4368-845b-fad7003a1f4f");

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof LivingEntity) {
            evt.addCapability(UndyingCapability.ID, (ICapabilityProvider)new UndyingCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_20193_().f_46443_ && ConsecrationUtils.isUndying(livingEntity)) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                AttributeInstance speedAttribute = livingEntity.m_21051_(Attributes.f_22279_);
                if (speedAttribute != null) {
                    speedAttribute.m_22120_(SPEED_MOD);
                }
                if (undying.hasSmite()) {
                    if (livingEntity.f_19797_ % 10 == 0) {
                        ServerLevel world = (ServerLevel)livingEntity.m_20193_();
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123751_, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() / 2.0, livingEntity.m_20189_(), 2, (double)livingEntity.m_20205_() / 2.0, (double)livingEntity.m_20206_() / 4.0, (double)livingEntity.m_20205_() / 2.0, 0.0);
                    }
                    undying.tickSmite();
                } else {
                    double speedMod;
                    if (livingEntity.f_19797_ % 20 == 0 && livingEntity.m_21223_() < livingEntity.m_21233_()) {
                        livingEntity.m_5634_((float)ConsecrationConfig.healthRegen);
                    }
                    if ((speedMod = ConsecrationConfig.speedModifier) > 0.0 && speedAttribute != null && speedAttribute.m_22111_(SPEED_MOD) == null) {
                        speedAttribute.m_22118_(new AttributeModifier(SPEED_MOD, "Undead speed", speedMod, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onPotionAdded(PotionEvent.PotionAddedEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_20193_().f_46443_ && ConsecrationUtils.isUndying(livingEntity)) {
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            undyingOpt.ifPresent(undying -> {
                MobEffect effect1;
                MobEffectInstance effectInstance = evt.getPotionEffect();
                Set<MobEffect> effect = ConsecrationApi.getHolyRegistry().getHolyEffects();
                if (effect.contains(effect1 = effectInstance.m_19544_())) {
                    int duration = effect1.m_8093_() ? ((Integer)ConsecrationConfig.CONFIG.holySmiteDuration.get()).intValue() : effectInstance.m_19557_();
                    undying.setSmiteDuration(duration * 20);
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.m_20193_().f_46443_ && ConsecrationUtils.isUndying(livingEntity)) {
            Entity entity;
            LazyOptional<UndyingCapability.IUndying> undyingOpt = UndyingCapability.getCapability(livingEntity);
            if (!undyingOpt.isPresent() && (entity = evt.getSource().m_7640_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                LazyOptional<UndyingCapability.IUndying> undyingOpt2 = UndyingCapability.getCapability(attacker);
                undyingOpt2.ifPresent(undying -> {
                    int level = ConsecrationUtils.protect(attacker, livingEntity, evt.getSource());
                    if (level > 0 && livingEntity.m_20193_().f_46441_.nextFloat() < 0.15f * (float)level) {
                        undying.setSmiteDuration((Integer)ConsecrationConfig.CONFIG.holySmiteDuration.get() * 20);
                    }
                });
            }
            undyingOpt.ifPresent(undying -> {
                Entity trueSource;
                DamageSource source = evt.getSource();
                if (source == DamageSource.f_19317_ || source == DamageSource.f_19311_ || source == DamageSource.f_19310_) {
                    return;
                }
                ConsecrationUtils.DamageType type = ConsecrationUtils.smite(livingEntity, source);
                if (type != ConsecrationUtils.DamageType.NONE) {
                    if (type == ConsecrationUtils.DamageType.FIRE) {
                        undying.setSmiteDuration(ConsecrationConfig.fireSmiteDuration * 20);
                    } else {
                        undying.setSmiteDuration(ConsecrationConfig.holySmiteDuration * 20);
                    }
                    if (source.m_7639_() instanceof ServerPlayer) {
                        SmiteTrigger.INSTANCE.trigger((ServerPlayer)source.m_7639_());
                    }
                } else if (!source.m_19379_() && !undying.hasSmite() && (trueSource = source.m_7639_()) != null && (trueSource instanceof Player || ConsecrationConfig.bystanderNerf)) {
                    evt.setAmount(evt.getAmount() * (float)(1.0 - ConsecrationConfig.damageReduction));
                }
            });
        }
    }
}

