/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.consecration.common.capability.CapabilityEventsHandler;

public class UndyingCapability {
    public static final Capability<IUndying> UNDYING_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IUndying>(){});
    public static final ResourceLocation ID = new ResourceLocation("consecration", "undying");
    private static final String SMITE_TAG = "smite";

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEventsHandler());
    }

    public static LazyOptional<IUndying> getCapability(LivingEntity entity) {
        return entity.getCapability(UNDYING_CAP);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IUndying> optional;
        final IUndying data = new Undying();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return UNDYING_CAP.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.data.writeTag();
        }

        public void deserializeNBT(Tag nbt) {
            Tag tag = nbt;
            if (tag instanceof CompoundTag) {
                CompoundTag tag2 = (CompoundTag)tag;
                this.data.readTag(tag2);
            }
        }
    }

    public static class Undying
    implements IUndying {
        private int smiteDuration = 0;

        @Override
        public boolean hasSmite() {
            return this.smiteDuration > 0;
        }

        @Override
        public int getSmiteDuration() {
            return this.smiteDuration;
        }

        @Override
        public void setSmiteDuration(int duration) {
            this.smiteDuration = duration;
        }

        @Override
        public void tickSmite() {
            if (this.smiteDuration > 0) {
                --this.smiteDuration;
            }
        }

        @Override
        public void readTag(CompoundTag tag) {
            this.setSmiteDuration(tag.m_128451_(UndyingCapability.SMITE_TAG));
        }

        @Override
        public CompoundTag writeTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(UndyingCapability.SMITE_TAG, this.getSmiteDuration());
            return tag;
        }
    }

    public static interface IUndying {
        public boolean hasSmite();

        public int getSmiteDuration();

        public void setSmiteDuration(int var1);

        public void tickSmite();

        public void readTag(CompoundTag var1);

        public CompoundTag writeTag();
    }
}

