/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.integration;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.InterModComms;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.integration.AbstractModule;

public class SilentGearModule
extends AbstractModule {
    @Override
    public void enqueueImc() {
        InterModComms.sendTo((String)"consecration", (String)"holy_attack", () -> (livingEntity, damageSource) -> {
            if (damageSource.m_7640_() instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)damageSource.m_7640_()).m_21205_();
                return SilentGearModule.containsHolyMaterial(stack);
            }
            return false;
        });
        InterModComms.sendTo((String)"consecration", (String)"holy_protection", () -> (livingEntity, damageSource) -> {
            int level = 0;
            for (ItemStack stack : livingEntity.m_6168_()) {
                if (!SilentGearModule.containsHolyMaterial(stack)) continue;
                ++level;
            }
            return level;
        });
    }

    private static boolean containsHolyMaterial(ItemStack stack) {
        if (GearHelper.isGear((ItemStack)stack)) {
            PartDataList data = GearData.getConstructionParts((ItemStack)stack);
            for (PartData partData : data) {
                ItemStack crafting = partData.getItem();
                CompoundTag tag = crafting.m_41783_();
                if (tag == null) continue;
                ListTag list = tag.m_128437_("Materials", 10);
                for (Tag inbt : list) {
                    CompoundTag entry = (CompoundTag)inbt;
                    if (!SilentGearModule.containsHolyMaterial(new ResourceLocation(entry.m_128461_("ID")))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean containsHolyMaterial(ResourceLocation resourceLocation) {
        for (String mat : ConsecrationApi.getHolyRegistry().getHolyMaterials()) {
            String pattern = "^" + mat + "(\\b|[_-]\\w*)";
            if (!resourceLocation.m_135815_().matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

